
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "tosa"

@_ods_cext.register_operation(_Dialect)
class AbsOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.abs"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def abs(output, input1, *, loc=None, ip=None) -> _ods_ir.Value:
  return AbsOp(output=output, input1=input1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AddOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.add"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def add(output, input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return AddOp(output=output, input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ApplyScaleOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.apply_scale"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, value, multiplier, shift, double_round, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(value)
    operands.append(multiplier)
    operands.append(shift)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["double_round"] = (double_round if (
    isinstance(double_round, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(double_round, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def multiplier(self):
    return self.operation.operands[1]

  @builtins.property
  def shift(self):
    return self.operation.operands[2]

  @builtins.property
  def double_round(self):
    return self.operation.attributes["double_round"]

  @double_round.setter
  def double_round(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["double_round"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def apply_scale(output, value, multiplier, shift, double_round, *, loc=None, ip=None) -> _ods_ir.Value:
  return ApplyScaleOp(output=output, value=value, multiplier=multiplier, shift=shift, double_round=double_round, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ArgMaxOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.argmax"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, axis, *, nan_mode=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(axis, context=_ods_context))
    if nan_mode is not None: attributes["nan_mode"] = (nan_mode if (
        isinstance(nan_mode, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Tosa_NanPropagationAttr')) else
          _ods_ir.AttrBuilder.get('Tosa_NanPropagationAttr')(nan_mode, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def axis(self):
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def nan_mode(self):
    return self.operation.attributes["nan_mode"]

  @nan_mode.setter
  def nan_mode(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["nan_mode"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def argmax(output, input, axis, *, nan_mode=None, loc=None, ip=None) -> _ods_ir.Value:
  return ArgMaxOp(output=output, input=input, axis=axis, nan_mode=nan_mode, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ArithmeticRightShiftOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.arithmetic_right_shift"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, round, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["round"] = (round if (
    isinstance(round, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(round, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def round(self):
    return self.operation.attributes["round"]

  @round.setter
  def round(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["round"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def arithmetic_right_shift(output, input1, input2, round, *, loc=None, ip=None) -> _ods_ir.Value:
  return ArithmeticRightShiftOp(output=output, input1=input1, input2=input2, round=round, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AvgPool2dOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.avg_pool2d"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, kernel, stride, pad, acc_type, *, input_zp=None, output_zp=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["kernel"] = (kernel if (
    isinstance(kernel, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr2')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr2')(kernel, context=_ods_context))
    attributes["stride"] = (stride if (
    isinstance(stride, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr2')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr2')(stride, context=_ods_context))
    attributes["pad"] = (pad if (
    isinstance(pad, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr4')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr4')(pad, context=_ods_context))
    attributes["acc_type"] = (acc_type if (
    isinstance(acc_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_565')) else
      _ods_ir.AttrBuilder.get('anonymous_565')(acc_type, context=_ods_context))
    if input_zp is not None: attributes["input_zp"] = (input_zp if (
        isinstance(input_zp, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(input_zp, context=_ods_context))
    if output_zp is not None: attributes["output_zp"] = (output_zp if (
        isinstance(output_zp, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(output_zp, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def kernel(self):
    return self.operation.attributes["kernel"]

  @kernel.setter
  def kernel(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kernel"] = value

  @builtins.property
  def stride(self):
    return self.operation.attributes["stride"]

  @stride.setter
  def stride(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["stride"] = value

  @builtins.property
  def pad(self):
    return self.operation.attributes["pad"]

  @pad.setter
  def pad(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pad"] = value

  @builtins.property
  def acc_type(self):
    return self.operation.attributes["acc_type"]

  @acc_type.setter
  def acc_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["acc_type"] = value

  @builtins.property
  def input_zp(self):
    if "input_zp" not in self.operation.attributes:
      return None
    return self.operation.attributes["input_zp"]

  @input_zp.setter
  def input_zp(self, value):
    if value is not None:
      self.operation.attributes["input_zp"] = value
    elif "input_zp" in self.operation.attributes:
      del self.operation.attributes["input_zp"]

  @input_zp.deleter
  def input_zp(self):
    del self.operation.attributes["input_zp"]

  @builtins.property
  def output_zp(self):
    if "output_zp" not in self.operation.attributes:
      return None
    return self.operation.attributes["output_zp"]

  @output_zp.setter
  def output_zp(self, value):
    if value is not None:
      self.operation.attributes["output_zp"] = value
    elif "output_zp" in self.operation.attributes:
      del self.operation.attributes["output_zp"]

  @output_zp.deleter
  def output_zp(self):
    del self.operation.attributes["output_zp"]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def avg_pool2d(output, input, kernel, stride, pad, acc_type, *, input_zp=None, output_zp=None, loc=None, ip=None) -> _ods_ir.Value:
  return AvgPool2dOp(output=output, input=input, kernel=kernel, stride=stride, pad=pad, acc_type=acc_type, input_zp=input_zp, output_zp=output_zp, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitwiseAndOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.bitwise_and"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def bitwise_and(output, input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return BitwiseAndOp(output=output, input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitwiseNotOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.bitwise_not"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def bitwise_not(output, input1, *, loc=None, ip=None) -> _ods_ir.Value:
  return BitwiseNotOp(output=output, input1=input1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitwiseOrOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.bitwise_or"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def bitwise_or(output, input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return BitwiseOrOp(output=output, input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitwiseXorOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.bitwise_xor"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def bitwise_xor(output, input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return BitwiseXorOp(output=output, input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CastOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def cast(output, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return CastOp(output=output, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CeilOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.ceil"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def ceil(output, input1, *, loc=None, ip=None) -> _ods_ir.Value:
  return CeilOp(output=output, input1=input1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ClampOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.clamp"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, min_val, max_val, *, nan_mode=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["min_val"] = (min_val if (
    isinstance(min_val, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntOrFloatAttr')) else
      _ods_ir.AttrBuilder.get('Tosa_IntOrFloatAttr')(min_val, context=_ods_context))
    attributes["max_val"] = (max_val if (
    isinstance(max_val, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntOrFloatAttr')) else
      _ods_ir.AttrBuilder.get('Tosa_IntOrFloatAttr')(max_val, context=_ods_context))
    if nan_mode is not None: attributes["nan_mode"] = (nan_mode if (
        isinstance(nan_mode, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Tosa_NanPropagationAttr')) else
          _ods_ir.AttrBuilder.get('Tosa_NanPropagationAttr')(nan_mode, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def min_val(self):
    return self.operation.attributes["min_val"]

  @min_val.setter
  def min_val(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["min_val"] = value

  @builtins.property
  def max_val(self):
    return self.operation.attributes["max_val"]

  @max_val.setter
  def max_val(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["max_val"] = value

  @builtins.property
  def nan_mode(self):
    return self.operation.attributes["nan_mode"]

  @nan_mode.setter
  def nan_mode(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["nan_mode"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def clamp(output, input, min_val, max_val, *, nan_mode=None, loc=None, ip=None) -> _ods_ir.Value:
  return ClampOp(output=output, input=input, min_val=min_val, max_val=max_val, nan_mode=nan_mode, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ClzOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.clz"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def clz(output, input1, *, loc=None, ip=None) -> _ods_ir.Value:
  return ClzOp(output=output, input1=input1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConcatOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.concat"

  _ODS_REGIONS = (0, True)

  def __init__(self, input1, axis, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(input1))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(axis, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def axis(self):
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def concat(input1, axis, *, loc=None, ip=None) -> _ods_ir.Value:
  return ConcatOp(input1=input1, axis=axis, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConstOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.const"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ElementsAttr')) else
      _ods_ir.AttrBuilder.get('ElementsAttr')(value, context=_ods_context))
    _ods_result_type_source_attr = attributes["value"]
    _ods_derived_result_type = (
        _ods_ir.TypeAttr(_ods_result_type_source_attr).value
        if _ods_ir.TypeAttr.isinstance(_ods_result_type_source_attr) else
        _ods_result_type_source_attr.type)
    results.extend([_ods_derived_result_type] * 1)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self):
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def const(value, *, loc=None, ip=None) -> _ods_ir.Value:
  return ConstOp(value=value, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConstShapeOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.const_shape"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('IndexElementsAttr')) else
      _ods_ir.AttrBuilder.get('IndexElementsAttr')(value, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self):
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def const_shape(output, value, *, loc=None, ip=None) -> _ods_ir.Value:
  return ConstShapeOp(output=output, value=value, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class Conv2DOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.conv2d"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, weight, bias, pad, stride, dilation, acc_type, *, input_zp=None, weight_zp=None, local_bound=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    operands.append(weight)
    operands.append(bias)
    if input_zp is not None: operands.append(input_zp)
    if weight_zp is not None: operands.append(weight_zp)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["pad"] = (pad if (
    isinstance(pad, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr4')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr4')(pad, context=_ods_context))
    attributes["stride"] = (stride if (
    isinstance(stride, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr2')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr2')(stride, context=_ods_context))
    attributes["dilation"] = (dilation if (
    isinstance(dilation, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr2')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr2')(dilation, context=_ods_context))
    attributes["acc_type"] = (acc_type if (
    isinstance(acc_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_565')) else
      _ods_ir.AttrBuilder.get('anonymous_565')(acc_type, context=_ods_context))
    if local_bound is not None: attributes["local_bound"] = (local_bound if (
        isinstance(local_bound, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(local_bound, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 0, 0)
    return self.operation.operands[start]

  @builtins.property
  def weight(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 1, 0)
    return self.operation.operands[start]

  @builtins.property
  def bias(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 2, 0)
    return self.operation.operands[start]

  @builtins.property
  def input_zp(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 3, 0)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def weight_zp(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 3, 1)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def pad(self):
    return self.operation.attributes["pad"]

  @pad.setter
  def pad(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pad"] = value

  @builtins.property
  def stride(self):
    return self.operation.attributes["stride"]

  @stride.setter
  def stride(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["stride"] = value

  @builtins.property
  def dilation(self):
    return self.operation.attributes["dilation"]

  @dilation.setter
  def dilation(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dilation"] = value

  @builtins.property
  def acc_type(self):
    return self.operation.attributes["acc_type"]

  @acc_type.setter
  def acc_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["acc_type"] = value

  @builtins.property
  def local_bound(self):
    if "local_bound" not in self.operation.attributes:
      return None
    return self.operation.attributes["local_bound"]

  @local_bound.setter
  def local_bound(self, value):
    if value is not None:
      self.operation.attributes["local_bound"] = value
    elif "local_bound" in self.operation.attributes:
      del self.operation.attributes["local_bound"]

  @local_bound.deleter
  def local_bound(self):
    del self.operation.attributes["local_bound"]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def conv2d(output, input, weight, bias, pad, stride, dilation, acc_type, *, input_zp=None, weight_zp=None, local_bound=None, loc=None, ip=None) -> _ods_ir.Value:
  return Conv2DOp(output=output, input=input, weight=weight, bias=bias, pad=pad, stride=stride, dilation=dilation, acc_type=acc_type, input_zp=input_zp, weight_zp=weight_zp, local_bound=local_bound, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class Conv3DOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.conv3d"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, weight, bias, pad, stride, dilation, acc_type, *, input_zp=None, weight_zp=None, local_bound=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    operands.append(weight)
    operands.append(bias)
    if input_zp is not None: operands.append(input_zp)
    if weight_zp is not None: operands.append(weight_zp)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["pad"] = (pad if (
    isinstance(pad, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr6')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr6')(pad, context=_ods_context))
    attributes["stride"] = (stride if (
    isinstance(stride, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr3')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr3')(stride, context=_ods_context))
    attributes["dilation"] = (dilation if (
    isinstance(dilation, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr3')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr3')(dilation, context=_ods_context))
    attributes["acc_type"] = (acc_type if (
    isinstance(acc_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_565')) else
      _ods_ir.AttrBuilder.get('anonymous_565')(acc_type, context=_ods_context))
    if local_bound is not None: attributes["local_bound"] = (local_bound if (
        isinstance(local_bound, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(local_bound, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 0, 0)
    return self.operation.operands[start]

  @builtins.property
  def weight(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 1, 0)
    return self.operation.operands[start]

  @builtins.property
  def bias(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 2, 0)
    return self.operation.operands[start]

  @builtins.property
  def input_zp(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 3, 0)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def weight_zp(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 3, 1)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def pad(self):
    return self.operation.attributes["pad"]

  @pad.setter
  def pad(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pad"] = value

  @builtins.property
  def stride(self):
    return self.operation.attributes["stride"]

  @stride.setter
  def stride(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["stride"] = value

  @builtins.property
  def dilation(self):
    return self.operation.attributes["dilation"]

  @dilation.setter
  def dilation(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dilation"] = value

  @builtins.property
  def acc_type(self):
    return self.operation.attributes["acc_type"]

  @acc_type.setter
  def acc_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["acc_type"] = value

  @builtins.property
  def local_bound(self):
    if "local_bound" not in self.operation.attributes:
      return None
    return self.operation.attributes["local_bound"]

  @local_bound.setter
  def local_bound(self, value):
    if value is not None:
      self.operation.attributes["local_bound"] = value
    elif "local_bound" in self.operation.attributes:
      del self.operation.attributes["local_bound"]

  @local_bound.deleter
  def local_bound(self):
    del self.operation.attributes["local_bound"]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def conv3d(output, input, weight, bias, pad, stride, dilation, acc_type, *, input_zp=None, weight_zp=None, local_bound=None, loc=None, ip=None) -> _ods_ir.Value:
  return Conv3DOp(output=output, input=input, weight=weight, bias=bias, pad=pad, stride=stride, dilation=dilation, acc_type=acc_type, input_zp=input_zp, weight_zp=weight_zp, local_bound=local_bound, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CosOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.cos"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def cos(output, input1, *, loc=None, ip=None) -> _ods_ir.Value:
  return CosOp(output=output, input1=input1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CustomOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.custom"

  _ODS_REGIONS = (0, True)

  def __init__(self, output_list, operator_name, domain_name, implementation_attrs, input_list, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(input_list))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["operator_name"] = (operator_name if (
    isinstance(operator_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(operator_name, context=_ods_context))
    attributes["domain_name"] = (domain_name if (
    isinstance(domain_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(domain_name, context=_ods_context))
    attributes["implementation_attrs"] = (implementation_attrs if (
    isinstance(implementation_attrs, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(implementation_attrs, context=_ods_context))
    results.extend(output_list)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input_list(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def operator_name(self):
    return self.operation.attributes["operator_name"]

  @operator_name.setter
  def operator_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["operator_name"] = value

  @builtins.property
  def domain_name(self):
    return self.operation.attributes["domain_name"]

  @domain_name.setter
  def domain_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["domain_name"] = value

  @builtins.property
  def implementation_attrs(self):
    return self.operation.attributes["implementation_attrs"]

  @implementation_attrs.setter
  def implementation_attrs(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["implementation_attrs"] = value

  @builtins.property
  def output_list(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def custom(output_list, operator_name, domain_name, implementation_attrs, input_list, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CustomOp(output_list=output_list, operator_name=operator_name, domain_name=domain_name, implementation_attrs=implementation_attrs, input_list=input_list, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DepthwiseConv2DOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.depthwise_conv2d"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, weight, bias, pad, stride, dilation, acc_type, *, input_zp=None, weight_zp=None, local_bound=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    operands.append(weight)
    operands.append(bias)
    if input_zp is not None: operands.append(input_zp)
    if weight_zp is not None: operands.append(weight_zp)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["pad"] = (pad if (
    isinstance(pad, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr4')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr4')(pad, context=_ods_context))
    attributes["stride"] = (stride if (
    isinstance(stride, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr2')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr2')(stride, context=_ods_context))
    attributes["dilation"] = (dilation if (
    isinstance(dilation, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr2')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr2')(dilation, context=_ods_context))
    attributes["acc_type"] = (acc_type if (
    isinstance(acc_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_565')) else
      _ods_ir.AttrBuilder.get('anonymous_565')(acc_type, context=_ods_context))
    if local_bound is not None: attributes["local_bound"] = (local_bound if (
        isinstance(local_bound, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(local_bound, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 0, 0)
    return self.operation.operands[start]

  @builtins.property
  def weight(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 1, 0)
    return self.operation.operands[start]

  @builtins.property
  def bias(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 2, 0)
    return self.operation.operands[start]

  @builtins.property
  def input_zp(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 3, 0)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def weight_zp(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 3, 1)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def pad(self):
    return self.operation.attributes["pad"]

  @pad.setter
  def pad(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pad"] = value

  @builtins.property
  def stride(self):
    return self.operation.attributes["stride"]

  @stride.setter
  def stride(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["stride"] = value

  @builtins.property
  def dilation(self):
    return self.operation.attributes["dilation"]

  @dilation.setter
  def dilation(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dilation"] = value

  @builtins.property
  def acc_type(self):
    return self.operation.attributes["acc_type"]

  @acc_type.setter
  def acc_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["acc_type"] = value

  @builtins.property
  def local_bound(self):
    if "local_bound" not in self.operation.attributes:
      return None
    return self.operation.attributes["local_bound"]

  @local_bound.setter
  def local_bound(self, value):
    if value is not None:
      self.operation.attributes["local_bound"] = value
    elif "local_bound" in self.operation.attributes:
      del self.operation.attributes["local_bound"]

  @local_bound.deleter
  def local_bound(self):
    del self.operation.attributes["local_bound"]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def depthwise_conv2d(output, input, weight, bias, pad, stride, dilation, acc_type, *, input_zp=None, weight_zp=None, local_bound=None, loc=None, ip=None) -> _ods_ir.Value:
  return DepthwiseConv2DOp(output=output, input=input, weight=weight, bias=bias, pad=pad, stride=stride, dilation=dilation, acc_type=acc_type, input_zp=input_zp, weight_zp=weight_zp, local_bound=local_bound, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class EqualOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.equal"

  _ODS_REGIONS = (0, True)

  def __init__(self, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def equal(input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return EqualOp(input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ErfOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.erf"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def erf(output, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return ErfOp(output=output, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ExpOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.exp"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def exp(output, input1, *, loc=None, ip=None) -> _ods_ir.Value:
  return ExpOp(output=output, input1=input1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FFT2dOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.fft2d"

  _ODS_REGIONS = (0, True)

  def __init__(self, output_real, output_imag, input_real, input_imag, inverse, *, local_bound=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input_real)
    operands.append(input_imag)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["inverse"] = (inverse if (
    isinstance(inverse, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(inverse, context=_ods_context))
    if local_bound is not None: attributes["local_bound"] = (local_bound if (
        isinstance(local_bound, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(local_bound, context=_ods_context))
    results.append(output_real)
    results.append(output_imag)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input_real(self):
    return self.operation.operands[0]

  @builtins.property
  def input_imag(self):
    return self.operation.operands[1]

  @builtins.property
  def inverse(self):
    return self.operation.attributes["inverse"]

  @inverse.setter
  def inverse(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["inverse"] = value

  @builtins.property
  def local_bound(self):
    if "local_bound" not in self.operation.attributes:
      return None
    return self.operation.attributes["local_bound"]

  @local_bound.setter
  def local_bound(self, value):
    if value is not None:
      self.operation.attributes["local_bound"] = value
    elif "local_bound" in self.operation.attributes:
      del self.operation.attributes["local_bound"]

  @local_bound.deleter
  def local_bound(self):
    del self.operation.attributes["local_bound"]

  @builtins.property
  def output_real(self):
    return self.operation.results[0]

  @builtins.property
  def output_imag(self):
    return self.operation.results[1]

def fft2d(output_real, output_imag, input_real, input_imag, inverse, *, local_bound=None, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return FFT2dOp(output_real=output_real, output_imag=output_imag, input_real=input_real, input_imag=input_imag, inverse=inverse, local_bound=local_bound, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class FloorOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.floor"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def floor(output, input1, *, loc=None, ip=None) -> _ods_ir.Value:
  return FloorOp(output=output, input1=input1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GatherOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.gather"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, values, indices, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(values)
    operands.append(indices)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def values(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def gather(output, values, indices, *, loc=None, ip=None) -> _ods_ir.Value:
  return GatherOp(output=output, values=values, indices=indices, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GreaterEqualOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.greater_equal"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def greater_equal(output, input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return GreaterEqualOp(output=output, input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GreaterOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.greater"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def greater(output, input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return GreaterOp(output=output, input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IdentityOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.identity"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def identity(output, input1, *, loc=None, ip=None) -> _ods_ir.Value:
  return IdentityOp(output=output, input1=input1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IfOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.cond_if"

  _ODS_REGIONS = (2, True)

  def __init__(self, output, cond, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(cond)
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def cond(self):
    return self.operation.operands[0]

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def output(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def then_branch(self):
    return self.regions[0]

  @builtins.property
  def else_branch(self):
    return self.regions[1]

def cond_if(output, cond, inputs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(IfOp(output=output, cond=cond, inputs=inputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class IntDivOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.int_div"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def int_div(output, input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return IntDivOp(output=output, input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LogOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.log"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def log(output, input1, *, loc=None, ip=None) -> _ods_ir.Value:
  return LogOp(output=output, input1=input1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LogicalAndOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.logical_and"

  _ODS_REGIONS = (0, True)

  def __init__(self, z, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(z)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def z(self):
    return self.operation.results[0]

def logical_and(z, input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return LogicalAndOp(z=z, input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LogicalLeftShiftOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.logical_left_shift"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def logical_left_shift(output, input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return LogicalLeftShiftOp(output=output, input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LogicalNotOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.logical_not"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def logical_not(output, input1, *, loc=None, ip=None) -> _ods_ir.Value:
  return LogicalNotOp(output=output, input1=input1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LogicalOrOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.logical_or"

  _ODS_REGIONS = (0, True)

  def __init__(self, z, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(z)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def z(self):
    return self.operation.results[0]

def logical_or(z, input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return LogicalOrOp(z=z, input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LogicalRightShiftOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.logical_right_shift"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def logical_right_shift(output, input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return LogicalRightShiftOp(output=output, input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LogicalXorOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.logical_xor"

  _ODS_REGIONS = (0, True)

  def __init__(self, z, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(z)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def z(self):
    return self.operation.results[0]

def logical_xor(z, input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return LogicalXorOp(z=z, input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MatMulOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.matmul"

  _ODS_REGIONS = (0, True)

  def __init__(self, c, a, b, *, a_zp=None, b_zp=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(a)
    operands.append(b)
    _ods_context = _ods_get_default_loc_context(loc)
    if a_zp is not None: attributes["a_zp"] = (a_zp if (
        isinstance(a_zp, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(a_zp, context=_ods_context))
    if b_zp is not None: attributes["b_zp"] = (b_zp if (
        isinstance(b_zp, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(b_zp, context=_ods_context))
    results.append(c)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def a_zp(self):
    if "a_zp" not in self.operation.attributes:
      return None
    return self.operation.attributes["a_zp"]

  @a_zp.setter
  def a_zp(self, value):
    if value is not None:
      self.operation.attributes["a_zp"] = value
    elif "a_zp" in self.operation.attributes:
      del self.operation.attributes["a_zp"]

  @a_zp.deleter
  def a_zp(self):
    del self.operation.attributes["a_zp"]

  @builtins.property
  def b_zp(self):
    if "b_zp" not in self.operation.attributes:
      return None
    return self.operation.attributes["b_zp"]

  @b_zp.setter
  def b_zp(self, value):
    if value is not None:
      self.operation.attributes["b_zp"] = value
    elif "b_zp" in self.operation.attributes:
      del self.operation.attributes["b_zp"]

  @b_zp.deleter
  def b_zp(self):
    del self.operation.attributes["b_zp"]

  @builtins.property
  def c(self):
    return self.operation.results[0]

def matmul(c, a, b, *, a_zp=None, b_zp=None, loc=None, ip=None) -> _ods_ir.Value:
  return MatMulOp(c=c, a=a, b=b, a_zp=a_zp, b_zp=b_zp, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MaxPool2dOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.max_pool2d"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, kernel, stride, pad, *, nan_mode=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["kernel"] = (kernel if (
    isinstance(kernel, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr2')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr2')(kernel, context=_ods_context))
    attributes["stride"] = (stride if (
    isinstance(stride, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr2')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr2')(stride, context=_ods_context))
    attributes["pad"] = (pad if (
    isinstance(pad, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr4')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr4')(pad, context=_ods_context))
    if nan_mode is not None: attributes["nan_mode"] = (nan_mode if (
        isinstance(nan_mode, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Tosa_NanPropagationAttr')) else
          _ods_ir.AttrBuilder.get('Tosa_NanPropagationAttr')(nan_mode, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def kernel(self):
    return self.operation.attributes["kernel"]

  @kernel.setter
  def kernel(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kernel"] = value

  @builtins.property
  def stride(self):
    return self.operation.attributes["stride"]

  @stride.setter
  def stride(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["stride"] = value

  @builtins.property
  def pad(self):
    return self.operation.attributes["pad"]

  @pad.setter
  def pad(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pad"] = value

  @builtins.property
  def nan_mode(self):
    return self.operation.attributes["nan_mode"]

  @nan_mode.setter
  def nan_mode(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["nan_mode"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def max_pool2d(output, input, kernel, stride, pad, *, nan_mode=None, loc=None, ip=None) -> _ods_ir.Value:
  return MaxPool2dOp(output=output, input=input, kernel=kernel, stride=stride, pad=pad, nan_mode=nan_mode, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MaximumOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.maximum"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, *, nan_mode=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    if nan_mode is not None: attributes["nan_mode"] = (nan_mode if (
        isinstance(nan_mode, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Tosa_NanPropagationAttr')) else
          _ods_ir.AttrBuilder.get('Tosa_NanPropagationAttr')(nan_mode, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def nan_mode(self):
    return self.operation.attributes["nan_mode"]

  @nan_mode.setter
  def nan_mode(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["nan_mode"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def maximum(output, input1, input2, *, nan_mode=None, loc=None, ip=None) -> _ods_ir.Value:
  return MaximumOp(output=output, input1=input1, input2=input2, nan_mode=nan_mode, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MinimumOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.minimum"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, *, nan_mode=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    if nan_mode is not None: attributes["nan_mode"] = (nan_mode if (
        isinstance(nan_mode, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Tosa_NanPropagationAttr')) else
          _ods_ir.AttrBuilder.get('Tosa_NanPropagationAttr')(nan_mode, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def nan_mode(self):
    return self.operation.attributes["nan_mode"]

  @nan_mode.setter
  def nan_mode(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["nan_mode"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def minimum(output, input1, input2, *, nan_mode=None, loc=None, ip=None) -> _ods_ir.Value:
  return MinimumOp(output=output, input1=input1, input2=input2, nan_mode=nan_mode, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MulOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.mul"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, shift, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    operands.append(shift)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def shift(self):
    return self.operation.operands[2]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def mul(output, input1, input2, shift, *, loc=None, ip=None) -> _ods_ir.Value:
  return MulOp(output=output, input1=input1, input2=input2, shift=shift, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class NegateOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.negate"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, *, input1_zp=None, output_zp=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    if input1_zp is not None: attributes["input1_zp"] = (input1_zp if (
        isinstance(input1_zp, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(input1_zp, context=_ods_context))
    if output_zp is not None: attributes["output_zp"] = (output_zp if (
        isinstance(output_zp, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(output_zp, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input1_zp(self):
    if "input1_zp" not in self.operation.attributes:
      return None
    return self.operation.attributes["input1_zp"]

  @input1_zp.setter
  def input1_zp(self, value):
    if value is not None:
      self.operation.attributes["input1_zp"] = value
    elif "input1_zp" in self.operation.attributes:
      del self.operation.attributes["input1_zp"]

  @input1_zp.deleter
  def input1_zp(self):
    del self.operation.attributes["input1_zp"]

  @builtins.property
  def output_zp(self):
    if "output_zp" not in self.operation.attributes:
      return None
    return self.operation.attributes["output_zp"]

  @output_zp.setter
  def output_zp(self, value):
    if value is not None:
      self.operation.attributes["output_zp"] = value
    elif "output_zp" in self.operation.attributes:
      del self.operation.attributes["output_zp"]

  @output_zp.deleter
  def output_zp(self):
    del self.operation.attributes["output_zp"]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def negate(output, input1, *, input1_zp=None, output_zp=None, loc=None, ip=None) -> _ods_ir.Value:
  return NegateOp(output=output, input1=input1, input1_zp=input1_zp, output_zp=output_zp, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PadOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.pad"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, padding, *, pad_const=None, input_zp=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(padding)
    if pad_const is not None: operands.append(pad_const)
    _ods_context = _ods_get_default_loc_context(loc)
    if input_zp is not None: attributes["input_zp"] = (input_zp if (
        isinstance(input_zp, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(input_zp, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def padding(self):
    return self.operation.operands[1]

  @builtins.property
  def pad_const(self):
    return None if len(self.operation.operands) < 3 else self.operation.operands[2]

  @builtins.property
  def input_zp(self):
    if "input_zp" not in self.operation.attributes:
      return None
    return self.operation.attributes["input_zp"]

  @input_zp.setter
  def input_zp(self, value):
    if value is not None:
      self.operation.attributes["input_zp"] = value
    elif "input_zp" in self.operation.attributes:
      del self.operation.attributes["input_zp"]

  @input_zp.deleter
  def input_zp(self):
    del self.operation.attributes["input_zp"]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def pad(output, input1, padding, *, pad_const=None, input_zp=None, loc=None, ip=None) -> _ods_ir.Value:
  return PadOp(output=output, input1=input1, padding=padding, pad_const=pad_const, input_zp=input_zp, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PowOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.pow"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def pow(output, input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return PowOp(output=output, input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RFFT2dOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.rfft2d"

  _ODS_REGIONS = (0, True)

  def __init__(self, output_real, output_imag, input, *, local_bound=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    if local_bound is not None: attributes["local_bound"] = (local_bound if (
        isinstance(local_bound, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(local_bound, context=_ods_context))
    results.append(output_real)
    results.append(output_imag)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def local_bound(self):
    if "local_bound" not in self.operation.attributes:
      return None
    return self.operation.attributes["local_bound"]

  @local_bound.setter
  def local_bound(self, value):
    if value is not None:
      self.operation.attributes["local_bound"] = value
    elif "local_bound" in self.operation.attributes:
      del self.operation.attributes["local_bound"]

  @local_bound.deleter
  def local_bound(self):
    del self.operation.attributes["local_bound"]

  @builtins.property
  def output_real(self):
    return self.operation.results[0]

  @builtins.property
  def output_imag(self):
    return self.operation.results[1]

def rfft2d(output_real, output_imag, input, *, local_bound=None, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return RFFT2dOp(output_real=output_real, output_imag=output_imag, input=input, local_bound=local_bound, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class ReciprocalOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.reciprocal"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def reciprocal(output, input1, *, loc=None, ip=None) -> _ods_ir.Value:
  return ReciprocalOp(output=output, input1=input1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReduceAllOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.reduce_all"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, axis, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(axis, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def axis(self):
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def reduce_all(input, axis, *, loc=None, ip=None) -> _ods_ir.Value:
  return ReduceAllOp(input=input, axis=axis, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReduceAnyOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.reduce_any"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, axis, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(axis, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def axis(self):
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def reduce_any(input, axis, *, loc=None, ip=None) -> _ods_ir.Value:
  return ReduceAnyOp(input=input, axis=axis, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReduceMaxOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.reduce_max"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, axis, *, nan_mode=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(axis, context=_ods_context))
    if nan_mode is not None: attributes["nan_mode"] = (nan_mode if (
        isinstance(nan_mode, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Tosa_NanPropagationAttr')) else
          _ods_ir.AttrBuilder.get('Tosa_NanPropagationAttr')(nan_mode, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def axis(self):
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def nan_mode(self):
    return self.operation.attributes["nan_mode"]

  @nan_mode.setter
  def nan_mode(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["nan_mode"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def reduce_max(input, axis, *, nan_mode=None, loc=None, ip=None) -> _ods_ir.Value:
  return ReduceMaxOp(input=input, axis=axis, nan_mode=nan_mode, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReduceMinOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.reduce_min"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, axis, *, nan_mode=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(axis, context=_ods_context))
    if nan_mode is not None: attributes["nan_mode"] = (nan_mode if (
        isinstance(nan_mode, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Tosa_NanPropagationAttr')) else
          _ods_ir.AttrBuilder.get('Tosa_NanPropagationAttr')(nan_mode, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def axis(self):
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def nan_mode(self):
    return self.operation.attributes["nan_mode"]

  @nan_mode.setter
  def nan_mode(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["nan_mode"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def reduce_min(input, axis, *, nan_mode=None, loc=None, ip=None) -> _ods_ir.Value:
  return ReduceMinOp(input=input, axis=axis, nan_mode=nan_mode, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReduceProdOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.reduce_prod"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, axis, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(axis, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def axis(self):
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def reduce_prod(input, axis, *, loc=None, ip=None) -> _ods_ir.Value:
  return ReduceProdOp(input=input, axis=axis, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReduceSumOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.reduce_sum"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, axis, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(axis, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def axis(self):
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def reduce_sum(input, axis, *, loc=None, ip=None) -> _ods_ir.Value:
  return ReduceSumOp(input=input, axis=axis, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RescaleOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.rescale"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, input_zp, output_zp, multiplier, shift, scale32, double_round, per_channel, *, input_unsigned=None, output_unsigned=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["input_zp"] = (input_zp if (
    isinstance(input_zp, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(input_zp, context=_ods_context))
    attributes["output_zp"] = (output_zp if (
    isinstance(output_zp, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(output_zp, context=_ods_context))
    attributes["multiplier"] = (multiplier if (
    isinstance(multiplier, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(multiplier, context=_ods_context))
    attributes["shift"] = (shift if (
    isinstance(shift, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI8ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI8ArrayAttr')(shift, context=_ods_context))
    attributes["scale32"] = (scale32 if (
    isinstance(scale32, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(scale32, context=_ods_context))
    attributes["double_round"] = (double_round if (
    isinstance(double_round, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(double_round, context=_ods_context))
    attributes["per_channel"] = (per_channel if (
    isinstance(per_channel, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(per_channel, context=_ods_context))
    if input_unsigned is not None: attributes["input_unsigned"] = (input_unsigned if (
        isinstance(input_unsigned, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(input_unsigned, context=_ods_context))
    if output_unsigned is not None: attributes["output_unsigned"] = (output_unsigned if (
        isinstance(output_unsigned, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(output_unsigned, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def input_zp(self):
    return self.operation.attributes["input_zp"]

  @input_zp.setter
  def input_zp(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["input_zp"] = value

  @builtins.property
  def output_zp(self):
    return self.operation.attributes["output_zp"]

  @output_zp.setter
  def output_zp(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["output_zp"] = value

  @builtins.property
  def multiplier(self):
    return self.operation.attributes["multiplier"]

  @multiplier.setter
  def multiplier(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["multiplier"] = value

  @builtins.property
  def shift(self):
    return self.operation.attributes["shift"]

  @shift.setter
  def shift(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["shift"] = value

  @builtins.property
  def scale32(self):
    return self.operation.attributes["scale32"]

  @scale32.setter
  def scale32(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["scale32"] = value

  @builtins.property
  def double_round(self):
    return self.operation.attributes["double_round"]

  @double_round.setter
  def double_round(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["double_round"] = value

  @builtins.property
  def per_channel(self):
    return self.operation.attributes["per_channel"]

  @per_channel.setter
  def per_channel(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["per_channel"] = value

  @builtins.property
  def input_unsigned(self):
    if "input_unsigned" not in self.operation.attributes:
      return None
    return self.operation.attributes["input_unsigned"]

  @input_unsigned.setter
  def input_unsigned(self, value):
    if value is not None:
      self.operation.attributes["input_unsigned"] = value
    elif "input_unsigned" in self.operation.attributes:
      del self.operation.attributes["input_unsigned"]

  @input_unsigned.deleter
  def input_unsigned(self):
    del self.operation.attributes["input_unsigned"]

  @builtins.property
  def output_unsigned(self):
    if "output_unsigned" not in self.operation.attributes:
      return None
    return self.operation.attributes["output_unsigned"]

  @output_unsigned.setter
  def output_unsigned(self, value):
    if value is not None:
      self.operation.attributes["output_unsigned"] = value
    elif "output_unsigned" in self.operation.attributes:
      del self.operation.attributes["output_unsigned"]

  @output_unsigned.deleter
  def output_unsigned(self):
    del self.operation.attributes["output_unsigned"]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def rescale(output, input, input_zp, output_zp, multiplier, shift, scale32, double_round, per_channel, *, input_unsigned=None, output_unsigned=None, loc=None, ip=None) -> _ods_ir.Value:
  return RescaleOp(output=output, input=input, input_zp=input_zp, output_zp=output_zp, multiplier=multiplier, shift=shift, scale32=scale32, double_round=double_round, per_channel=per_channel, input_unsigned=input_unsigned, output_unsigned=output_unsigned, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReshapeOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.reshape"

  _ODS_REGIONS = (0, True)

  def __init__(self, input1, shape, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(shape)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def shape(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def reshape(input1, shape, *, loc=None, ip=None) -> _ods_ir.Value:
  return ReshapeOp(input1=input1, shape=shape, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ResizeOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.resize"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, scale, offset, border, mode, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    operands.append(scale)
    operands.append(offset)
    operands.append(border)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["mode"] = (mode if (
    isinstance(mode, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_ResizeTypeAttr')) else
      _ods_ir.AttrBuilder.get('Tosa_ResizeTypeAttr')(mode, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def scale(self):
    return self.operation.operands[1]

  @builtins.property
  def offset(self):
    return self.operation.operands[2]

  @builtins.property
  def border(self):
    return self.operation.operands[3]

  @builtins.property
  def mode(self):
    return self.operation.attributes["mode"]

  @mode.setter
  def mode(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["mode"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def resize(output, input, scale, offset, border, mode, *, loc=None, ip=None) -> _ods_ir.Value:
  return ResizeOp(output=output, input=input, scale=scale, offset=offset, border=border, mode=mode, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReverseOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.reverse"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, axis, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(axis, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def axis(self):
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def reverse(output, input1, axis, *, loc=None, ip=None) -> _ods_ir.Value:
  return ReverseOp(output=output, input1=input1, axis=axis, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RsqrtOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.rsqrt"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def rsqrt(output, input1, *, loc=None, ip=None) -> _ods_ir.Value:
  return RsqrtOp(output=output, input1=input1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ScatterOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.scatter"

  _ODS_REGIONS = (0, True)

  def __init__(self, values_out, values_in, indices, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(values_in)
    operands.append(indices)
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(values_out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def values_in(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    return self.operation.operands[1]

  @builtins.property
  def input(self):
    return self.operation.operands[2]

  @builtins.property
  def values_out(self):
    return self.operation.results[0]

def scatter(values_out, values_in, indices, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return ScatterOp(values_out=values_out, values_in=values_in, indices=indices, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SelectOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.select"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, input3, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    operands.append(input3)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def input3(self):
    return self.operation.operands[2]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def select(output, input1, input2, input3, *, loc=None, ip=None) -> _ods_ir.Value:
  return SelectOp(output=output, input1=input1, input2=input2, input3=input3, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SigmoidOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.sigmoid"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def sigmoid(output, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return SigmoidOp(output=output, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SinOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.sin"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def sin(output, input1, *, loc=None, ip=None) -> _ods_ir.Value:
  return SinOp(output=output, input1=input1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SliceOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.slice"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, start, size, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(start)
    operands.append(size)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def start(self):
    return self.operation.operands[1]

  @builtins.property
  def size(self):
    return self.operation.operands[2]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def slice(output, input1, start, size, *, loc=None, ip=None) -> _ods_ir.Value:
  return SliceOp(output=output, input1=input1, start=start, size=size, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SubOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.sub"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, input2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(input2)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def input2(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def sub(output, input1, input2, *, loc=None, ip=None) -> _ods_ir.Value:
  return SubOp(output=output, input1=input1, input2=input2, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TableOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.table"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, table, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(table)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def table(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def table(output, input1, table, *, loc=None, ip=None) -> _ods_ir.Value:
  return TableOp(output=output, input1=input1, table=table, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TanhOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.tanh"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def tanh(output, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return TanhOp(output=output, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TileOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.tile"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, multiples, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(multiples)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def multiples(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def tile(output, input1, multiples, *, loc=None, ip=None) -> _ods_ir.Value:
  return TileOp(output=output, input1=input1, multiples=multiples, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TransposeConv2DOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.transpose_conv2d"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, weight, bias, out_pad, stride, out_shape, acc_type, *, input_zp=None, weight_zp=None, local_bound=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    operands.append(weight)
    operands.append(bias)
    if input_zp is not None: operands.append(input_zp)
    if weight_zp is not None: operands.append(weight_zp)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["out_pad"] = (out_pad if (
    isinstance(out_pad, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr4')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr4')(out_pad, context=_ods_context))
    attributes["stride"] = (stride if (
    isinstance(stride, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr2')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr2')(stride, context=_ods_context))
    attributes["out_shape"] = (out_shape if (
    isinstance(out_shape, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Tosa_IntArrayAttr4')) else
      _ods_ir.AttrBuilder.get('Tosa_IntArrayAttr4')(out_shape, context=_ods_context))
    attributes["acc_type"] = (acc_type if (
    isinstance(acc_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_565')) else
      _ods_ir.AttrBuilder.get('anonymous_565')(acc_type, context=_ods_context))
    if local_bound is not None: attributes["local_bound"] = (local_bound if (
        isinstance(local_bound, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(local_bound, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 0, 0)
    return self.operation.operands[start]

  @builtins.property
  def weight(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 1, 0)
    return self.operation.operands[start]

  @builtins.property
  def bias(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 2, 0)
    return self.operation.operands[start]

  @builtins.property
  def input_zp(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 3, 0)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def weight_zp(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 3, 2, 3, 1)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def out_pad(self):
    return self.operation.attributes["out_pad"]

  @out_pad.setter
  def out_pad(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["out_pad"] = value

  @builtins.property
  def stride(self):
    return self.operation.attributes["stride"]

  @stride.setter
  def stride(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["stride"] = value

  @builtins.property
  def out_shape(self):
    return self.operation.attributes["out_shape"]

  @out_shape.setter
  def out_shape(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["out_shape"] = value

  @builtins.property
  def acc_type(self):
    return self.operation.attributes["acc_type"]

  @acc_type.setter
  def acc_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["acc_type"] = value

  @builtins.property
  def local_bound(self):
    if "local_bound" not in self.operation.attributes:
      return None
    return self.operation.attributes["local_bound"]

  @local_bound.setter
  def local_bound(self, value):
    if value is not None:
      self.operation.attributes["local_bound"] = value
    elif "local_bound" in self.operation.attributes:
      del self.operation.attributes["local_bound"]

  @local_bound.deleter
  def local_bound(self):
    del self.operation.attributes["local_bound"]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def transpose_conv2d(output, input, weight, bias, out_pad, stride, out_shape, acc_type, *, input_zp=None, weight_zp=None, local_bound=None, loc=None, ip=None) -> _ods_ir.Value:
  return TransposeConv2DOp(output=output, input=input, weight=weight, bias=bias, out_pad=out_pad, stride=stride, out_shape=out_shape, acc_type=acc_type, input_zp=input_zp, weight_zp=weight_zp, local_bound=local_bound, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TransposeOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.transpose"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input1, perms, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input1)
    operands.append(perms)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input1(self):
    return self.operation.operands[0]

  @builtins.property
  def perms(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def transpose(output, input1, perms, *, loc=None, ip=None) -> _ods_ir.Value:
  return TransposeOp(output=output, input1=input1, perms=perms, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class VariableOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.variable"

  _ODS_REGIONS = (0, True)

  def __init__(self, name, type_, *, initial_value=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["name"] = (name if (
    isinstance(name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(name, context=_ods_context))
    attributes["type"] = (type_ if (
    isinstance(type_, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(type_, context=_ods_context))
    if initial_value is not None: attributes["initial_value"] = (initial_value if (
        isinstance(initial_value, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AnyAttr')) else
          _ods_ir.AttrBuilder.get('AnyAttr')(initial_value, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

  @builtins.property
  def type_(self):
    return self.operation.attributes["type"]

  @type_.setter
  def type_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["type"] = value

  @builtins.property
  def initial_value(self):
    if "initial_value" not in self.operation.attributes:
      return None
    return self.operation.attributes["initial_value"]

  @initial_value.setter
  def initial_value(self, value):
    if value is not None:
      self.operation.attributes["initial_value"] = value
    elif "initial_value" in self.operation.attributes:
      del self.operation.attributes["initial_value"]

  @initial_value.deleter
  def initial_value(self):
    del self.operation.attributes["initial_value"]

def variable(name, type_, *, initial_value=None, loc=None, ip=None) -> _ods_ir.Operation:
  return VariableOp(name=name, type_=type_, initial_value=initial_value, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class VariableReadOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.variable.read"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["name"] = (name if (
    isinstance(name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(name, context=_ods_context))
    results.append(value)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

  @builtins.property
  def value(self):
    return self.operation.results[0]

def variable_read(value, name, *, loc=None, ip=None) -> _ods_ir.Value:
  return VariableReadOp(value=value, name=name, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class VariableWriteOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.variable.write"

  _ODS_REGIONS = (0, True)

  def __init__(self, name, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(value)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["name"] = (name if (
    isinstance(name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

def variable_write(name, value, *, loc=None, ip=None) -> _ods_ir.Operation:
  return VariableWriteOp(name=name, value=value, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class WhileOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.while_loop"

  _ODS_REGIONS = (2, True)

  def __init__(self, output, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def output(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def cond(self):
    return self.regions[0]

  @builtins.property
  def body(self):
    return self.regions[1]

def while_loop(output, inputs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(WhileOp(output=output, inputs=inputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "tosa.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def yield_(inputs, *, loc=None, ip=None) -> _ods_ir.Operation:
  return YieldOp(inputs=inputs, loc=loc, ip=ip)
