
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "shape"

@_ods_cext.register_operation(_Dialect)
class AddOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.add"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def add(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return AddOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AnyOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.any"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def any(result, inputs, *, loc=None, ip=None) -> _ods_ir.Value:
  return AnyOp(result=result, inputs=inputs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AssumingAllOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.assuming_all"

  _ODS_REGIONS = (0, True)

  def __init__(self, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def assuming_all(inputs, *, loc=None, ip=None) -> _ods_ir.Value:
  return AssumingAllOp(inputs=inputs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AssumingOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.assuming"

  _ODS_REGIONS = (1, True)

  def __init__(self, results_, witness, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(witness)
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def witness(self):
    return self.operation.operands[0]

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def doRegion(self):
    return self.regions[0]

def assuming(results_, witness, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(AssumingOp(results_=results_, witness=witness, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AssumingYieldOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.assuming_yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, operands_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def assuming_yield(operands_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return AssumingYieldOp(operands_=operands_, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class BroadcastOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.broadcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, shapes, *, error=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(shapes))
    _ods_context = _ods_get_default_loc_context(loc)
    if error is not None: attributes["error"] = (error if (
        isinstance(error, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(error, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def shapes(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def error(self):
    if "error" not in self.operation.attributes:
      return None
    return self.operation.attributes["error"]

  @error.setter
  def error(self, value):
    if value is not None:
      self.operation.attributes["error"] = value
    elif "error" in self.operation.attributes:
      del self.operation.attributes["error"]

  @error.deleter
  def error(self):
    del self.operation.attributes["error"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def broadcast(result, shapes, *, error=None, loc=None, ip=None) -> _ods_ir.Value:
  return BroadcastOp(result=result, shapes=shapes, error=error, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConcatOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.concat"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def concat(result, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return ConcatOp(result=result, lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConstShapeOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.const_shape"

  _ODS_REGIONS = (0, True)

  def __init__(self, shape, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["shape"] = (shape if (
    isinstance(shape, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('IndexElementsAttr')) else
      _ods_ir.AttrBuilder.get('IndexElementsAttr')(shape, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def shape(self):
    return self.operation.attributes["shape"]

  @shape.setter
  def shape(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["shape"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def const_shape(shape, *, loc=None, ip=None) -> _ods_ir.Value:
  return ConstShapeOp(shape=shape, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConstSizeOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.const_size"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('IndexAttr')) else
      _ods_ir.AttrBuilder.get('IndexAttr')(value, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self):
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def const_size(value, *, loc=None, ip=None) -> _ods_ir.Value:
  return ConstSizeOp(value=value, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConstWitnessOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.const_witness"

  _ODS_REGIONS = (0, True)

  def __init__(self, passing, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["passing"] = (passing if (
    isinstance(passing, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(passing, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def passing(self):
    return self.operation.attributes["passing"]

  @passing.setter
  def passing(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["passing"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def const_witness(passing, *, loc=None, ip=None) -> _ods_ir.Value:
  return ConstWitnessOp(passing=passing, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CstrBroadcastableOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.cstr_broadcastable"

  _ODS_REGIONS = (0, True)

  def __init__(self, shapes, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(shapes))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def shapes(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def cstr_broadcastable(shapes, *, loc=None, ip=None) -> _ods_ir.Value:
  return CstrBroadcastableOp(shapes=shapes, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CstrEqOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.cstr_eq"

  _ODS_REGIONS = (0, True)

  def __init__(self, shapes, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(shapes))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def shapes(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def cstr_eq(shapes, *, loc=None, ip=None) -> _ods_ir.Value:
  return CstrEqOp(shapes=shapes, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CstrRequireOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.cstr_require"

  _ODS_REGIONS = (0, True)

  def __init__(self, pred, msg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(pred)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["msg"] = (msg if (
    isinstance(msg, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(msg, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def pred(self):
    return self.operation.operands[0]

  @builtins.property
  def msg(self):
    return self.operation.attributes["msg"]

  @msg.setter
  def msg(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["msg"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def cstr_require(pred, msg, *, loc=None, ip=None) -> _ods_ir.Value:
  return CstrRequireOp(pred=pred, msg=msg, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DebugPrintOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.debug_print"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def debug_print(output, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return DebugPrintOp(output=output, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DimOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.dim"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(value)
    operands.append(index)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    return self.operation.operands[1]

  @builtins.property
  def extent(self):
    return self.operation.results[0]

def dim(value, index, *, loc=None, ip=None) -> _ods_ir.Value:
  return DimOp(value=value, index=index, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DivOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.div"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def div(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return DivOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FromExtentTensorOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.from_extent_tensor"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def from_extent_tensor(input, *, loc=None, ip=None) -> _ods_ir.Value:
  return FromExtentTensorOp(input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FromExtentsOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.from_extents"

  _ODS_REGIONS = (0, True)

  def __init__(self, extents, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(extents))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def extents(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def shape(self):
    return self.operation.results[0]

def from_extents(extents, *, loc=None, ip=None) -> _ods_ir.Value:
  return FromExtentsOp(extents=extents, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FuncOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.func"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, function_type, *, arg_attrs=None, res_attrs=None, sym_visibility=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["function_type"] = (function_type if (
    isinstance(function_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_461')) else
      _ods_ir.AttrBuilder.get('anonymous_461')(function_type, context=_ods_context))
    if arg_attrs is not None: attributes["arg_attrs"] = (arg_attrs if (
        isinstance(arg_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(arg_attrs, context=_ods_context))
    if res_attrs is not None: attributes["res_attrs"] = (res_attrs if (
        isinstance(res_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(res_attrs, context=_ods_context))
    if sym_visibility is not None: attributes["sym_visibility"] = (sym_visibility if (
        isinstance(sym_visibility, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(sym_visibility, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def function_type(self):
    return self.operation.attributes["function_type"]

  @function_type.setter
  def function_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["function_type"] = value

  @builtins.property
  def arg_attrs(self):
    if "arg_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["arg_attrs"]

  @arg_attrs.setter
  def arg_attrs(self, value):
    if value is not None:
      self.operation.attributes["arg_attrs"] = value
    elif "arg_attrs" in self.operation.attributes:
      del self.operation.attributes["arg_attrs"]

  @arg_attrs.deleter
  def arg_attrs(self):
    del self.operation.attributes["arg_attrs"]

  @builtins.property
  def res_attrs(self):
    if "res_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["res_attrs"]

  @res_attrs.setter
  def res_attrs(self, value):
    if value is not None:
      self.operation.attributes["res_attrs"] = value
    elif "res_attrs" in self.operation.attributes:
      del self.operation.attributes["res_attrs"]

  @res_attrs.deleter
  def res_attrs(self):
    del self.operation.attributes["res_attrs"]

  @builtins.property
  def sym_visibility(self):
    if "sym_visibility" not in self.operation.attributes:
      return None
    return self.operation.attributes["sym_visibility"]

  @sym_visibility.setter
  def sym_visibility(self, value):
    if value is not None:
      self.operation.attributes["sym_visibility"] = value
    elif "sym_visibility" in self.operation.attributes:
      del self.operation.attributes["sym_visibility"]

  @sym_visibility.deleter
  def sym_visibility(self):
    del self.operation.attributes["sym_visibility"]

  @builtins.property
  def body(self):
    return self.regions[0]

def func(sym_name, function_type, *, arg_attrs=None, res_attrs=None, sym_visibility=None, loc=None, ip=None) -> _ods_ir.Operation:
  return FuncOp(sym_name=sym_name, function_type=function_type, arg_attrs=arg_attrs, res_attrs=res_attrs, sym_visibility=sym_visibility, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class FunctionLibraryOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.function_library"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, mapping, *, sym_visibility=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    if sym_visibility is not None: attributes["sym_visibility"] = (sym_visibility if (
        isinstance(sym_visibility, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(sym_visibility, context=_ods_context))
    attributes["mapping"] = (mapping if (
    isinstance(mapping, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DictionaryAttr')) else
      _ods_ir.AttrBuilder.get('DictionaryAttr')(mapping, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def sym_visibility(self):
    if "sym_visibility" not in self.operation.attributes:
      return None
    return self.operation.attributes["sym_visibility"]

  @sym_visibility.setter
  def sym_visibility(self, value):
    if value is not None:
      self.operation.attributes["sym_visibility"] = value
    elif "sym_visibility" in self.operation.attributes:
      del self.operation.attributes["sym_visibility"]

  @sym_visibility.deleter
  def sym_visibility(self):
    del self.operation.attributes["sym_visibility"]

  @builtins.property
  def mapping(self):
    return self.operation.attributes["mapping"]

  @mapping.setter
  def mapping(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["mapping"] = value

  @builtins.property
  def body(self):
    return self.regions[0]

def function_library(sym_name, mapping, *, sym_visibility=None, loc=None, ip=None) -> _ods_ir.Operation:
  return FunctionLibraryOp(sym_name=sym_name, mapping=mapping, sym_visibility=sym_visibility, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class GetExtentOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.get_extent"

  _ODS_REGIONS = (0, True)

  def __init__(self, shape, dim, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(shape)
    operands.append(dim)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def shape(self):
    return self.operation.operands[0]

  @builtins.property
  def dim(self):
    return self.operation.operands[1]

  @builtins.property
  def extent(self):
    return self.operation.results[0]

def get_extent(shape, dim, *, loc=None, ip=None) -> _ods_ir.Value:
  return GetExtentOp(shape=shape, dim=dim, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IndexToSizeOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.index_to_size"

  _ODS_REGIONS = (0, True)

  def __init__(self, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(arg)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def index_to_size(arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return IndexToSizeOp(arg=arg, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IsBroadcastableOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.is_broadcastable"

  _ODS_REGIONS = (0, True)

  def __init__(self, shapes, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(shapes))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def shapes(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def is_broadcastable(shapes, *, loc=None, ip=None) -> _ods_ir.Value:
  return IsBroadcastableOp(shapes=shapes, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MaxOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.max"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def max(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return MaxOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MeetOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.meet"

  _ODS_REGIONS = (0, True)

  def __init__(self, arg0, arg1, *, error=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(arg0)
    operands.append(arg1)
    _ods_context = _ods_get_default_loc_context(loc)
    if error is not None: attributes["error"] = (error if (
        isinstance(error, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(error, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def arg0(self):
    return self.operation.operands[0]

  @builtins.property
  def arg1(self):
    return self.operation.operands[1]

  @builtins.property
  def error(self):
    if "error" not in self.operation.attributes:
      return None
    return self.operation.attributes["error"]

  @error.setter
  def error(self, value):
    if value is not None:
      self.operation.attributes["error"] = value
    elif "error" in self.operation.attributes:
      del self.operation.attributes["error"]

  @error.deleter
  def error(self):
    del self.operation.attributes["error"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def meet(arg0, arg1, *, error=None, loc=None, ip=None) -> _ods_ir.Value:
  return MeetOp(arg0=arg0, arg1=arg1, error=error, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MinOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.min"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def min(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return MinOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MulOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.mul"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def mul(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return MulOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class NumElementsOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.num_elements"

  _ODS_REGIONS = (0, True)

  def __init__(self, shape, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(shape)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def shape(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def num_elements(shape, *, loc=None, ip=None) -> _ods_ir.Value:
  return NumElementsOp(shape=shape, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RankOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.rank"

  _ODS_REGIONS = (0, True)

  def __init__(self, shape, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(shape)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def shape(self):
    return self.operation.operands[0]

  @builtins.property
  def rank(self):
    return self.operation.results[0]

def rank(shape, *, loc=None, ip=None) -> _ods_ir.Value:
  return RankOp(shape=shape, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReduceOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.reduce"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, shape, initVals, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(shape)
    operands.extend(_get_op_results_or_values(initVals))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def shape(self):
    return self.operation.operands[0]

  @builtins.property
  def initVals(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def reduce(result, shape, init_vals, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ReduceOp(result=result, shape=shape, initVals=init_vals, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReturnOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, operands_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def return_(operands_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return ReturnOp(operands_=operands_, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ShapeEqOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.shape_eq"

  _ODS_REGIONS = (0, True)

  def __init__(self, shapes, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(shapes))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def shapes(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def shape_eq(shapes, *, loc=None, ip=None) -> _ods_ir.Value:
  return ShapeEqOp(shapes=shapes, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ShapeOfOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.shape_of"

  _ODS_REGIONS = (0, True)

  def __init__(self, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(arg)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def shape_of(arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return ShapeOfOp(arg=arg, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SizeToIndexOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.size_to_index"

  _ODS_REGIONS = (0, True)

  def __init__(self, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(arg)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def size_to_index(arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return SizeToIndexOp(arg=arg, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SplitAtOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.split_at"

  _ODS_REGIONS = (0, True)

  def __init__(self, head, tail, operand, index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(operand)
    operands.append(index)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(head)
    results.append(tail)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    return self.operation.operands[1]

  @builtins.property
  def head(self):
    return self.operation.results[0]

  @builtins.property
  def tail(self):
    return self.operation.results[1]

def split_at(head, tail, operand, index, *, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return SplitAtOp(head=head, tail=tail, operand=operand, index=index, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class ToExtentTensorOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.to_extent_tensor"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def to_extent_tensor(result, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return ToExtentTensorOp(result=result, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ValueAsShapeOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.value_as_shape"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(arg)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def value_as_shape(result, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return ValueAsShapeOp(result=result, arg=arg, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ValueOfOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.value_of"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(arg)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def value_of(result, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return ValueOfOp(result=result, arg=arg, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class WithOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.with_shape"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, shape, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(operand)
    operands.append(shape)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def shape(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def with_shape(operand, shape, *, loc=None, ip=None) -> _ods_ir.Value:
  return WithOp(operand=operand, shape=shape, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "shape.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, operands_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def yield_(operands_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return YieldOp(operands_=operands_, loc=loc, ip=ip)
