
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "pdl"

@_ods_cext.register_operation(_Dialect)
class ApplyNativeConstraintOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.apply_native_constraint"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, name, args, *, isNegated=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(args))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["name"] = (name if (
    isinstance(name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    if isNegated is not None: attributes["isNegated"] = (isNegated if (
        isinstance(isNegated, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(isNegated, context=_ods_context))
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def args(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

  @builtins.property
  def isNegated(self):
    return self.operation.attributes["isNegated"]

  @isNegated.setter
  def isNegated(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["isNegated"] = value

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def apply_native_constraint(results_, name, args, *, is_negated=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ApplyNativeConstraintOp(results_=results_, name=name, args=args, isNegated=is_negated, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ApplyNativeRewriteOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.apply_native_rewrite"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, name, args, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(args))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["name"] = (name if (
    isinstance(name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def args(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def apply_native_rewrite(results_, name, args, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ApplyNativeRewriteOp(results_=results_, name=name, args=args, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AttributeOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.attribute"

  _ODS_REGIONS = (0, True)

  def __init__(self, attr, *, valueType=None, value=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    if valueType is not None: operands.append(valueType)
    _ods_context = _ods_get_default_loc_context(loc)
    if value is not None: attributes["value"] = (value if (
        isinstance(value, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AnyAttr')) else
          _ods_ir.AttrBuilder.get('AnyAttr')(value, context=_ods_context))
    results.append(attr)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def valueType(self):
    return None if len(self.operation.operands) < 1 else self.operation.operands[0]

  @builtins.property
  def value(self):
    if "value" not in self.operation.attributes:
      return None
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is not None:
      self.operation.attributes["value"] = value
    elif "value" in self.operation.attributes:
      del self.operation.attributes["value"]

  @value.deleter
  def value(self):
    del self.operation.attributes["value"]

  @builtins.property
  def attr(self):
    return self.operation.results[0]

def attribute(attr, *, value_type=None, value=None, loc=None, ip=None) -> _ods_ir.Value:
  return AttributeOp(attr=attr, valueType=value_type, value=value, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class EraseOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.erase"

  _ODS_REGIONS = (0, True)

  def __init__(self, opValue, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(opValue)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def opValue(self):
    return self.operation.operands[0]

def erase(op_value, *, loc=None, ip=None) -> _ods_ir.Operation:
  return EraseOp(opValue=op_value, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class OperandOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.operand"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, valueType=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    if valueType is not None: operands.append(valueType)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(value)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def valueType(self):
    return None if len(self.operation.operands) < 1 else self.operation.operands[0]

  @builtins.property
  def value(self):
    return self.operation.results[0]

def operand(value, *, value_type=None, loc=None, ip=None) -> _ods_ir.Value:
  return OperandOp(value=value, valueType=value_type, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class OperandsOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.operands"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, valueType=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    if valueType is not None: operands.append(valueType)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(value)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def valueType(self):
    return None if len(self.operation.operands) < 1 else self.operation.operands[0]

  @builtins.property
  def value(self):
    return self.operation.results[0]

def operands_(value, *, value_type=None, loc=None, ip=None) -> _ods_ir.Value:
  return OperandsOp(value=value, valueType=value_type, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class OperationOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.operation"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, op, operandValues, attributeValues, attributeValueNames, typeValues, *, opName=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(operandValues))
    operands.append(_get_op_results_or_values(attributeValues))
    operands.append(_get_op_results_or_values(typeValues))
    _ods_context = _ods_get_default_loc_context(loc)
    if opName is not None: attributes["opName"] = (opName if (
        isinstance(opName, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(opName, context=_ods_context))
    attributes["attributeValueNames"] = (attributeValueNames if (
    isinstance(attributeValueNames, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrArrayAttr')) else
      _ods_ir.AttrBuilder.get('StrArrayAttr')(attributeValueNames, context=_ods_context))
    results.append(op)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operandValues(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def attributeValues(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def typeValues(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def opName(self):
    if "opName" not in self.operation.attributes:
      return None
    return self.operation.attributes["opName"]

  @opName.setter
  def opName(self, value):
    if value is not None:
      self.operation.attributes["opName"] = value
    elif "opName" in self.operation.attributes:
      del self.operation.attributes["opName"]

  @opName.deleter
  def opName(self):
    del self.operation.attributes["opName"]

  @builtins.property
  def attributeValueNames(self):
    return self.operation.attributes["attributeValueNames"]

  @attributeValueNames.setter
  def attributeValueNames(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["attributeValueNames"] = value

  @builtins.property
  def op(self):
    return self.operation.results[0]

def operation_(op, operand_values, attribute_values, attribute_value_names, type_values, *, op_name=None, loc=None, ip=None) -> _ods_ir.Value:
  return OperationOp(op=op, operandValues=operand_values, attributeValues=attribute_values, attributeValueNames=attribute_value_names, typeValues=type_values, opName=op_name, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PatternOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.pattern"

  _ODS_REGIONS = (1, True)

  def __init__(self, benefit, *, sym_name=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["benefit"] = (benefit if (
    isinstance(benefit, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I16Attr')) else
      _ods_ir.AttrBuilder.get('I16Attr')(benefit, context=_ods_context))
    if sym_name is not None: attributes["sym_name"] = (sym_name if (
        isinstance(sym_name, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
          _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def benefit(self):
    return self.operation.attributes["benefit"]

  @benefit.setter
  def benefit(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["benefit"] = value

  @builtins.property
  def sym_name(self):
    if "sym_name" not in self.operation.attributes:
      return None
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is not None:
      self.operation.attributes["sym_name"] = value
    elif "sym_name" in self.operation.attributes:
      del self.operation.attributes["sym_name"]

  @sym_name.deleter
  def sym_name(self):
    del self.operation.attributes["sym_name"]

  @builtins.property
  def bodyRegion(self):
    return self.regions[0]

def pattern(benefit, *, sym_name=None, loc=None, ip=None) -> _ods_ir.Operation:
  return PatternOp(benefit=benefit, sym_name=sym_name, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class RangeOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.range"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, arguments, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(arguments))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def arguments(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def range(result, arguments, *, loc=None, ip=None) -> _ods_ir.Value:
  return RangeOp(result=result, arguments=arguments, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReplaceOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.replace"

  _ODS_OPERAND_SEGMENTS = [1,0,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, opValue, replValues, *, replOperation=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(opValue)
    operands.append(replOperation)
    operands.append(_get_op_results_or_values(replValues))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def opValue(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def replOperation(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def replValues(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

def replace(op_value, repl_values, *, repl_operation=None, loc=None, ip=None) -> _ods_ir.Operation:
  return ReplaceOp(opValue=op_value, replValues=repl_values, replOperation=repl_operation, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ResultOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.result"

  _ODS_REGIONS = (0, True)

  def __init__(self, val, parent, index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(parent)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["index"] = (index if (
    isinstance(index, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(index, context=_ods_context))
    results.append(val)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def parent(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    return self.operation.attributes["index"]

  @index.setter
  def index(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["index"] = value

  @builtins.property
  def val(self):
    return self.operation.results[0]

def result(val, parent, index, *, loc=None, ip=None) -> _ods_ir.Value:
  return ResultOp(val=val, parent=parent, index=index, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ResultsOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.results"

  _ODS_REGIONS = (0, True)

  def __init__(self, val, parent, *, index=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(parent)
    _ods_context = _ods_get_default_loc_context(loc)
    if index is not None: attributes["index"] = (index if (
        isinstance(index, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(index, context=_ods_context))
    results.append(val)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def parent(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    if "index" not in self.operation.attributes:
      return None
    return self.operation.attributes["index"]

  @index.setter
  def index(self, value):
    if value is not None:
      self.operation.attributes["index"] = value
    elif "index" in self.operation.attributes:
      del self.operation.attributes["index"]

  @index.deleter
  def index(self):
    del self.operation.attributes["index"]

  @builtins.property
  def val(self):
    return self.operation.results[0]

def results_(val, parent, *, index=None, loc=None, ip=None) -> _ods_ir.Value:
  return ResultsOp(val=val, parent=parent, index=index, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RewriteOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.rewrite"

  _ODS_OPERAND_SEGMENTS = [0,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, externalArgs, *, root=None, name=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(root)
    operands.append(_get_op_results_or_values(externalArgs))
    _ods_context = _ods_get_default_loc_context(loc)
    if name is not None: attributes["name"] = (name if (
        isinstance(name, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def root(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def externalArgs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def name(self):
    if "name" not in self.operation.attributes:
      return None
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is not None:
      self.operation.attributes["name"] = value
    elif "name" in self.operation.attributes:
      del self.operation.attributes["name"]

  @name.deleter
  def name(self):
    del self.operation.attributes["name"]

  @builtins.property
  def bodyRegion(self):
    return self.regions[0]

def rewrite(external_args, *, root=None, name=None, loc=None, ip=None) -> _ods_ir.Operation:
  return RewriteOp(externalArgs=external_args, root=root, name=name, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TypeOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.type"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, constantType=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if constantType is not None: attributes["constantType"] = (constantType if (
        isinstance(constantType, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TypeAttr')) else
          _ods_ir.AttrBuilder.get('TypeAttr')(constantType, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def constantType(self):
    if "constantType" not in self.operation.attributes:
      return None
    return self.operation.attributes["constantType"]

  @constantType.setter
  def constantType(self, value):
    if value is not None:
      self.operation.attributes["constantType"] = value
    elif "constantType" in self.operation.attributes:
      del self.operation.attributes["constantType"]

  @constantType.deleter
  def constantType(self):
    del self.operation.attributes["constantType"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def type_(result, *, constant_type=None, loc=None, ip=None) -> _ods_ir.Value:
  return TypeOp(result=result, constantType=constant_type, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TypesOp(_ods_ir.OpView):
  OPERATION_NAME = "pdl.types"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, constantTypes=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if constantTypes is not None: attributes["constantTypes"] = (constantTypes if (
        isinstance(constantTypes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TypeArrayAttr')) else
          _ods_ir.AttrBuilder.get('TypeArrayAttr')(constantTypes, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def constantTypes(self):
    if "constantTypes" not in self.operation.attributes:
      return None
    return self.operation.attributes["constantTypes"]

  @constantTypes.setter
  def constantTypes(self, value):
    if value is not None:
      self.operation.attributes["constantTypes"] = value
    elif "constantTypes" in self.operation.attributes:
      del self.operation.attributes["constantTypes"]

  @constantTypes.deleter
  def constantTypes(self):
    del self.operation.attributes["constantTypes"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def types(result, *, constant_types=None, loc=None, ip=None) -> _ods_ir.Value:
  return TypesOp(result=result, constantTypes=constant_types, loc=loc, ip=ip).result
