
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "omp"

@_ods_cext.register_operation(_Dialect)
class AtomicCaptureOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.atomic.capture"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, hint=None, memory_order=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if hint is not None: attributes["hint"] = (hint if (
        isinstance(hint, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(hint, context=_ods_context))
    if memory_order is not None: attributes["memory_order"] = (memory_order if (
        isinstance(memory_order, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('MemoryOrderKindAttr')) else
          _ods_ir.AttrBuilder.get('MemoryOrderKindAttr')(memory_order, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def hint(self):
    if "hint" not in self.operation.attributes:
      return None
    return self.operation.attributes["hint"]

  @hint.setter
  def hint(self, value):
    if value is not None:
      self.operation.attributes["hint"] = value
    elif "hint" in self.operation.attributes:
      del self.operation.attributes["hint"]

  @hint.deleter
  def hint(self):
    del self.operation.attributes["hint"]

  @builtins.property
  def memory_order(self):
    if "memory_order" not in self.operation.attributes:
      return None
    return self.operation.attributes["memory_order"]

  @memory_order.setter
  def memory_order(self, value):
    if value is not None:
      self.operation.attributes["memory_order"] = value
    elif "memory_order" in self.operation.attributes:
      del self.operation.attributes["memory_order"]

  @memory_order.deleter
  def memory_order(self):
    del self.operation.attributes["memory_order"]

  @builtins.property
  def region(self):
    return self.regions[0]

def atomic_capture(*, hint=None, memory_order=None, loc=None, ip=None) -> _ods_ir.Operation:
  return AtomicCaptureOp(hint=hint, memory_order=memory_order, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class AtomicReadOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.atomic.read"

  _ODS_REGIONS = (0, True)

  def __init__(self, x, v, element_type, *, hint=None, memory_order=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(x)
    operands.append(v)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["element_type"] = (element_type if (
    isinstance(element_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(element_type, context=_ods_context))
    if hint is not None: attributes["hint"] = (hint if (
        isinstance(hint, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(hint, context=_ods_context))
    if memory_order is not None: attributes["memory_order"] = (memory_order if (
        isinstance(memory_order, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('MemoryOrderKindAttr')) else
          _ods_ir.AttrBuilder.get('MemoryOrderKindAttr')(memory_order, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def x(self):
    return self.operation.operands[0]

  @builtins.property
  def v(self):
    return self.operation.operands[1]

  @builtins.property
  def element_type(self):
    return self.operation.attributes["element_type"]

  @element_type.setter
  def element_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["element_type"] = value

  @builtins.property
  def hint(self):
    if "hint" not in self.operation.attributes:
      return None
    return self.operation.attributes["hint"]

  @hint.setter
  def hint(self, value):
    if value is not None:
      self.operation.attributes["hint"] = value
    elif "hint" in self.operation.attributes:
      del self.operation.attributes["hint"]

  @hint.deleter
  def hint(self):
    del self.operation.attributes["hint"]

  @builtins.property
  def memory_order(self):
    if "memory_order" not in self.operation.attributes:
      return None
    return self.operation.attributes["memory_order"]

  @memory_order.setter
  def memory_order(self, value):
    if value is not None:
      self.operation.attributes["memory_order"] = value
    elif "memory_order" in self.operation.attributes:
      del self.operation.attributes["memory_order"]

  @memory_order.deleter
  def memory_order(self):
    del self.operation.attributes["memory_order"]

def atomic_read(x, v, element_type, *, hint=None, memory_order=None, loc=None, ip=None) -> _ods_ir.Operation:
  return AtomicReadOp(x=x, v=v, element_type=element_type, hint=hint, memory_order=memory_order, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class AtomicUpdateOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.atomic.update"

  _ODS_REGIONS = (1, True)

  def __init__(self, x, *, hint=None, memory_order=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(x)
    _ods_context = _ods_get_default_loc_context(loc)
    if hint is not None: attributes["hint"] = (hint if (
        isinstance(hint, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(hint, context=_ods_context))
    if memory_order is not None: attributes["memory_order"] = (memory_order if (
        isinstance(memory_order, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('MemoryOrderKindAttr')) else
          _ods_ir.AttrBuilder.get('MemoryOrderKindAttr')(memory_order, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def x(self):
    return self.operation.operands[0]

  @builtins.property
  def hint(self):
    if "hint" not in self.operation.attributes:
      return None
    return self.operation.attributes["hint"]

  @hint.setter
  def hint(self, value):
    if value is not None:
      self.operation.attributes["hint"] = value
    elif "hint" in self.operation.attributes:
      del self.operation.attributes["hint"]

  @hint.deleter
  def hint(self):
    del self.operation.attributes["hint"]

  @builtins.property
  def memory_order(self):
    if "memory_order" not in self.operation.attributes:
      return None
    return self.operation.attributes["memory_order"]

  @memory_order.setter
  def memory_order(self, value):
    if value is not None:
      self.operation.attributes["memory_order"] = value
    elif "memory_order" in self.operation.attributes:
      del self.operation.attributes["memory_order"]

  @memory_order.deleter
  def memory_order(self):
    del self.operation.attributes["memory_order"]

  @builtins.property
  def region(self):
    return self.regions[0]

def atomic_update(x, *, hint=None, memory_order=None, loc=None, ip=None) -> _ods_ir.Operation:
  return AtomicUpdateOp(x=x, hint=hint, memory_order=memory_order, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class AtomicWriteOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.atomic.write"

  _ODS_REGIONS = (0, True)

  def __init__(self, x, expr, *, hint=None, memory_order=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(x)
    operands.append(expr)
    _ods_context = _ods_get_default_loc_context(loc)
    if hint is not None: attributes["hint"] = (hint if (
        isinstance(hint, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(hint, context=_ods_context))
    if memory_order is not None: attributes["memory_order"] = (memory_order if (
        isinstance(memory_order, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('MemoryOrderKindAttr')) else
          _ods_ir.AttrBuilder.get('MemoryOrderKindAttr')(memory_order, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def x(self):
    return self.operation.operands[0]

  @builtins.property
  def expr(self):
    return self.operation.operands[1]

  @builtins.property
  def hint(self):
    if "hint" not in self.operation.attributes:
      return None
    return self.operation.attributes["hint"]

  @hint.setter
  def hint(self, value):
    if value is not None:
      self.operation.attributes["hint"] = value
    elif "hint" in self.operation.attributes:
      del self.operation.attributes["hint"]

  @hint.deleter
  def hint(self):
    del self.operation.attributes["hint"]

  @builtins.property
  def memory_order(self):
    if "memory_order" not in self.operation.attributes:
      return None
    return self.operation.attributes["memory_order"]

  @memory_order.setter
  def memory_order(self, value):
    if value is not None:
      self.operation.attributes["memory_order"] = value
    elif "memory_order" in self.operation.attributes:
      del self.operation.attributes["memory_order"]

  @memory_order.deleter
  def memory_order(self):
    del self.operation.attributes["memory_order"]

def atomic_write(x, expr, *, hint=None, memory_order=None, loc=None, ip=None) -> _ods_ir.Operation:
  return AtomicWriteOp(x=x, expr=expr, hint=hint, memory_order=memory_order, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class BarrierOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.barrier"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

def barrier(*, loc=None, ip=None) -> _ods_ir.Operation:
  return BarrierOp(loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class CancelOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.cancel"

  _ODS_REGIONS = (0, True)

  def __init__(self, cancel_directive, *, if_expr=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    if if_expr is not None: operands.append(if_expr)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["cancel_directive"] = (cancel_directive if (
    isinstance(cancel_directive, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('CancellationConstructTypeAttr')) else
      _ods_ir.AttrBuilder.get('CancellationConstructTypeAttr')(cancel_directive, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def if_expr(self):
    return None if len(self.operation.operands) < 1 else self.operation.operands[0]

  @builtins.property
  def cancel_directive(self):
    return self.operation.attributes["cancel_directive"]

  @cancel_directive.setter
  def cancel_directive(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["cancel_directive"] = value

def cancel(cancel_directive, *, if_expr=None, loc=None, ip=None) -> _ods_ir.Operation:
  return CancelOp(cancel_directive=cancel_directive, if_expr=if_expr, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class CancellationPointOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.cancellation_point"

  _ODS_REGIONS = (0, True)

  def __init__(self, cancel_directive, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["cancel_directive"] = (cancel_directive if (
    isinstance(cancel_directive, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('CancellationConstructTypeAttr')) else
      _ods_ir.AttrBuilder.get('CancellationConstructTypeAttr')(cancel_directive, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def cancel_directive(self):
    return self.operation.attributes["cancel_directive"]

  @cancel_directive.setter
  def cancel_directive(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["cancel_directive"] = value

def cancellation_point(cancel_directive, *, loc=None, ip=None) -> _ods_ir.Operation:
  return CancellationPointOp(cancel_directive=cancel_directive, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class CriticalDeclareOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.critical.declare"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, *, hint=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    if hint is not None: attributes["hint"] = (hint if (
        isinstance(hint, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(hint, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def hint(self):
    if "hint" not in self.operation.attributes:
      return None
    return self.operation.attributes["hint"]

  @hint.setter
  def hint(self, value):
    if value is not None:
      self.operation.attributes["hint"] = value
    elif "hint" in self.operation.attributes:
      del self.operation.attributes["hint"]

  @hint.deleter
  def hint(self):
    del self.operation.attributes["hint"]

def critical_declare(sym_name, *, hint=None, loc=None, ip=None) -> _ods_ir.Operation:
  return CriticalDeclareOp(sym_name=sym_name, hint=hint, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class CriticalOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.critical"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, name=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if name is not None: attributes["name"] = (name if (
        isinstance(name, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def name(self):
    if "name" not in self.operation.attributes:
      return None
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is not None:
      self.operation.attributes["name"] = value
    elif "name" in self.operation.attributes:
      del self.operation.attributes["name"]

  @name.deleter
  def name(self):
    del self.operation.attributes["name"]

  @builtins.property
  def region(self):
    return self.regions[0]

def critical(*, name=None, loc=None, ip=None) -> _ods_ir.Operation:
  return CriticalOp(name=name, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class DeclareMapperInfoOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.declare_mapper.info"

  _ODS_REGIONS = (0, True)

  def __init__(self, map_vars, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(map_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def map_vars(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def declare_mapper_info(map_vars, *, loc=None, ip=None) -> _ods_ir.Operation:
  return DeclareMapperInfoOp(map_vars=map_vars, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class DeclareMapperOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.declare_mapper"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, type_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["type"] = (type_ if (
    isinstance(type_, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(type_, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def type_(self):
    return self.operation.attributes["type"]

  @type_.setter
  def type_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["type"] = value

  @builtins.property
  def body(self):
    return self.regions[0]

def declare_mapper(sym_name, type_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return DeclareMapperOp(sym_name=sym_name, type_=type_, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class DeclareReductionOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.declare_reduction"

  _ODS_REGIONS = (5, True)

  def __init__(self, sym_name, type_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["type"] = (type_ if (
    isinstance(type_, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(type_, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def type_(self):
    return self.operation.attributes["type"]

  @type_.setter
  def type_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["type"] = value

  @builtins.property
  def allocRegion(self):
    return self.regions[0]

  @builtins.property
  def initializerRegion(self):
    return self.regions[1]

  @builtins.property
  def reductionRegion(self):
    return self.regions[2]

  @builtins.property
  def atomicReductionRegion(self):
    return self.regions[3]

  @builtins.property
  def cleanupRegion(self):
    return self.regions[4]

def declare_reduction(sym_name, type_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return DeclareReductionOp(sym_name=sym_name, type_=type_, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class DistributeOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.distribute"

  _ODS_OPERAND_SEGMENTS = [-1,-1,0,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, allocate_vars, allocator_vars, private_vars, *, dist_schedule_static=None, dist_schedule_chunk_size=None, order=None, order_mod=None, private_syms=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocator_vars))
    operands.append(dist_schedule_chunk_size)
    operands.append(_get_op_results_or_values(private_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(dist_schedule_static): attributes["dist_schedule_static"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if order is not None: attributes["order"] = (order if (
        isinstance(order, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('OrderKindAttr')) else
          _ods_ir.AttrBuilder.get('OrderKindAttr')(order, context=_ods_context))
    if order_mod is not None: attributes["order_mod"] = (order_mod if (
        isinstance(order_mod, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('OrderModifierAttr')) else
          _ods_ir.AttrBuilder.get('OrderModifierAttr')(order_mod, context=_ods_context))
    if private_syms is not None: attributes["private_syms"] = (private_syms if (
        isinstance(private_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(private_syms, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def allocator_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def dist_schedule_chunk_size(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def private_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def dist_schedule_static(self):
    return "dist_schedule_static" in self.operation.attributes

  @dist_schedule_static.setter
  def dist_schedule_static(self, value):
    if bool(value):
      self.operation.attributes["dist_schedule_static"] = _ods_ir.UnitAttr.get()
    elif "dist_schedule_static" in self.operation.attributes:
      del self.operation.attributes["dist_schedule_static"]

  @dist_schedule_static.deleter
  def dist_schedule_static(self):
    del self.operation.attributes["dist_schedule_static"]

  @builtins.property
  def order(self):
    if "order" not in self.operation.attributes:
      return None
    return self.operation.attributes["order"]

  @order.setter
  def order(self, value):
    if value is not None:
      self.operation.attributes["order"] = value
    elif "order" in self.operation.attributes:
      del self.operation.attributes["order"]

  @order.deleter
  def order(self):
    del self.operation.attributes["order"]

  @builtins.property
  def order_mod(self):
    if "order_mod" not in self.operation.attributes:
      return None
    return self.operation.attributes["order_mod"]

  @order_mod.setter
  def order_mod(self, value):
    if value is not None:
      self.operation.attributes["order_mod"] = value
    elif "order_mod" in self.operation.attributes:
      del self.operation.attributes["order_mod"]

  @order_mod.deleter
  def order_mod(self):
    del self.operation.attributes["order_mod"]

  @builtins.property
  def private_syms(self):
    if "private_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["private_syms"]

  @private_syms.setter
  def private_syms(self, value):
    if value is not None:
      self.operation.attributes["private_syms"] = value
    elif "private_syms" in self.operation.attributes:
      del self.operation.attributes["private_syms"]

  @private_syms.deleter
  def private_syms(self):
    del self.operation.attributes["private_syms"]

  @builtins.property
  def region(self):
    return self.regions[0]

def distribute(allocate_vars, allocator_vars, private_vars, *, dist_schedule_static=None, dist_schedule_chunk_size=None, order=None, order_mod=None, private_syms=None, loc=None, ip=None) -> _ods_ir.Operation:
  return DistributeOp(allocate_vars=allocate_vars, allocator_vars=allocator_vars, private_vars=private_vars, dist_schedule_static=dist_schedule_static, dist_schedule_chunk_size=dist_schedule_chunk_size, order=order, order_mod=order_mod, private_syms=private_syms, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class FlushOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.flush"

  _ODS_REGIONS = (0, True)

  def __init__(self, varList, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(varList))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def varList(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def flush(var_list, *, loc=None, ip=None) -> _ods_ir.Operation:
  return FlushOp(varList=var_list, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class LoopNestOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.loop_nest"

  _ODS_REGIONS = (1, True)

  def __init__(self, loop_lower_bounds, loop_upper_bounds, loop_steps, *, loop_inclusive=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(loop_lower_bounds))
    operands.extend(_get_op_results_or_values(loop_upper_bounds))
    operands.extend(_get_op_results_or_values(loop_steps))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(loop_inclusive): attributes["loop_inclusive"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def loop_lower_bounds(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 0, 3, 0, 0)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def loop_upper_bounds(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 0, 3, 0, 1)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def loop_steps(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 0, 3, 0, 2)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def loop_inclusive(self):
    return "loop_inclusive" in self.operation.attributes

  @loop_inclusive.setter
  def loop_inclusive(self, value):
    if bool(value):
      self.operation.attributes["loop_inclusive"] = _ods_ir.UnitAttr.get()
    elif "loop_inclusive" in self.operation.attributes:
      del self.operation.attributes["loop_inclusive"]

  @loop_inclusive.deleter
  def loop_inclusive(self):
    del self.operation.attributes["loop_inclusive"]

  @builtins.property
  def region(self):
    return self.regions[0]

def loop_nest(loop_lower_bounds, loop_upper_bounds, loop_steps, *, loop_inclusive=None, loc=None, ip=None) -> _ods_ir.Operation:
  return LoopNestOp(loop_lower_bounds=loop_lower_bounds, loop_upper_bounds=loop_upper_bounds, loop_steps=loop_steps, loop_inclusive=loop_inclusive, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class LoopOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.loop"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, private_vars, reduction_vars, *, bind_kind=None, private_syms=None, order=None, order_mod=None, reduction_mod=None, reduction_byref=None, reduction_syms=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(private_vars))
    operands.append(_get_op_results_or_values(reduction_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if bind_kind is not None: attributes["bind_kind"] = (bind_kind if (
        isinstance(bind_kind, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BindKindAttr')) else
          _ods_ir.AttrBuilder.get('BindKindAttr')(bind_kind, context=_ods_context))
    if private_syms is not None: attributes["private_syms"] = (private_syms if (
        isinstance(private_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(private_syms, context=_ods_context))
    if order is not None: attributes["order"] = (order if (
        isinstance(order, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('OrderKindAttr')) else
          _ods_ir.AttrBuilder.get('OrderKindAttr')(order, context=_ods_context))
    if order_mod is not None: attributes["order_mod"] = (order_mod if (
        isinstance(order_mod, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('OrderModifierAttr')) else
          _ods_ir.AttrBuilder.get('OrderModifierAttr')(order_mod, context=_ods_context))
    if reduction_mod is not None: attributes["reduction_mod"] = (reduction_mod if (
        isinstance(reduction_mod, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ReductionModifierAttr')) else
          _ods_ir.AttrBuilder.get('ReductionModifierAttr')(reduction_mod, context=_ods_context))
    if reduction_byref is not None: attributes["reduction_byref"] = (reduction_byref if (
        isinstance(reduction_byref, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(reduction_byref, context=_ods_context))
    if reduction_syms is not None: attributes["reduction_syms"] = (reduction_syms if (
        isinstance(reduction_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(reduction_syms, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def private_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def bind_kind(self):
    if "bind_kind" not in self.operation.attributes:
      return None
    return self.operation.attributes["bind_kind"]

  @bind_kind.setter
  def bind_kind(self, value):
    if value is not None:
      self.operation.attributes["bind_kind"] = value
    elif "bind_kind" in self.operation.attributes:
      del self.operation.attributes["bind_kind"]

  @bind_kind.deleter
  def bind_kind(self):
    del self.operation.attributes["bind_kind"]

  @builtins.property
  def private_syms(self):
    if "private_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["private_syms"]

  @private_syms.setter
  def private_syms(self, value):
    if value is not None:
      self.operation.attributes["private_syms"] = value
    elif "private_syms" in self.operation.attributes:
      del self.operation.attributes["private_syms"]

  @private_syms.deleter
  def private_syms(self):
    del self.operation.attributes["private_syms"]

  @builtins.property
  def order(self):
    if "order" not in self.operation.attributes:
      return None
    return self.operation.attributes["order"]

  @order.setter
  def order(self, value):
    if value is not None:
      self.operation.attributes["order"] = value
    elif "order" in self.operation.attributes:
      del self.operation.attributes["order"]

  @order.deleter
  def order(self):
    del self.operation.attributes["order"]

  @builtins.property
  def order_mod(self):
    if "order_mod" not in self.operation.attributes:
      return None
    return self.operation.attributes["order_mod"]

  @order_mod.setter
  def order_mod(self, value):
    if value is not None:
      self.operation.attributes["order_mod"] = value
    elif "order_mod" in self.operation.attributes:
      del self.operation.attributes["order_mod"]

  @order_mod.deleter
  def order_mod(self):
    del self.operation.attributes["order_mod"]

  @builtins.property
  def reduction_mod(self):
    if "reduction_mod" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_mod"]

  @reduction_mod.setter
  def reduction_mod(self, value):
    if value is not None:
      self.operation.attributes["reduction_mod"] = value
    elif "reduction_mod" in self.operation.attributes:
      del self.operation.attributes["reduction_mod"]

  @reduction_mod.deleter
  def reduction_mod(self):
    del self.operation.attributes["reduction_mod"]

  @builtins.property
  def reduction_byref(self):
    if "reduction_byref" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_byref"]

  @reduction_byref.setter
  def reduction_byref(self, value):
    if value is not None:
      self.operation.attributes["reduction_byref"] = value
    elif "reduction_byref" in self.operation.attributes:
      del self.operation.attributes["reduction_byref"]

  @reduction_byref.deleter
  def reduction_byref(self):
    del self.operation.attributes["reduction_byref"]

  @builtins.property
  def reduction_syms(self):
    if "reduction_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_syms"]

  @reduction_syms.setter
  def reduction_syms(self, value):
    if value is not None:
      self.operation.attributes["reduction_syms"] = value
    elif "reduction_syms" in self.operation.attributes:
      del self.operation.attributes["reduction_syms"]

  @reduction_syms.deleter
  def reduction_syms(self):
    del self.operation.attributes["reduction_syms"]

  @builtins.property
  def region(self):
    return self.regions[0]

def loop(private_vars, reduction_vars, *, bind_kind=None, private_syms=None, order=None, order_mod=None, reduction_mod=None, reduction_byref=None, reduction_syms=None, loc=None, ip=None) -> _ods_ir.Operation:
  return LoopOp(private_vars=private_vars, reduction_vars=reduction_vars, bind_kind=bind_kind, private_syms=private_syms, order=order, order_mod=order_mod, reduction_mod=reduction_mod, reduction_byref=reduction_byref, reduction_syms=reduction_syms, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class MapBoundsOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.map.bounds"

  _ODS_OPERAND_SEGMENTS = [0,0,0,0,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, lower_bound=None, upper_bound=None, extent=None, stride=None, stride_in_bytes=None, start_idx=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lower_bound)
    operands.append(upper_bound)
    operands.append(extent)
    operands.append(stride)
    operands.append(start_idx)
    _ods_context = _ods_get_default_loc_context(loc)
    if stride_in_bytes is not None: attributes["stride_in_bytes"] = (stride_in_bytes if (
        isinstance(stride_in_bytes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(stride_in_bytes, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lower_bound(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def upper_bound(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def extent(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def stride(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def start_idx(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def stride_in_bytes(self):
    return self.operation.attributes["stride_in_bytes"]

  @stride_in_bytes.setter
  def stride_in_bytes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["stride_in_bytes"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def map_bounds(result, *, lower_bound=None, upper_bound=None, extent=None, stride=None, stride_in_bytes=None, start_idx=None, loc=None, ip=None) -> _ods_ir.Value:
  return MapBoundsOp(result=result, lower_bound=lower_bound, upper_bound=upper_bound, extent=extent, stride=stride, stride_in_bytes=stride_in_bytes, start_idx=start_idx, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MapInfoOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.map.info"

  _ODS_OPERAND_SEGMENTS = [1,0,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, omp_ptr, var_ptr, var_type, members, bounds, *, var_ptr_ptr=None, members_index=None, map_type=None, mapper_id=None, map_capture_type=None, name=None, partial_map=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(var_ptr)
    operands.append(var_ptr_ptr)
    operands.append(_get_op_results_or_values(members))
    operands.append(_get_op_results_or_values(bounds))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["var_type"] = (var_type if (
    isinstance(var_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(var_type, context=_ods_context))
    if members_index is not None: attributes["members_index"] = (members_index if (
        isinstance(members_index, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('IndexListArrayAttr')) else
          _ods_ir.AttrBuilder.get('IndexListArrayAttr')(members_index, context=_ods_context))
    if map_type is not None: attributes["map_type"] = (map_type if (
        isinstance(map_type, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('UI64Attr')) else
          _ods_ir.AttrBuilder.get('UI64Attr')(map_type, context=_ods_context))
    if mapper_id is not None: attributes["mapper_id"] = (mapper_id if (
        isinstance(mapper_id, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(mapper_id, context=_ods_context))
    if map_capture_type is not None: attributes["map_capture_type"] = (map_capture_type if (
        isinstance(map_capture_type, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('VariableCaptureKindAttr')) else
          _ods_ir.AttrBuilder.get('VariableCaptureKindAttr')(map_capture_type, context=_ods_context))
    if name is not None: attributes["name"] = (name if (
        isinstance(name, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    if partial_map is not None: attributes["partial_map"] = (partial_map if (
        isinstance(partial_map, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(partial_map, context=_ods_context))
    results.append(omp_ptr)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def var_ptr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def var_ptr_ptr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def members(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def bounds(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def var_type(self):
    return self.operation.attributes["var_type"]

  @var_type.setter
  def var_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["var_type"] = value

  @builtins.property
  def members_index(self):
    if "members_index" not in self.operation.attributes:
      return None
    return self.operation.attributes["members_index"]

  @members_index.setter
  def members_index(self, value):
    if value is not None:
      self.operation.attributes["members_index"] = value
    elif "members_index" in self.operation.attributes:
      del self.operation.attributes["members_index"]

  @members_index.deleter
  def members_index(self):
    del self.operation.attributes["members_index"]

  @builtins.property
  def map_type(self):
    if "map_type" not in self.operation.attributes:
      return None
    return self.operation.attributes["map_type"]

  @map_type.setter
  def map_type(self, value):
    if value is not None:
      self.operation.attributes["map_type"] = value
    elif "map_type" in self.operation.attributes:
      del self.operation.attributes["map_type"]

  @map_type.deleter
  def map_type(self):
    del self.operation.attributes["map_type"]

  @builtins.property
  def mapper_id(self):
    if "mapper_id" not in self.operation.attributes:
      return None
    return self.operation.attributes["mapper_id"]

  @mapper_id.setter
  def mapper_id(self, value):
    if value is not None:
      self.operation.attributes["mapper_id"] = value
    elif "mapper_id" in self.operation.attributes:
      del self.operation.attributes["mapper_id"]

  @mapper_id.deleter
  def mapper_id(self):
    del self.operation.attributes["mapper_id"]

  @builtins.property
  def map_capture_type(self):
    if "map_capture_type" not in self.operation.attributes:
      return None
    return self.operation.attributes["map_capture_type"]

  @map_capture_type.setter
  def map_capture_type(self, value):
    if value is not None:
      self.operation.attributes["map_capture_type"] = value
    elif "map_capture_type" in self.operation.attributes:
      del self.operation.attributes["map_capture_type"]

  @map_capture_type.deleter
  def map_capture_type(self):
    del self.operation.attributes["map_capture_type"]

  @builtins.property
  def name(self):
    if "name" not in self.operation.attributes:
      return None
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is not None:
      self.operation.attributes["name"] = value
    elif "name" in self.operation.attributes:
      del self.operation.attributes["name"]

  @name.deleter
  def name(self):
    del self.operation.attributes["name"]

  @builtins.property
  def partial_map(self):
    return self.operation.attributes["partial_map"]

  @partial_map.setter
  def partial_map(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["partial_map"] = value

  @builtins.property
  def omp_ptr(self):
    return self.operation.results[0]

def map_info(omp_ptr, var_ptr, var_type, members, bounds, *, var_ptr_ptr=None, members_index=None, map_type=None, mapper_id=None, map_capture_type=None, name=None, partial_map=None, loc=None, ip=None) -> _ods_ir.Value:
  return MapInfoOp(omp_ptr=omp_ptr, var_ptr=var_ptr, var_type=var_type, members=members, bounds=bounds, var_ptr_ptr=var_ptr_ptr, members_index=members_index, map_type=map_type, mapper_id=mapper_id, map_capture_type=map_capture_type, name=name, partial_map=partial_map, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MaskedOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.masked"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, filtered_thread_id=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    if filtered_thread_id is not None: operands.append(filtered_thread_id)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def filtered_thread_id(self):
    return None if len(self.operation.operands) < 1 else self.operation.operands[0]

  @builtins.property
  def region(self):
    return self.regions[0]

def masked(*, filtered_thread_id=None, loc=None, ip=None) -> _ods_ir.Operation:
  return MaskedOp(filtered_thread_id=filtered_thread_id, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class MasterOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.master"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def region(self):
    return self.regions[0]

def master(*, loc=None, ip=None) -> _ods_ir.Operation:
  return MasterOp(loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class OrderedOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.ordered"

  _ODS_REGIONS = (0, True)

  def __init__(self, doacross_depend_vars, *, doacross_depend_type=None, doacross_num_loops=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(doacross_depend_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if doacross_depend_type is not None: attributes["doacross_depend_type"] = (doacross_depend_type if (
        isinstance(doacross_depend_type, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ClauseDependAttr')) else
          _ods_ir.AttrBuilder.get('ClauseDependAttr')(doacross_depend_type, context=_ods_context))
    if doacross_num_loops is not None: attributes["doacross_num_loops"] = (doacross_num_loops if (
        isinstance(doacross_num_loops, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(doacross_num_loops, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def doacross_depend_vars(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def doacross_depend_type(self):
    if "doacross_depend_type" not in self.operation.attributes:
      return None
    return self.operation.attributes["doacross_depend_type"]

  @doacross_depend_type.setter
  def doacross_depend_type(self, value):
    if value is not None:
      self.operation.attributes["doacross_depend_type"] = value
    elif "doacross_depend_type" in self.operation.attributes:
      del self.operation.attributes["doacross_depend_type"]

  @doacross_depend_type.deleter
  def doacross_depend_type(self):
    del self.operation.attributes["doacross_depend_type"]

  @builtins.property
  def doacross_num_loops(self):
    if "doacross_num_loops" not in self.operation.attributes:
      return None
    return self.operation.attributes["doacross_num_loops"]

  @doacross_num_loops.setter
  def doacross_num_loops(self, value):
    if value is not None:
      self.operation.attributes["doacross_num_loops"] = value
    elif "doacross_num_loops" in self.operation.attributes:
      del self.operation.attributes["doacross_num_loops"]

  @doacross_num_loops.deleter
  def doacross_num_loops(self):
    del self.operation.attributes["doacross_num_loops"]

def ordered(doacross_depend_vars, *, doacross_depend_type=None, doacross_num_loops=None, loc=None, ip=None) -> _ods_ir.Operation:
  return OrderedOp(doacross_depend_vars=doacross_depend_vars, doacross_depend_type=doacross_depend_type, doacross_num_loops=doacross_num_loops, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class OrderedRegionOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.ordered.region"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, par_level_simd=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(par_level_simd): attributes["par_level_simd"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def par_level_simd(self):
    return "par_level_simd" in self.operation.attributes

  @par_level_simd.setter
  def par_level_simd(self, value):
    if bool(value):
      self.operation.attributes["par_level_simd"] = _ods_ir.UnitAttr.get()
    elif "par_level_simd" in self.operation.attributes:
      del self.operation.attributes["par_level_simd"]

  @par_level_simd.deleter
  def par_level_simd(self):
    del self.operation.attributes["par_level_simd"]

  @builtins.property
  def region(self):
    return self.regions[0]

def ordered_region(*, par_level_simd=None, loc=None, ip=None) -> _ods_ir.Operation:
  return OrderedRegionOp(par_level_simd=par_level_simd, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ParallelOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.parallel"

  _ODS_OPERAND_SEGMENTS = [-1,-1,0,0,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, allocate_vars, allocator_vars, private_vars, reduction_vars, *, if_expr=None, num_threads=None, private_syms=None, proc_bind_kind=None, reduction_mod=None, reduction_byref=None, reduction_syms=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocator_vars))
    operands.append(if_expr)
    operands.append(num_threads)
    operands.append(_get_op_results_or_values(private_vars))
    operands.append(_get_op_results_or_values(reduction_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if private_syms is not None: attributes["private_syms"] = (private_syms if (
        isinstance(private_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(private_syms, context=_ods_context))
    if proc_bind_kind is not None: attributes["proc_bind_kind"] = (proc_bind_kind if (
        isinstance(proc_bind_kind, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ProcBindKindAttr')) else
          _ods_ir.AttrBuilder.get('ProcBindKindAttr')(proc_bind_kind, context=_ods_context))
    if reduction_mod is not None: attributes["reduction_mod"] = (reduction_mod if (
        isinstance(reduction_mod, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ReductionModifierAttr')) else
          _ods_ir.AttrBuilder.get('ReductionModifierAttr')(reduction_mod, context=_ods_context))
    if reduction_byref is not None: attributes["reduction_byref"] = (reduction_byref if (
        isinstance(reduction_byref, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(reduction_byref, context=_ods_context))
    if reduction_syms is not None: attributes["reduction_syms"] = (reduction_syms if (
        isinstance(reduction_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(reduction_syms, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def allocator_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def num_threads(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def private_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range

  @builtins.property
  def reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range

  @builtins.property
  def private_syms(self):
    if "private_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["private_syms"]

  @private_syms.setter
  def private_syms(self, value):
    if value is not None:
      self.operation.attributes["private_syms"] = value
    elif "private_syms" in self.operation.attributes:
      del self.operation.attributes["private_syms"]

  @private_syms.deleter
  def private_syms(self):
    del self.operation.attributes["private_syms"]

  @builtins.property
  def proc_bind_kind(self):
    if "proc_bind_kind" not in self.operation.attributes:
      return None
    return self.operation.attributes["proc_bind_kind"]

  @proc_bind_kind.setter
  def proc_bind_kind(self, value):
    if value is not None:
      self.operation.attributes["proc_bind_kind"] = value
    elif "proc_bind_kind" in self.operation.attributes:
      del self.operation.attributes["proc_bind_kind"]

  @proc_bind_kind.deleter
  def proc_bind_kind(self):
    del self.operation.attributes["proc_bind_kind"]

  @builtins.property
  def reduction_mod(self):
    if "reduction_mod" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_mod"]

  @reduction_mod.setter
  def reduction_mod(self, value):
    if value is not None:
      self.operation.attributes["reduction_mod"] = value
    elif "reduction_mod" in self.operation.attributes:
      del self.operation.attributes["reduction_mod"]

  @reduction_mod.deleter
  def reduction_mod(self):
    del self.operation.attributes["reduction_mod"]

  @builtins.property
  def reduction_byref(self):
    if "reduction_byref" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_byref"]

  @reduction_byref.setter
  def reduction_byref(self, value):
    if value is not None:
      self.operation.attributes["reduction_byref"] = value
    elif "reduction_byref" in self.operation.attributes:
      del self.operation.attributes["reduction_byref"]

  @reduction_byref.deleter
  def reduction_byref(self):
    del self.operation.attributes["reduction_byref"]

  @builtins.property
  def reduction_syms(self):
    if "reduction_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_syms"]

  @reduction_syms.setter
  def reduction_syms(self, value):
    if value is not None:
      self.operation.attributes["reduction_syms"] = value
    elif "reduction_syms" in self.operation.attributes:
      del self.operation.attributes["reduction_syms"]

  @reduction_syms.deleter
  def reduction_syms(self):
    del self.operation.attributes["reduction_syms"]

  @builtins.property
  def region(self):
    return self.regions[0]

def parallel(allocate_vars, allocator_vars, private_vars, reduction_vars, *, if_expr=None, num_threads=None, private_syms=None, proc_bind_kind=None, reduction_mod=None, reduction_byref=None, reduction_syms=None, loc=None, ip=None) -> _ods_ir.Operation:
  return ParallelOp(allocate_vars=allocate_vars, allocator_vars=allocator_vars, private_vars=private_vars, reduction_vars=reduction_vars, if_expr=if_expr, num_threads=num_threads, private_syms=private_syms, proc_bind_kind=proc_bind_kind, reduction_mod=reduction_mod, reduction_byref=reduction_byref, reduction_syms=reduction_syms, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class PrivateClauseOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.private"

  _ODS_REGIONS = (3, True)

  def __init__(self, sym_name, type_, data_sharing_type, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["type"] = (type_ if (
    isinstance(type_, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_773')) else
      _ods_ir.AttrBuilder.get('anonymous_773')(type_, context=_ods_context))
    attributes["data_sharing_type"] = (data_sharing_type if (
    isinstance(data_sharing_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DataSharingClauseTypeAttr')) else
      _ods_ir.AttrBuilder.get('DataSharingClauseTypeAttr')(data_sharing_type, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def type_(self):
    return self.operation.attributes["type"]

  @type_.setter
  def type_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["type"] = value

  @builtins.property
  def data_sharing_type(self):
    return self.operation.attributes["data_sharing_type"]

  @data_sharing_type.setter
  def data_sharing_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["data_sharing_type"] = value

  @builtins.property
  def init_region(self):
    return self.regions[0]

  @builtins.property
  def copy_region(self):
    return self.regions[1]

  @builtins.property
  def dealloc_region(self):
    return self.regions[2]

def private(sym_name, type_, data_sharing_type, *, loc=None, ip=None) -> _ods_ir.Operation:
  return PrivateClauseOp(sym_name=sym_name, type_=type_, data_sharing_type=data_sharing_type, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ScanOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.scan"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, inclusive_vars, exclusive_vars, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inclusive_vars))
    operands.append(_get_op_results_or_values(exclusive_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def inclusive_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def exclusive_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

def scan(inclusive_vars, exclusive_vars, *, loc=None, ip=None) -> _ods_ir.Operation:
  return ScanOp(inclusive_vars=inclusive_vars, exclusive_vars=exclusive_vars, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SectionOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.section"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def region(self):
    return self.regions[0]

def section(*, loc=None, ip=None) -> _ods_ir.Operation:
  return SectionOp(loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SectionsOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.sections"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, allocate_vars, allocator_vars, private_vars, reduction_vars, *, nowait=None, private_syms=None, reduction_mod=None, reduction_byref=None, reduction_syms=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocator_vars))
    operands.append(_get_op_results_or_values(private_vars))
    operands.append(_get_op_results_or_values(reduction_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if private_syms is not None: attributes["private_syms"] = (private_syms if (
        isinstance(private_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(private_syms, context=_ods_context))
    if reduction_mod is not None: attributes["reduction_mod"] = (reduction_mod if (
        isinstance(reduction_mod, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ReductionModifierAttr')) else
          _ods_ir.AttrBuilder.get('ReductionModifierAttr')(reduction_mod, context=_ods_context))
    if reduction_byref is not None: attributes["reduction_byref"] = (reduction_byref if (
        isinstance(reduction_byref, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(reduction_byref, context=_ods_context))
    if reduction_syms is not None: attributes["reduction_syms"] = (reduction_syms if (
        isinstance(reduction_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(reduction_syms, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def allocator_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def private_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

  @builtins.property
  def private_syms(self):
    if "private_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["private_syms"]

  @private_syms.setter
  def private_syms(self, value):
    if value is not None:
      self.operation.attributes["private_syms"] = value
    elif "private_syms" in self.operation.attributes:
      del self.operation.attributes["private_syms"]

  @private_syms.deleter
  def private_syms(self):
    del self.operation.attributes["private_syms"]

  @builtins.property
  def reduction_mod(self):
    if "reduction_mod" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_mod"]

  @reduction_mod.setter
  def reduction_mod(self, value):
    if value is not None:
      self.operation.attributes["reduction_mod"] = value
    elif "reduction_mod" in self.operation.attributes:
      del self.operation.attributes["reduction_mod"]

  @reduction_mod.deleter
  def reduction_mod(self):
    del self.operation.attributes["reduction_mod"]

  @builtins.property
  def reduction_byref(self):
    if "reduction_byref" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_byref"]

  @reduction_byref.setter
  def reduction_byref(self, value):
    if value is not None:
      self.operation.attributes["reduction_byref"] = value
    elif "reduction_byref" in self.operation.attributes:
      del self.operation.attributes["reduction_byref"]

  @reduction_byref.deleter
  def reduction_byref(self):
    del self.operation.attributes["reduction_byref"]

  @builtins.property
  def reduction_syms(self):
    if "reduction_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_syms"]

  @reduction_syms.setter
  def reduction_syms(self, value):
    if value is not None:
      self.operation.attributes["reduction_syms"] = value
    elif "reduction_syms" in self.operation.attributes:
      del self.operation.attributes["reduction_syms"]

  @reduction_syms.deleter
  def reduction_syms(self):
    del self.operation.attributes["reduction_syms"]

  @builtins.property
  def region(self):
    return self.regions[0]

def sections(allocate_vars, allocator_vars, private_vars, reduction_vars, *, nowait=None, private_syms=None, reduction_mod=None, reduction_byref=None, reduction_syms=None, loc=None, ip=None) -> _ods_ir.Operation:
  return SectionsOp(allocate_vars=allocate_vars, allocator_vars=allocator_vars, private_vars=private_vars, reduction_vars=reduction_vars, nowait=nowait, private_syms=private_syms, reduction_mod=reduction_mod, reduction_byref=reduction_byref, reduction_syms=reduction_syms, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SimdOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.simd"

  _ODS_OPERAND_SEGMENTS = [-1,0,-1,-1,-1,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, aligned_vars, linear_vars, linear_step_vars, nontemporal_vars, private_vars, reduction_vars, *, alignments=None, if_expr=None, order=None, order_mod=None, private_syms=None, reduction_mod=None, reduction_byref=None, reduction_syms=None, safelen=None, simdlen=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(aligned_vars))
    operands.append(if_expr)
    operands.append(_get_op_results_or_values(linear_vars))
    operands.append(_get_op_results_or_values(linear_step_vars))
    operands.append(_get_op_results_or_values(nontemporal_vars))
    operands.append(_get_op_results_or_values(private_vars))
    operands.append(_get_op_results_or_values(reduction_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if alignments is not None: attributes["alignments"] = (alignments if (
        isinstance(alignments, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('I64ArrayAttr')(alignments, context=_ods_context))
    if order is not None: attributes["order"] = (order if (
        isinstance(order, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('OrderKindAttr')) else
          _ods_ir.AttrBuilder.get('OrderKindAttr')(order, context=_ods_context))
    if order_mod is not None: attributes["order_mod"] = (order_mod if (
        isinstance(order_mod, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('OrderModifierAttr')) else
          _ods_ir.AttrBuilder.get('OrderModifierAttr')(order_mod, context=_ods_context))
    if private_syms is not None: attributes["private_syms"] = (private_syms if (
        isinstance(private_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(private_syms, context=_ods_context))
    if reduction_mod is not None: attributes["reduction_mod"] = (reduction_mod if (
        isinstance(reduction_mod, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ReductionModifierAttr')) else
          _ods_ir.AttrBuilder.get('ReductionModifierAttr')(reduction_mod, context=_ods_context))
    if reduction_byref is not None: attributes["reduction_byref"] = (reduction_byref if (
        isinstance(reduction_byref, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(reduction_byref, context=_ods_context))
    if reduction_syms is not None: attributes["reduction_syms"] = (reduction_syms if (
        isinstance(reduction_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(reduction_syms, context=_ods_context))
    if safelen is not None: attributes["safelen"] = (safelen if (
        isinstance(safelen, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(safelen, context=_ods_context))
    if simdlen is not None: attributes["simdlen"] = (simdlen if (
        isinstance(simdlen, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(simdlen, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def aligned_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def linear_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def linear_step_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def nontemporal_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range

  @builtins.property
  def private_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range

  @builtins.property
  def reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 6)
    return operand_range

  @builtins.property
  def alignments(self):
    if "alignments" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignments"]

  @alignments.setter
  def alignments(self, value):
    if value is not None:
      self.operation.attributes["alignments"] = value
    elif "alignments" in self.operation.attributes:
      del self.operation.attributes["alignments"]

  @alignments.deleter
  def alignments(self):
    del self.operation.attributes["alignments"]

  @builtins.property
  def order(self):
    if "order" not in self.operation.attributes:
      return None
    return self.operation.attributes["order"]

  @order.setter
  def order(self, value):
    if value is not None:
      self.operation.attributes["order"] = value
    elif "order" in self.operation.attributes:
      del self.operation.attributes["order"]

  @order.deleter
  def order(self):
    del self.operation.attributes["order"]

  @builtins.property
  def order_mod(self):
    if "order_mod" not in self.operation.attributes:
      return None
    return self.operation.attributes["order_mod"]

  @order_mod.setter
  def order_mod(self, value):
    if value is not None:
      self.operation.attributes["order_mod"] = value
    elif "order_mod" in self.operation.attributes:
      del self.operation.attributes["order_mod"]

  @order_mod.deleter
  def order_mod(self):
    del self.operation.attributes["order_mod"]

  @builtins.property
  def private_syms(self):
    if "private_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["private_syms"]

  @private_syms.setter
  def private_syms(self, value):
    if value is not None:
      self.operation.attributes["private_syms"] = value
    elif "private_syms" in self.operation.attributes:
      del self.operation.attributes["private_syms"]

  @private_syms.deleter
  def private_syms(self):
    del self.operation.attributes["private_syms"]

  @builtins.property
  def reduction_mod(self):
    if "reduction_mod" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_mod"]

  @reduction_mod.setter
  def reduction_mod(self, value):
    if value is not None:
      self.operation.attributes["reduction_mod"] = value
    elif "reduction_mod" in self.operation.attributes:
      del self.operation.attributes["reduction_mod"]

  @reduction_mod.deleter
  def reduction_mod(self):
    del self.operation.attributes["reduction_mod"]

  @builtins.property
  def reduction_byref(self):
    if "reduction_byref" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_byref"]

  @reduction_byref.setter
  def reduction_byref(self, value):
    if value is not None:
      self.operation.attributes["reduction_byref"] = value
    elif "reduction_byref" in self.operation.attributes:
      del self.operation.attributes["reduction_byref"]

  @reduction_byref.deleter
  def reduction_byref(self):
    del self.operation.attributes["reduction_byref"]

  @builtins.property
  def reduction_syms(self):
    if "reduction_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_syms"]

  @reduction_syms.setter
  def reduction_syms(self, value):
    if value is not None:
      self.operation.attributes["reduction_syms"] = value
    elif "reduction_syms" in self.operation.attributes:
      del self.operation.attributes["reduction_syms"]

  @reduction_syms.deleter
  def reduction_syms(self):
    del self.operation.attributes["reduction_syms"]

  @builtins.property
  def safelen(self):
    if "safelen" not in self.operation.attributes:
      return None
    return self.operation.attributes["safelen"]

  @safelen.setter
  def safelen(self, value):
    if value is not None:
      self.operation.attributes["safelen"] = value
    elif "safelen" in self.operation.attributes:
      del self.operation.attributes["safelen"]

  @safelen.deleter
  def safelen(self):
    del self.operation.attributes["safelen"]

  @builtins.property
  def simdlen(self):
    if "simdlen" not in self.operation.attributes:
      return None
    return self.operation.attributes["simdlen"]

  @simdlen.setter
  def simdlen(self, value):
    if value is not None:
      self.operation.attributes["simdlen"] = value
    elif "simdlen" in self.operation.attributes:
      del self.operation.attributes["simdlen"]

  @simdlen.deleter
  def simdlen(self):
    del self.operation.attributes["simdlen"]

  @builtins.property
  def region(self):
    return self.regions[0]

def simd(aligned_vars, linear_vars, linear_step_vars, nontemporal_vars, private_vars, reduction_vars, *, alignments=None, if_expr=None, order=None, order_mod=None, private_syms=None, reduction_mod=None, reduction_byref=None, reduction_syms=None, safelen=None, simdlen=None, loc=None, ip=None) -> _ods_ir.Operation:
  return SimdOp(aligned_vars=aligned_vars, linear_vars=linear_vars, linear_step_vars=linear_step_vars, nontemporal_vars=nontemporal_vars, private_vars=private_vars, reduction_vars=reduction_vars, alignments=alignments, if_expr=if_expr, order=order, order_mod=order_mod, private_syms=private_syms, reduction_mod=reduction_mod, reduction_byref=reduction_byref, reduction_syms=reduction_syms, safelen=safelen, simdlen=simdlen, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SingleOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.single"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, allocate_vars, allocator_vars, copyprivate_vars, private_vars, *, copyprivate_syms=None, nowait=None, private_syms=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocator_vars))
    operands.append(_get_op_results_or_values(copyprivate_vars))
    operands.append(_get_op_results_or_values(private_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if copyprivate_syms is not None: attributes["copyprivate_syms"] = (copyprivate_syms if (
        isinstance(copyprivate_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(copyprivate_syms, context=_ods_context))
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if private_syms is not None: attributes["private_syms"] = (private_syms if (
        isinstance(private_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(private_syms, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def allocator_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def copyprivate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def private_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def copyprivate_syms(self):
    if "copyprivate_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["copyprivate_syms"]

  @copyprivate_syms.setter
  def copyprivate_syms(self, value):
    if value is not None:
      self.operation.attributes["copyprivate_syms"] = value
    elif "copyprivate_syms" in self.operation.attributes:
      del self.operation.attributes["copyprivate_syms"]

  @copyprivate_syms.deleter
  def copyprivate_syms(self):
    del self.operation.attributes["copyprivate_syms"]

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

  @builtins.property
  def private_syms(self):
    if "private_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["private_syms"]

  @private_syms.setter
  def private_syms(self, value):
    if value is not None:
      self.operation.attributes["private_syms"] = value
    elif "private_syms" in self.operation.attributes:
      del self.operation.attributes["private_syms"]

  @private_syms.deleter
  def private_syms(self):
    del self.operation.attributes["private_syms"]

  @builtins.property
  def region(self):
    return self.regions[0]

def single(allocate_vars, allocator_vars, copyprivate_vars, private_vars, *, copyprivate_syms=None, nowait=None, private_syms=None, loc=None, ip=None) -> _ods_ir.Operation:
  return SingleOp(allocate_vars=allocate_vars, allocator_vars=allocator_vars, copyprivate_vars=copyprivate_vars, private_vars=private_vars, copyprivate_syms=copyprivate_syms, nowait=nowait, private_syms=private_syms, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TargetDataOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.target_data"

  _ODS_OPERAND_SEGMENTS = [0,0,-1,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, map_vars, use_device_addr_vars, use_device_ptr_vars, *, device=None, if_expr=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(device)
    operands.append(if_expr)
    operands.append(_get_op_results_or_values(map_vars))
    operands.append(_get_op_results_or_values(use_device_addr_vars))
    operands.append(_get_op_results_or_values(use_device_ptr_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def device(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def map_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def use_device_addr_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def use_device_ptr_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range

  @builtins.property
  def region(self):
    return self.regions[0]

def target_data(map_vars, use_device_addr_vars, use_device_ptr_vars, *, device=None, if_expr=None, loc=None, ip=None) -> _ods_ir.Operation:
  return TargetDataOp(map_vars=map_vars, use_device_addr_vars=use_device_addr_vars, use_device_ptr_vars=use_device_ptr_vars, device=device, if_expr=if_expr, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TargetEnterDataOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.target_enter_data"

  _ODS_OPERAND_SEGMENTS = [-1,0,0,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, depend_vars, map_vars, *, depend_kinds=None, device=None, if_expr=None, nowait=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(depend_vars))
    operands.append(device)
    operands.append(if_expr)
    operands.append(_get_op_results_or_values(map_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if depend_kinds is not None: attributes["depend_kinds"] = (depend_kinds if (
        isinstance(depend_kinds, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TaskDependArrayAttr')) else
          _ods_ir.AttrBuilder.get('TaskDependArrayAttr')(depend_kinds, context=_ods_context))
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def depend_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def device(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def map_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def depend_kinds(self):
    if "depend_kinds" not in self.operation.attributes:
      return None
    return self.operation.attributes["depend_kinds"]

  @depend_kinds.setter
  def depend_kinds(self, value):
    if value is not None:
      self.operation.attributes["depend_kinds"] = value
    elif "depend_kinds" in self.operation.attributes:
      del self.operation.attributes["depend_kinds"]

  @depend_kinds.deleter
  def depend_kinds(self):
    del self.operation.attributes["depend_kinds"]

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

def target_enter_data(depend_vars, map_vars, *, depend_kinds=None, device=None, if_expr=None, nowait=None, loc=None, ip=None) -> _ods_ir.Operation:
  return TargetEnterDataOp(depend_vars=depend_vars, map_vars=map_vars, depend_kinds=depend_kinds, device=device, if_expr=if_expr, nowait=nowait, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TargetExitDataOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.target_exit_data"

  _ODS_OPERAND_SEGMENTS = [-1,0,0,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, depend_vars, map_vars, *, depend_kinds=None, device=None, if_expr=None, nowait=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(depend_vars))
    operands.append(device)
    operands.append(if_expr)
    operands.append(_get_op_results_or_values(map_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if depend_kinds is not None: attributes["depend_kinds"] = (depend_kinds if (
        isinstance(depend_kinds, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TaskDependArrayAttr')) else
          _ods_ir.AttrBuilder.get('TaskDependArrayAttr')(depend_kinds, context=_ods_context))
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def depend_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def device(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def map_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def depend_kinds(self):
    if "depend_kinds" not in self.operation.attributes:
      return None
    return self.operation.attributes["depend_kinds"]

  @depend_kinds.setter
  def depend_kinds(self, value):
    if value is not None:
      self.operation.attributes["depend_kinds"] = value
    elif "depend_kinds" in self.operation.attributes:
      del self.operation.attributes["depend_kinds"]

  @depend_kinds.deleter
  def depend_kinds(self):
    del self.operation.attributes["depend_kinds"]

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

def target_exit_data(depend_vars, map_vars, *, depend_kinds=None, device=None, if_expr=None, nowait=None, loc=None, ip=None) -> _ods_ir.Operation:
  return TargetExitDataOp(depend_vars=depend_vars, map_vars=map_vars, depend_kinds=depend_kinds, device=device, if_expr=if_expr, nowait=nowait, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TargetOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.target"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,0,-1,-1,0,-1,-1,-1,-1,0,]

  _ODS_REGIONS = (1, True)

  def __init__(self, allocate_vars, allocator_vars, depend_vars, has_device_addr_vars, host_eval_vars, in_reduction_vars, is_device_ptr_vars, map_vars, private_vars, *, bare=None, depend_kinds=None, device=None, if_expr=None, in_reduction_byref=None, in_reduction_syms=None, nowait=None, private_syms=None, thread_limit=None, private_maps=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocator_vars))
    operands.append(_get_op_results_or_values(depend_vars))
    operands.append(device)
    operands.append(_get_op_results_or_values(has_device_addr_vars))
    operands.append(_get_op_results_or_values(host_eval_vars))
    operands.append(if_expr)
    operands.append(_get_op_results_or_values(in_reduction_vars))
    operands.append(_get_op_results_or_values(is_device_ptr_vars))
    operands.append(_get_op_results_or_values(map_vars))
    operands.append(_get_op_results_or_values(private_vars))
    operands.append(thread_limit)
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(bare): attributes["bare"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if depend_kinds is not None: attributes["depend_kinds"] = (depend_kinds if (
        isinstance(depend_kinds, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TaskDependArrayAttr')) else
          _ods_ir.AttrBuilder.get('TaskDependArrayAttr')(depend_kinds, context=_ods_context))
    if in_reduction_byref is not None: attributes["in_reduction_byref"] = (in_reduction_byref if (
        isinstance(in_reduction_byref, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(in_reduction_byref, context=_ods_context))
    if in_reduction_syms is not None: attributes["in_reduction_syms"] = (in_reduction_syms if (
        isinstance(in_reduction_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(in_reduction_syms, context=_ods_context))
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if private_syms is not None: attributes["private_syms"] = (private_syms if (
        isinstance(private_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(private_syms, context=_ods_context))
    if private_maps is not None: attributes["private_maps"] = (private_maps if (
        isinstance(private_maps, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(private_maps, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def allocator_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def depend_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def device(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def has_device_addr_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range

  @builtins.property
  def host_eval_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 6)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def in_reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 7)
    return operand_range

  @builtins.property
  def is_device_ptr_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 8)
    return operand_range

  @builtins.property
  def map_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 9)
    return operand_range

  @builtins.property
  def private_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 10)
    return operand_range

  @builtins.property
  def thread_limit(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 11)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def bare(self):
    return "bare" in self.operation.attributes

  @bare.setter
  def bare(self, value):
    if bool(value):
      self.operation.attributes["bare"] = _ods_ir.UnitAttr.get()
    elif "bare" in self.operation.attributes:
      del self.operation.attributes["bare"]

  @bare.deleter
  def bare(self):
    del self.operation.attributes["bare"]

  @builtins.property
  def depend_kinds(self):
    if "depend_kinds" not in self.operation.attributes:
      return None
    return self.operation.attributes["depend_kinds"]

  @depend_kinds.setter
  def depend_kinds(self, value):
    if value is not None:
      self.operation.attributes["depend_kinds"] = value
    elif "depend_kinds" in self.operation.attributes:
      del self.operation.attributes["depend_kinds"]

  @depend_kinds.deleter
  def depend_kinds(self):
    del self.operation.attributes["depend_kinds"]

  @builtins.property
  def in_reduction_byref(self):
    if "in_reduction_byref" not in self.operation.attributes:
      return None
    return self.operation.attributes["in_reduction_byref"]

  @in_reduction_byref.setter
  def in_reduction_byref(self, value):
    if value is not None:
      self.operation.attributes["in_reduction_byref"] = value
    elif "in_reduction_byref" in self.operation.attributes:
      del self.operation.attributes["in_reduction_byref"]

  @in_reduction_byref.deleter
  def in_reduction_byref(self):
    del self.operation.attributes["in_reduction_byref"]

  @builtins.property
  def in_reduction_syms(self):
    if "in_reduction_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["in_reduction_syms"]

  @in_reduction_syms.setter
  def in_reduction_syms(self, value):
    if value is not None:
      self.operation.attributes["in_reduction_syms"] = value
    elif "in_reduction_syms" in self.operation.attributes:
      del self.operation.attributes["in_reduction_syms"]

  @in_reduction_syms.deleter
  def in_reduction_syms(self):
    del self.operation.attributes["in_reduction_syms"]

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

  @builtins.property
  def private_syms(self):
    if "private_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["private_syms"]

  @private_syms.setter
  def private_syms(self, value):
    if value is not None:
      self.operation.attributes["private_syms"] = value
    elif "private_syms" in self.operation.attributes:
      del self.operation.attributes["private_syms"]

  @private_syms.deleter
  def private_syms(self):
    del self.operation.attributes["private_syms"]

  @builtins.property
  def private_maps(self):
    if "private_maps" not in self.operation.attributes:
      return None
    return self.operation.attributes["private_maps"]

  @private_maps.setter
  def private_maps(self, value):
    if value is not None:
      self.operation.attributes["private_maps"] = value
    elif "private_maps" in self.operation.attributes:
      del self.operation.attributes["private_maps"]

  @private_maps.deleter
  def private_maps(self):
    del self.operation.attributes["private_maps"]

  @builtins.property
  def region(self):
    return self.regions[0]

def target(allocate_vars, allocator_vars, depend_vars, has_device_addr_vars, host_eval_vars, in_reduction_vars, is_device_ptr_vars, map_vars, private_vars, *, bare=None, depend_kinds=None, device=None, if_expr=None, in_reduction_byref=None, in_reduction_syms=None, nowait=None, private_syms=None, thread_limit=None, private_maps=None, loc=None, ip=None) -> _ods_ir.Operation:
  return TargetOp(allocate_vars=allocate_vars, allocator_vars=allocator_vars, depend_vars=depend_vars, has_device_addr_vars=has_device_addr_vars, host_eval_vars=host_eval_vars, in_reduction_vars=in_reduction_vars, is_device_ptr_vars=is_device_ptr_vars, map_vars=map_vars, private_vars=private_vars, bare=bare, depend_kinds=depend_kinds, device=device, if_expr=if_expr, in_reduction_byref=in_reduction_byref, in_reduction_syms=in_reduction_syms, nowait=nowait, private_syms=private_syms, thread_limit=thread_limit, private_maps=private_maps, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TargetUpdateOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.target_update"

  _ODS_OPERAND_SEGMENTS = [-1,0,0,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, depend_vars, map_vars, *, depend_kinds=None, device=None, if_expr=None, nowait=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(depend_vars))
    operands.append(device)
    operands.append(if_expr)
    operands.append(_get_op_results_or_values(map_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if depend_kinds is not None: attributes["depend_kinds"] = (depend_kinds if (
        isinstance(depend_kinds, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TaskDependArrayAttr')) else
          _ods_ir.AttrBuilder.get('TaskDependArrayAttr')(depend_kinds, context=_ods_context))
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def depend_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def device(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def map_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def depend_kinds(self):
    if "depend_kinds" not in self.operation.attributes:
      return None
    return self.operation.attributes["depend_kinds"]

  @depend_kinds.setter
  def depend_kinds(self, value):
    if value is not None:
      self.operation.attributes["depend_kinds"] = value
    elif "depend_kinds" in self.operation.attributes:
      del self.operation.attributes["depend_kinds"]

  @depend_kinds.deleter
  def depend_kinds(self):
    del self.operation.attributes["depend_kinds"]

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

def target_update(depend_vars, map_vars, *, depend_kinds=None, device=None, if_expr=None, nowait=None, loc=None, ip=None) -> _ods_ir.Operation:
  return TargetUpdateOp(depend_vars=depend_vars, map_vars=map_vars, depend_kinds=depend_kinds, device=device, if_expr=if_expr, nowait=nowait, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TaskOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.task"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,0,0,-1,0,-1,0,]

  _ODS_REGIONS = (1, True)

  def __init__(self, allocate_vars, allocator_vars, depend_vars, in_reduction_vars, private_vars, *, depend_kinds=None, final=None, if_expr=None, in_reduction_byref=None, in_reduction_syms=None, mergeable=None, priority=None, private_syms=None, untied=None, event_handle=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocator_vars))
    operands.append(_get_op_results_or_values(depend_vars))
    operands.append(final)
    operands.append(if_expr)
    operands.append(_get_op_results_or_values(in_reduction_vars))
    operands.append(priority)
    operands.append(_get_op_results_or_values(private_vars))
    operands.append(event_handle)
    _ods_context = _ods_get_default_loc_context(loc)
    if depend_kinds is not None: attributes["depend_kinds"] = (depend_kinds if (
        isinstance(depend_kinds, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TaskDependArrayAttr')) else
          _ods_ir.AttrBuilder.get('TaskDependArrayAttr')(depend_kinds, context=_ods_context))
    if in_reduction_byref is not None: attributes["in_reduction_byref"] = (in_reduction_byref if (
        isinstance(in_reduction_byref, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(in_reduction_byref, context=_ods_context))
    if in_reduction_syms is not None: attributes["in_reduction_syms"] = (in_reduction_syms if (
        isinstance(in_reduction_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(in_reduction_syms, context=_ods_context))
    if bool(mergeable): attributes["mergeable"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if private_syms is not None: attributes["private_syms"] = (private_syms if (
        isinstance(private_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(private_syms, context=_ods_context))
    if bool(untied): attributes["untied"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def allocator_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def depend_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def final(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def in_reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range

  @builtins.property
  def priority(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 6)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def private_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 7)
    return operand_range

  @builtins.property
  def event_handle(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 8)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def depend_kinds(self):
    if "depend_kinds" not in self.operation.attributes:
      return None
    return self.operation.attributes["depend_kinds"]

  @depend_kinds.setter
  def depend_kinds(self, value):
    if value is not None:
      self.operation.attributes["depend_kinds"] = value
    elif "depend_kinds" in self.operation.attributes:
      del self.operation.attributes["depend_kinds"]

  @depend_kinds.deleter
  def depend_kinds(self):
    del self.operation.attributes["depend_kinds"]

  @builtins.property
  def in_reduction_byref(self):
    if "in_reduction_byref" not in self.operation.attributes:
      return None
    return self.operation.attributes["in_reduction_byref"]

  @in_reduction_byref.setter
  def in_reduction_byref(self, value):
    if value is not None:
      self.operation.attributes["in_reduction_byref"] = value
    elif "in_reduction_byref" in self.operation.attributes:
      del self.operation.attributes["in_reduction_byref"]

  @in_reduction_byref.deleter
  def in_reduction_byref(self):
    del self.operation.attributes["in_reduction_byref"]

  @builtins.property
  def in_reduction_syms(self):
    if "in_reduction_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["in_reduction_syms"]

  @in_reduction_syms.setter
  def in_reduction_syms(self, value):
    if value is not None:
      self.operation.attributes["in_reduction_syms"] = value
    elif "in_reduction_syms" in self.operation.attributes:
      del self.operation.attributes["in_reduction_syms"]

  @in_reduction_syms.deleter
  def in_reduction_syms(self):
    del self.operation.attributes["in_reduction_syms"]

  @builtins.property
  def mergeable(self):
    return "mergeable" in self.operation.attributes

  @mergeable.setter
  def mergeable(self, value):
    if bool(value):
      self.operation.attributes["mergeable"] = _ods_ir.UnitAttr.get()
    elif "mergeable" in self.operation.attributes:
      del self.operation.attributes["mergeable"]

  @mergeable.deleter
  def mergeable(self):
    del self.operation.attributes["mergeable"]

  @builtins.property
  def private_syms(self):
    if "private_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["private_syms"]

  @private_syms.setter
  def private_syms(self, value):
    if value is not None:
      self.operation.attributes["private_syms"] = value
    elif "private_syms" in self.operation.attributes:
      del self.operation.attributes["private_syms"]

  @private_syms.deleter
  def private_syms(self):
    del self.operation.attributes["private_syms"]

  @builtins.property
  def untied(self):
    return "untied" in self.operation.attributes

  @untied.setter
  def untied(self, value):
    if bool(value):
      self.operation.attributes["untied"] = _ods_ir.UnitAttr.get()
    elif "untied" in self.operation.attributes:
      del self.operation.attributes["untied"]

  @untied.deleter
  def untied(self):
    del self.operation.attributes["untied"]

  @builtins.property
  def region(self):
    return self.regions[0]

def task(allocate_vars, allocator_vars, depend_vars, in_reduction_vars, private_vars, *, depend_kinds=None, final=None, if_expr=None, in_reduction_byref=None, in_reduction_syms=None, mergeable=None, priority=None, private_syms=None, untied=None, event_handle=None, loc=None, ip=None) -> _ods_ir.Operation:
  return TaskOp(allocate_vars=allocate_vars, allocator_vars=allocator_vars, depend_vars=depend_vars, in_reduction_vars=in_reduction_vars, private_vars=private_vars, depend_kinds=depend_kinds, final=final, if_expr=if_expr, in_reduction_byref=in_reduction_byref, in_reduction_syms=in_reduction_syms, mergeable=mergeable, priority=priority, private_syms=private_syms, untied=untied, event_handle=event_handle, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TaskgroupOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.taskgroup"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, allocate_vars, allocator_vars, task_reduction_vars, *, task_reduction_byref=None, task_reduction_syms=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocator_vars))
    operands.append(_get_op_results_or_values(task_reduction_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if task_reduction_byref is not None: attributes["task_reduction_byref"] = (task_reduction_byref if (
        isinstance(task_reduction_byref, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(task_reduction_byref, context=_ods_context))
    if task_reduction_syms is not None: attributes["task_reduction_syms"] = (task_reduction_syms if (
        isinstance(task_reduction_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(task_reduction_syms, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def allocator_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def task_reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def task_reduction_byref(self):
    if "task_reduction_byref" not in self.operation.attributes:
      return None
    return self.operation.attributes["task_reduction_byref"]

  @task_reduction_byref.setter
  def task_reduction_byref(self, value):
    if value is not None:
      self.operation.attributes["task_reduction_byref"] = value
    elif "task_reduction_byref" in self.operation.attributes:
      del self.operation.attributes["task_reduction_byref"]

  @task_reduction_byref.deleter
  def task_reduction_byref(self):
    del self.operation.attributes["task_reduction_byref"]

  @builtins.property
  def task_reduction_syms(self):
    if "task_reduction_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["task_reduction_syms"]

  @task_reduction_syms.setter
  def task_reduction_syms(self, value):
    if value is not None:
      self.operation.attributes["task_reduction_syms"] = value
    elif "task_reduction_syms" in self.operation.attributes:
      del self.operation.attributes["task_reduction_syms"]

  @task_reduction_syms.deleter
  def task_reduction_syms(self):
    del self.operation.attributes["task_reduction_syms"]

  @builtins.property
  def region(self):
    return self.regions[0]

def taskgroup(allocate_vars, allocator_vars, task_reduction_vars, *, task_reduction_byref=None, task_reduction_syms=None, loc=None, ip=None) -> _ods_ir.Operation:
  return TaskgroupOp(allocate_vars=allocate_vars, allocator_vars=allocator_vars, task_reduction_vars=task_reduction_vars, task_reduction_byref=task_reduction_byref, task_reduction_syms=task_reduction_syms, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TaskloopOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.taskloop"

  _ODS_OPERAND_SEGMENTS = [-1,-1,0,0,0,-1,0,0,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, allocate_vars, allocator_vars, in_reduction_vars, private_vars, reduction_vars, *, final=None, grainsize=None, if_expr=None, in_reduction_byref=None, in_reduction_syms=None, mergeable=None, nogroup=None, num_tasks=None, priority=None, private_syms=None, reduction_mod=None, reduction_byref=None, reduction_syms=None, untied=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocator_vars))
    operands.append(final)
    operands.append(grainsize)
    operands.append(if_expr)
    operands.append(_get_op_results_or_values(in_reduction_vars))
    operands.append(num_tasks)
    operands.append(priority)
    operands.append(_get_op_results_or_values(private_vars))
    operands.append(_get_op_results_or_values(reduction_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if in_reduction_byref is not None: attributes["in_reduction_byref"] = (in_reduction_byref if (
        isinstance(in_reduction_byref, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(in_reduction_byref, context=_ods_context))
    if in_reduction_syms is not None: attributes["in_reduction_syms"] = (in_reduction_syms if (
        isinstance(in_reduction_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(in_reduction_syms, context=_ods_context))
    if bool(mergeable): attributes["mergeable"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(nogroup): attributes["nogroup"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if private_syms is not None: attributes["private_syms"] = (private_syms if (
        isinstance(private_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(private_syms, context=_ods_context))
    if reduction_mod is not None: attributes["reduction_mod"] = (reduction_mod if (
        isinstance(reduction_mod, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ReductionModifierAttr')) else
          _ods_ir.AttrBuilder.get('ReductionModifierAttr')(reduction_mod, context=_ods_context))
    if reduction_byref is not None: attributes["reduction_byref"] = (reduction_byref if (
        isinstance(reduction_byref, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(reduction_byref, context=_ods_context))
    if reduction_syms is not None: attributes["reduction_syms"] = (reduction_syms if (
        isinstance(reduction_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(reduction_syms, context=_ods_context))
    if bool(untied): attributes["untied"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def allocator_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def final(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def grainsize(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def in_reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range

  @builtins.property
  def num_tasks(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 6)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def priority(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 7)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def private_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 8)
    return operand_range

  @builtins.property
  def reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 9)
    return operand_range

  @builtins.property
  def in_reduction_byref(self):
    if "in_reduction_byref" not in self.operation.attributes:
      return None
    return self.operation.attributes["in_reduction_byref"]

  @in_reduction_byref.setter
  def in_reduction_byref(self, value):
    if value is not None:
      self.operation.attributes["in_reduction_byref"] = value
    elif "in_reduction_byref" in self.operation.attributes:
      del self.operation.attributes["in_reduction_byref"]

  @in_reduction_byref.deleter
  def in_reduction_byref(self):
    del self.operation.attributes["in_reduction_byref"]

  @builtins.property
  def in_reduction_syms(self):
    if "in_reduction_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["in_reduction_syms"]

  @in_reduction_syms.setter
  def in_reduction_syms(self, value):
    if value is not None:
      self.operation.attributes["in_reduction_syms"] = value
    elif "in_reduction_syms" in self.operation.attributes:
      del self.operation.attributes["in_reduction_syms"]

  @in_reduction_syms.deleter
  def in_reduction_syms(self):
    del self.operation.attributes["in_reduction_syms"]

  @builtins.property
  def mergeable(self):
    return "mergeable" in self.operation.attributes

  @mergeable.setter
  def mergeable(self, value):
    if bool(value):
      self.operation.attributes["mergeable"] = _ods_ir.UnitAttr.get()
    elif "mergeable" in self.operation.attributes:
      del self.operation.attributes["mergeable"]

  @mergeable.deleter
  def mergeable(self):
    del self.operation.attributes["mergeable"]

  @builtins.property
  def nogroup(self):
    return "nogroup" in self.operation.attributes

  @nogroup.setter
  def nogroup(self, value):
    if bool(value):
      self.operation.attributes["nogroup"] = _ods_ir.UnitAttr.get()
    elif "nogroup" in self.operation.attributes:
      del self.operation.attributes["nogroup"]

  @nogroup.deleter
  def nogroup(self):
    del self.operation.attributes["nogroup"]

  @builtins.property
  def private_syms(self):
    if "private_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["private_syms"]

  @private_syms.setter
  def private_syms(self, value):
    if value is not None:
      self.operation.attributes["private_syms"] = value
    elif "private_syms" in self.operation.attributes:
      del self.operation.attributes["private_syms"]

  @private_syms.deleter
  def private_syms(self):
    del self.operation.attributes["private_syms"]

  @builtins.property
  def reduction_mod(self):
    if "reduction_mod" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_mod"]

  @reduction_mod.setter
  def reduction_mod(self, value):
    if value is not None:
      self.operation.attributes["reduction_mod"] = value
    elif "reduction_mod" in self.operation.attributes:
      del self.operation.attributes["reduction_mod"]

  @reduction_mod.deleter
  def reduction_mod(self):
    del self.operation.attributes["reduction_mod"]

  @builtins.property
  def reduction_byref(self):
    if "reduction_byref" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_byref"]

  @reduction_byref.setter
  def reduction_byref(self, value):
    if value is not None:
      self.operation.attributes["reduction_byref"] = value
    elif "reduction_byref" in self.operation.attributes:
      del self.operation.attributes["reduction_byref"]

  @reduction_byref.deleter
  def reduction_byref(self):
    del self.operation.attributes["reduction_byref"]

  @builtins.property
  def reduction_syms(self):
    if "reduction_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_syms"]

  @reduction_syms.setter
  def reduction_syms(self, value):
    if value is not None:
      self.operation.attributes["reduction_syms"] = value
    elif "reduction_syms" in self.operation.attributes:
      del self.operation.attributes["reduction_syms"]

  @reduction_syms.deleter
  def reduction_syms(self):
    del self.operation.attributes["reduction_syms"]

  @builtins.property
  def untied(self):
    return "untied" in self.operation.attributes

  @untied.setter
  def untied(self, value):
    if bool(value):
      self.operation.attributes["untied"] = _ods_ir.UnitAttr.get()
    elif "untied" in self.operation.attributes:
      del self.operation.attributes["untied"]

  @untied.deleter
  def untied(self):
    del self.operation.attributes["untied"]

  @builtins.property
  def region(self):
    return self.regions[0]

def taskloop(allocate_vars, allocator_vars, in_reduction_vars, private_vars, reduction_vars, *, final=None, grainsize=None, if_expr=None, in_reduction_byref=None, in_reduction_syms=None, mergeable=None, nogroup=None, num_tasks=None, priority=None, private_syms=None, reduction_mod=None, reduction_byref=None, reduction_syms=None, untied=None, loc=None, ip=None) -> _ods_ir.Operation:
  return TaskloopOp(allocate_vars=allocate_vars, allocator_vars=allocator_vars, in_reduction_vars=in_reduction_vars, private_vars=private_vars, reduction_vars=reduction_vars, final=final, grainsize=grainsize, if_expr=if_expr, in_reduction_byref=in_reduction_byref, in_reduction_syms=in_reduction_syms, mergeable=mergeable, nogroup=nogroup, num_tasks=num_tasks, priority=priority, private_syms=private_syms, reduction_mod=reduction_mod, reduction_byref=reduction_byref, reduction_syms=reduction_syms, untied=untied, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TaskwaitOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.taskwait"

  _ODS_REGIONS = (0, True)

  def __init__(self, depend_vars, *, depend_kinds=None, nowait=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(depend_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if depend_kinds is not None: attributes["depend_kinds"] = (depend_kinds if (
        isinstance(depend_kinds, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TaskDependArrayAttr')) else
          _ods_ir.AttrBuilder.get('TaskDependArrayAttr')(depend_kinds, context=_ods_context))
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def depend_vars(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def depend_kinds(self):
    if "depend_kinds" not in self.operation.attributes:
      return None
    return self.operation.attributes["depend_kinds"]

  @depend_kinds.setter
  def depend_kinds(self, value):
    if value is not None:
      self.operation.attributes["depend_kinds"] = value
    elif "depend_kinds" in self.operation.attributes:
      del self.operation.attributes["depend_kinds"]

  @depend_kinds.deleter
  def depend_kinds(self):
    del self.operation.attributes["depend_kinds"]

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

def taskwait(depend_vars, *, depend_kinds=None, nowait=None, loc=None, ip=None) -> _ods_ir.Operation:
  return TaskwaitOp(depend_vars=depend_vars, depend_kinds=depend_kinds, nowait=nowait, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TaskyieldOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.taskyield"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

def taskyield(*, loc=None, ip=None) -> _ods_ir.Operation:
  return TaskyieldOp(loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TeamsOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.teams"

  _ODS_OPERAND_SEGMENTS = [-1,-1,0,0,0,-1,-1,0,]

  _ODS_REGIONS = (1, True)

  def __init__(self, allocate_vars, allocator_vars, private_vars, reduction_vars, *, if_expr=None, num_teams_lower=None, num_teams_upper=None, private_syms=None, reduction_mod=None, reduction_byref=None, reduction_syms=None, thread_limit=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocator_vars))
    operands.append(if_expr)
    operands.append(num_teams_lower)
    operands.append(num_teams_upper)
    operands.append(_get_op_results_or_values(private_vars))
    operands.append(_get_op_results_or_values(reduction_vars))
    operands.append(thread_limit)
    _ods_context = _ods_get_default_loc_context(loc)
    if private_syms is not None: attributes["private_syms"] = (private_syms if (
        isinstance(private_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(private_syms, context=_ods_context))
    if reduction_mod is not None: attributes["reduction_mod"] = (reduction_mod if (
        isinstance(reduction_mod, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ReductionModifierAttr')) else
          _ods_ir.AttrBuilder.get('ReductionModifierAttr')(reduction_mod, context=_ods_context))
    if reduction_byref is not None: attributes["reduction_byref"] = (reduction_byref if (
        isinstance(reduction_byref, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(reduction_byref, context=_ods_context))
    if reduction_syms is not None: attributes["reduction_syms"] = (reduction_syms if (
        isinstance(reduction_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(reduction_syms, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def allocator_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def num_teams_lower(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def num_teams_upper(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def private_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range

  @builtins.property
  def reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 6)
    return operand_range

  @builtins.property
  def thread_limit(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 7)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def private_syms(self):
    if "private_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["private_syms"]

  @private_syms.setter
  def private_syms(self, value):
    if value is not None:
      self.operation.attributes["private_syms"] = value
    elif "private_syms" in self.operation.attributes:
      del self.operation.attributes["private_syms"]

  @private_syms.deleter
  def private_syms(self):
    del self.operation.attributes["private_syms"]

  @builtins.property
  def reduction_mod(self):
    if "reduction_mod" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_mod"]

  @reduction_mod.setter
  def reduction_mod(self, value):
    if value is not None:
      self.operation.attributes["reduction_mod"] = value
    elif "reduction_mod" in self.operation.attributes:
      del self.operation.attributes["reduction_mod"]

  @reduction_mod.deleter
  def reduction_mod(self):
    del self.operation.attributes["reduction_mod"]

  @builtins.property
  def reduction_byref(self):
    if "reduction_byref" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_byref"]

  @reduction_byref.setter
  def reduction_byref(self, value):
    if value is not None:
      self.operation.attributes["reduction_byref"] = value
    elif "reduction_byref" in self.operation.attributes:
      del self.operation.attributes["reduction_byref"]

  @reduction_byref.deleter
  def reduction_byref(self):
    del self.operation.attributes["reduction_byref"]

  @builtins.property
  def reduction_syms(self):
    if "reduction_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_syms"]

  @reduction_syms.setter
  def reduction_syms(self, value):
    if value is not None:
      self.operation.attributes["reduction_syms"] = value
    elif "reduction_syms" in self.operation.attributes:
      del self.operation.attributes["reduction_syms"]

  @reduction_syms.deleter
  def reduction_syms(self):
    del self.operation.attributes["reduction_syms"]

  @builtins.property
  def region(self):
    return self.regions[0]

def teams(allocate_vars, allocator_vars, private_vars, reduction_vars, *, if_expr=None, num_teams_lower=None, num_teams_upper=None, private_syms=None, reduction_mod=None, reduction_byref=None, reduction_syms=None, thread_limit=None, loc=None, ip=None) -> _ods_ir.Operation:
  return TeamsOp(allocate_vars=allocate_vars, allocator_vars=allocator_vars, private_vars=private_vars, reduction_vars=reduction_vars, if_expr=if_expr, num_teams_lower=num_teams_lower, num_teams_upper=num_teams_upper, private_syms=private_syms, reduction_mod=reduction_mod, reduction_byref=reduction_byref, reduction_syms=reduction_syms, thread_limit=thread_limit, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TerminatorOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.terminator"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

def terminator(*, loc=None, ip=None) -> _ods_ir.Operation:
  return TerminatorOp(loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ThreadprivateOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.threadprivate"

  _ODS_REGIONS = (0, True)

  def __init__(self, tls_addr, sym_addr, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(sym_addr)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(tls_addr)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_addr(self):
    return self.operation.operands[0]

  @builtins.property
  def tls_addr(self):
    return self.operation.results[0]

def threadprivate(tls_addr, sym_addr, *, loc=None, ip=None) -> _ods_ir.Value:
  return ThreadprivateOp(tls_addr=tls_addr, sym_addr=sym_addr, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class WorkshareLoopWrapperOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.workshare.loop_wrapper"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def region(self):
    return self.regions[0]

def workshare_loop_wrapper(*, loc=None, ip=None) -> _ods_ir.Operation:
  return WorkshareLoopWrapperOp(loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class WorkshareOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.workshare"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, nowait=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

  @builtins.property
  def region(self):
    return self.regions[0]

def workshare(*, nowait=None, loc=None, ip=None) -> _ods_ir.Operation:
  return WorkshareOp(nowait=nowait, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class WsloopOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.wsloop"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,-1,-1,-1,0,]

  _ODS_REGIONS = (1, True)

  def __init__(self, allocate_vars, allocator_vars, linear_vars, linear_step_vars, private_vars, reduction_vars, *, nowait=None, order=None, order_mod=None, ordered=None, private_syms=None, reduction_mod=None, reduction_byref=None, reduction_syms=None, schedule_kind=None, schedule_chunk=None, schedule_mod=None, schedule_simd=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocator_vars))
    operands.append(_get_op_results_or_values(linear_vars))
    operands.append(_get_op_results_or_values(linear_step_vars))
    operands.append(_get_op_results_or_values(private_vars))
    operands.append(_get_op_results_or_values(reduction_vars))
    operands.append(schedule_chunk)
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if order is not None: attributes["order"] = (order if (
        isinstance(order, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('OrderKindAttr')) else
          _ods_ir.AttrBuilder.get('OrderKindAttr')(order, context=_ods_context))
    if order_mod is not None: attributes["order_mod"] = (order_mod if (
        isinstance(order_mod, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('OrderModifierAttr')) else
          _ods_ir.AttrBuilder.get('OrderModifierAttr')(order_mod, context=_ods_context))
    if ordered is not None: attributes["ordered"] = (ordered if (
        isinstance(ordered, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(ordered, context=_ods_context))
    if private_syms is not None: attributes["private_syms"] = (private_syms if (
        isinstance(private_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(private_syms, context=_ods_context))
    if reduction_mod is not None: attributes["reduction_mod"] = (reduction_mod if (
        isinstance(reduction_mod, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ReductionModifierAttr')) else
          _ods_ir.AttrBuilder.get('ReductionModifierAttr')(reduction_mod, context=_ods_context))
    if reduction_byref is not None: attributes["reduction_byref"] = (reduction_byref if (
        isinstance(reduction_byref, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(reduction_byref, context=_ods_context))
    if reduction_syms is not None: attributes["reduction_syms"] = (reduction_syms if (
        isinstance(reduction_syms, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(reduction_syms, context=_ods_context))
    if schedule_kind is not None: attributes["schedule_kind"] = (schedule_kind if (
        isinstance(schedule_kind, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ScheduleKindAttr')) else
          _ods_ir.AttrBuilder.get('ScheduleKindAttr')(schedule_kind, context=_ods_context))
    if schedule_mod is not None: attributes["schedule_mod"] = (schedule_mod if (
        isinstance(schedule_mod, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ScheduleModifierAttr')) else
          _ods_ir.AttrBuilder.get('ScheduleModifierAttr')(schedule_mod, context=_ods_context))
    if bool(schedule_simd): attributes["schedule_simd"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def allocator_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def linear_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def linear_step_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def private_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range

  @builtins.property
  def reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range

  @builtins.property
  def schedule_chunk(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 6)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

  @builtins.property
  def order(self):
    if "order" not in self.operation.attributes:
      return None
    return self.operation.attributes["order"]

  @order.setter
  def order(self, value):
    if value is not None:
      self.operation.attributes["order"] = value
    elif "order" in self.operation.attributes:
      del self.operation.attributes["order"]

  @order.deleter
  def order(self):
    del self.operation.attributes["order"]

  @builtins.property
  def order_mod(self):
    if "order_mod" not in self.operation.attributes:
      return None
    return self.operation.attributes["order_mod"]

  @order_mod.setter
  def order_mod(self, value):
    if value is not None:
      self.operation.attributes["order_mod"] = value
    elif "order_mod" in self.operation.attributes:
      del self.operation.attributes["order_mod"]

  @order_mod.deleter
  def order_mod(self):
    del self.operation.attributes["order_mod"]

  @builtins.property
  def ordered(self):
    if "ordered" not in self.operation.attributes:
      return None
    return self.operation.attributes["ordered"]

  @ordered.setter
  def ordered(self, value):
    if value is not None:
      self.operation.attributes["ordered"] = value
    elif "ordered" in self.operation.attributes:
      del self.operation.attributes["ordered"]

  @ordered.deleter
  def ordered(self):
    del self.operation.attributes["ordered"]

  @builtins.property
  def private_syms(self):
    if "private_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["private_syms"]

  @private_syms.setter
  def private_syms(self, value):
    if value is not None:
      self.operation.attributes["private_syms"] = value
    elif "private_syms" in self.operation.attributes:
      del self.operation.attributes["private_syms"]

  @private_syms.deleter
  def private_syms(self):
    del self.operation.attributes["private_syms"]

  @builtins.property
  def reduction_mod(self):
    if "reduction_mod" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_mod"]

  @reduction_mod.setter
  def reduction_mod(self, value):
    if value is not None:
      self.operation.attributes["reduction_mod"] = value
    elif "reduction_mod" in self.operation.attributes:
      del self.operation.attributes["reduction_mod"]

  @reduction_mod.deleter
  def reduction_mod(self):
    del self.operation.attributes["reduction_mod"]

  @builtins.property
  def reduction_byref(self):
    if "reduction_byref" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_byref"]

  @reduction_byref.setter
  def reduction_byref(self, value):
    if value is not None:
      self.operation.attributes["reduction_byref"] = value
    elif "reduction_byref" in self.operation.attributes:
      del self.operation.attributes["reduction_byref"]

  @reduction_byref.deleter
  def reduction_byref(self):
    del self.operation.attributes["reduction_byref"]

  @builtins.property
  def reduction_syms(self):
    if "reduction_syms" not in self.operation.attributes:
      return None
    return self.operation.attributes["reduction_syms"]

  @reduction_syms.setter
  def reduction_syms(self, value):
    if value is not None:
      self.operation.attributes["reduction_syms"] = value
    elif "reduction_syms" in self.operation.attributes:
      del self.operation.attributes["reduction_syms"]

  @reduction_syms.deleter
  def reduction_syms(self):
    del self.operation.attributes["reduction_syms"]

  @builtins.property
  def schedule_kind(self):
    if "schedule_kind" not in self.operation.attributes:
      return None
    return self.operation.attributes["schedule_kind"]

  @schedule_kind.setter
  def schedule_kind(self, value):
    if value is not None:
      self.operation.attributes["schedule_kind"] = value
    elif "schedule_kind" in self.operation.attributes:
      del self.operation.attributes["schedule_kind"]

  @schedule_kind.deleter
  def schedule_kind(self):
    del self.operation.attributes["schedule_kind"]

  @builtins.property
  def schedule_mod(self):
    if "schedule_mod" not in self.operation.attributes:
      return None
    return self.operation.attributes["schedule_mod"]

  @schedule_mod.setter
  def schedule_mod(self, value):
    if value is not None:
      self.operation.attributes["schedule_mod"] = value
    elif "schedule_mod" in self.operation.attributes:
      del self.operation.attributes["schedule_mod"]

  @schedule_mod.deleter
  def schedule_mod(self):
    del self.operation.attributes["schedule_mod"]

  @builtins.property
  def schedule_simd(self):
    return "schedule_simd" in self.operation.attributes

  @schedule_simd.setter
  def schedule_simd(self, value):
    if bool(value):
      self.operation.attributes["schedule_simd"] = _ods_ir.UnitAttr.get()
    elif "schedule_simd" in self.operation.attributes:
      del self.operation.attributes["schedule_simd"]

  @schedule_simd.deleter
  def schedule_simd(self):
    del self.operation.attributes["schedule_simd"]

  @builtins.property
  def region(self):
    return self.regions[0]

def wsloop(allocate_vars, allocator_vars, linear_vars, linear_step_vars, private_vars, reduction_vars, *, nowait=None, order=None, order_mod=None, ordered=None, private_syms=None, reduction_mod=None, reduction_byref=None, reduction_syms=None, schedule_kind=None, schedule_chunk=None, schedule_mod=None, schedule_simd=None, loc=None, ip=None) -> _ods_ir.Operation:
  return WsloopOp(allocate_vars=allocate_vars, allocator_vars=allocator_vars, linear_vars=linear_vars, linear_step_vars=linear_step_vars, private_vars=private_vars, reduction_vars=reduction_vars, nowait=nowait, order=order, order_mod=order_mod, ordered=ordered, private_syms=private_syms, reduction_mod=reduction_mod, reduction_byref=reduction_byref, reduction_syms=reduction_syms, schedule_kind=schedule_kind, schedule_chunk=schedule_chunk, schedule_mod=schedule_mod, schedule_simd=schedule_simd, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(results_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def yield_(results_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return YieldOp(results_=results_, loc=loc, ip=ip)
