
# Autogenerated by mlir-tblgen; don't manually edit.

from enum import IntEnum, auto, IntFlag
from ._ods_common import _cext as _ods_cext
from ..ir import register_attribute_builder
_ods_ir = _ods_cext.ir

class FPRoundingMode(IntEnum):
    """NVVM FPRoundingMode kind"""

    NONE = 0
    RN = 1
    RM = 2
    RP = 3
    RZ = 4
    RNA = 5

    def __str__(self):
        if self is FPRoundingMode.NONE:
            return "none"
        if self is FPRoundingMode.RN:
            return "rn"
        if self is FPRoundingMode.RM:
            return "rm"
        if self is FPRoundingMode.RP:
            return "rp"
        if self is FPRoundingMode.RZ:
            return "rz"
        if self is FPRoundingMode.RNA:
            return "rna"
        raise ValueError("Unknown FPRoundingMode enum entry.")



@register_attribute_builder("FPRoundingMode")
def _fproundingmode(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class LoadCacheModifierKind(IntEnum):
    """NVVM load cache modifier kind"""

    CA = 0
    CG = 1
    CS = 2
    LU = 3
    CV = 4

    def __str__(self):
        if self is LoadCacheModifierKind.CA:
            return "ca"
        if self is LoadCacheModifierKind.CG:
            return "cg"
        if self is LoadCacheModifierKind.CS:
            return "cs"
        if self is LoadCacheModifierKind.LU:
            return "lu"
        if self is LoadCacheModifierKind.CV:
            return "cv"
        raise ValueError("Unknown LoadCacheModifierKind enum entry.")



@register_attribute_builder("LoadCacheModifierKind")
def _loadcachemodifierkind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class MMAB1Op(IntEnum):
    """MMA binary operations"""

    none = 0
    xor_popc = 1
    and_popc = 2

    def __str__(self):
        if self is MMAB1Op.none:
            return "none"
        if self is MMAB1Op.xor_popc:
            return "xor_popc"
        if self is MMAB1Op.and_popc:
            return "and_popc"
        raise ValueError("Unknown MMAB1Op enum entry.")



@register_attribute_builder("MMAB1Op")
def _mmab1op(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class MMAFrag(IntEnum):
    """NVVM MMA frag type"""

    a = 0
    b = 1
    c = 2

    def __str__(self):
        if self is MMAFrag.a:
            return "a"
        if self is MMAFrag.b:
            return "b"
        if self is MMAFrag.c:
            return "c"
        raise ValueError("Unknown MMAFrag enum entry.")



@register_attribute_builder("MMAFrag")
def _mmafrag(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class MMAIntOverflow(IntEnum):
    """MMA overflow options"""

    satfinite = 1
    wrapped = 0

    def __str__(self):
        if self is MMAIntOverflow.satfinite:
            return "satfinite"
        if self is MMAIntOverflow.wrapped:
            return "wrapped"
        raise ValueError("Unknown MMAIntOverflow enum entry.")



@register_attribute_builder("MMAIntOverflow")
def _mmaintoverflow(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class MMALayout(IntEnum):
    """NVVM MMA layout"""

    row = 0
    col = 1

    def __str__(self):
        if self is MMALayout.row:
            return "row"
        if self is MMALayout.col:
            return "col"
        raise ValueError("Unknown MMALayout enum entry.")



@register_attribute_builder("MMALayout")
def _mmalayout(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class MMATypes(IntEnum):
    """NVVM MMA types"""

    f16 = 0
    f32 = 1
    tf32 = 2
    bf16 = 9
    s8 = 4
    u8 = 3
    s32 = 5
    s4 = 8
    u4 = 7
    b1 = 6
    f64 = 10

    def __str__(self):
        if self is MMATypes.f16:
            return "f16"
        if self is MMATypes.f32:
            return "f32"
        if self is MMATypes.tf32:
            return "tf32"
        if self is MMATypes.bf16:
            return "bf16"
        if self is MMATypes.s8:
            return "s8"
        if self is MMATypes.u8:
            return "u8"
        if self is MMATypes.s32:
            return "s32"
        if self is MMATypes.s4:
            return "s4"
        if self is MMATypes.u4:
            return "u4"
        if self is MMATypes.b1:
            return "b1"
        if self is MMATypes.f64:
            return "f64"
        raise ValueError("Unknown MMATypes enum entry.")



@register_attribute_builder("MMATypes")
def _mmatypes(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class MemScopeKind(IntEnum):
    """NVVM Memory Scope kind"""

    CTA = 0
    CLUSTER = 1
    GPU = 2
    SYS = 3

    def __str__(self):
        if self is MemScopeKind.CTA:
            return "cta"
        if self is MemScopeKind.CLUSTER:
            return "cluster"
        if self is MemScopeKind.GPU:
            return "gpu"
        if self is MemScopeKind.SYS:
            return "sys"
        raise ValueError("Unknown MemScopeKind enum entry.")



@register_attribute_builder("MemScopeKind")
def _memscopekind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class ProxyKind(IntEnum):
    """Proxy kind"""

    alias = 0
    async_ = 1
    async_global = 2
    async_shared = 3
    TENSORMAP = 4
    GENERIC = 5

    def __str__(self):
        if self is ProxyKind.alias:
            return "alias"
        if self is ProxyKind.async_:
            return "async"
        if self is ProxyKind.async_global:
            return "async.global"
        if self is ProxyKind.async_shared:
            return "async.shared"
        if self is ProxyKind.TENSORMAP:
            return "tensormap"
        if self is ProxyKind.GENERIC:
            return "generic"
        raise ValueError("Unknown ProxyKind enum entry.")



@register_attribute_builder("ProxyKind")
def _proxykind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class ReduxKind(IntEnum):
    """NVVM redux kind"""

    ADD = 1
    AND = 2
    MAX = 3
    MIN = 4
    OR = 5
    UMAX = 6
    UMIN = 7
    XOR = 8

    def __str__(self):
        if self is ReduxKind.ADD:
            return "add"
        if self is ReduxKind.AND:
            return "and"
        if self is ReduxKind.MAX:
            return "max"
        if self is ReduxKind.MIN:
            return "min"
        if self is ReduxKind.OR:
            return "or"
        if self is ReduxKind.UMAX:
            return "umax"
        if self is ReduxKind.UMIN:
            return "umin"
        if self is ReduxKind.XOR:
            return "xor"
        raise ValueError("Unknown ReduxKind enum entry.")



@register_attribute_builder("ReduxKind")
def _reduxkind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class SaturationMode(IntEnum):
    """NVVM SaturationMode kind"""

    NONE = 0
    SATFINITE = 1

    def __str__(self):
        if self is SaturationMode.NONE:
            return "none"
        if self is SaturationMode.SATFINITE:
            return "satfinite"
        raise ValueError("Unknown SaturationMode enum entry.")



@register_attribute_builder("SaturationMode")
def _saturationmode(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class SetMaxRegisterAction(IntEnum):
    """NVVM set max register action"""

    decrease = 1
    increase = 0

    def __str__(self):
        if self is SetMaxRegisterAction.decrease:
            return "decrease"
        if self is SetMaxRegisterAction.increase:
            return "increase"
        raise ValueError("Unknown SetMaxRegisterAction enum entry.")



@register_attribute_builder("SetMaxRegisterAction")
def _setmaxregisteraction(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class SharedSpace(IntEnum):
    """Shared memory space"""

    shared_cta = 0
    shared_cluster = 1

    def __str__(self):
        if self is SharedSpace.shared_cta:
            return "cta"
        if self is SharedSpace.shared_cluster:
            return "cluster"
        raise ValueError("Unknown SharedSpace enum entry.")



@register_attribute_builder("SharedSpace")
def _sharedspace(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class ShflKind(IntEnum):
    """NVVM shuffle kind"""

    bfly = 0
    up = 1
    down = 2
    idx = 3

    def __str__(self):
        if self is ShflKind.bfly:
            return "bfly"
        if self is ShflKind.up:
            return "up"
        if self is ShflKind.down:
            return "down"
        if self is ShflKind.idx:
            return "idx"
        raise ValueError("Unknown ShflKind enum entry.")



@register_attribute_builder("ShflKind")
def _shflkind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class TMAReduxKind(IntEnum):
    """NVVM TMA redux kind"""

    ADD = 0
    MAX = 2
    MIN = 1
    INC = 3
    DEC = 4
    AND = 5
    OR = 6
    XOR = 7

    def __str__(self):
        if self is TMAReduxKind.ADD:
            return "add"
        if self is TMAReduxKind.MAX:
            return "max"
        if self is TMAReduxKind.MIN:
            return "min"
        if self is TMAReduxKind.INC:
            return "inc"
        if self is TMAReduxKind.DEC:
            return "dec"
        if self is TMAReduxKind.AND:
            return "and"
        if self is TMAReduxKind.OR:
            return "or"
        if self is TMAReduxKind.XOR:
            return "xor"
        raise ValueError("Unknown TMAReduxKind enum entry.")



@register_attribute_builder("TMAReduxKind")
def _tmareduxkind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class TMAStoreMode(IntEnum):
    """NVVM TMA Store Mode"""

    TILE = 0
    IM2COL = 1

    def __str__(self):
        if self is TMAStoreMode.TILE:
            return "tile"
        if self is TMAStoreMode.IM2COL:
            return "im2col"
        raise ValueError("Unknown TMAStoreMode enum entry.")



@register_attribute_builder("TMAStoreMode")
def _tmastoremode(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class Tcgen05CpMulticast(IntEnum):
    """tcgen05 cp multicast"""

    NONE = 0
    WARPX2_02_13 = 1
    WARPX2_01_23 = 2
    WARPX4 = 3

    def __str__(self):
        if self is Tcgen05CpMulticast.NONE:
            return "none"
        if self is Tcgen05CpMulticast.WARPX2_02_13:
            return "warpx2_02_13"
        if self is Tcgen05CpMulticast.WARPX2_01_23:
            return "warpx2_01_23"
        if self is Tcgen05CpMulticast.WARPX4:
            return "warpx4"
        raise ValueError("Unknown Tcgen05CpMulticast enum entry.")



@register_attribute_builder("Tcgen05CpMulticast")
def _tcgen05cpmulticast(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class Tcgen05CpShape(IntEnum):
    """tcgen05 cp shapes"""

    SHAPE_128x256b = 0
    SHAPE_4x256b = 1
    SHAPE_128x128b = 2
    SHAPE_64x128b = 3
    SHAPE_32x128b = 4

    def __str__(self):
        if self is Tcgen05CpShape.SHAPE_128x256b:
            return "shape_128x256b"
        if self is Tcgen05CpShape.SHAPE_4x256b:
            return "shape_4x256b"
        if self is Tcgen05CpShape.SHAPE_128x128b:
            return "shape_128x128b"
        if self is Tcgen05CpShape.SHAPE_64x128b:
            return "shape_64x128b"
        if self is Tcgen05CpShape.SHAPE_32x128b:
            return "shape_32x128b"
        raise ValueError("Unknown Tcgen05CpShape enum entry.")



@register_attribute_builder("Tcgen05CpShape")
def _tcgen05cpshape(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class Tcgen05CpSrcFormat(IntEnum):
    """tcgen05 cp source format"""

    B6x16_P32 = 0
    B4x16_P64 = 1

    def __str__(self):
        if self is Tcgen05CpSrcFormat.B6x16_P32:
            return "b6x16_p32"
        if self is Tcgen05CpSrcFormat.B4x16_P64:
            return "b4x16_p64"
        raise ValueError("Unknown Tcgen05CpSrcFormat enum entry.")



@register_attribute_builder("Tcgen05CpSrcFormat")
def _tcgen05cpsrcformat(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class Tcgen05FenceKind(IntEnum):
    """NVVM Tcgen05 fence kind"""

    BEFORE_THREAD_SYNC = 0
    AFTER_THREAD_SYNC = 1

    def __str__(self):
        if self is Tcgen05FenceKind.BEFORE_THREAD_SYNC:
            return "before"
        if self is Tcgen05FenceKind.AFTER_THREAD_SYNC:
            return "after"
        raise ValueError("Unknown Tcgen05FenceKind enum entry.")



@register_attribute_builder("Tcgen05FenceKind")
def _tcgen05fencekind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class Tcgen05GroupKind(IntEnum):
    """NVVM Tcgen05 group kind"""

    CTA_1 = 0
    CTA_2 = 1

    def __str__(self):
        if self is Tcgen05GroupKind.CTA_1:
            return "cta_1"
        if self is Tcgen05GroupKind.CTA_2:
            return "cta_2"
        raise ValueError("Unknown Tcgen05GroupKind enum entry.")



@register_attribute_builder("Tcgen05GroupKind")
def _tcgen05groupkind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class Tcgen05WaitKind(IntEnum):
    """NVVM Tcgen05 wait kind"""

    LOAD = 0
    STORE = 1

    def __str__(self):
        if self is Tcgen05WaitKind.LOAD:
            return "load"
        if self is Tcgen05WaitKind.STORE:
            return "store"
        raise ValueError("Unknown Tcgen05WaitKind enum entry.")



@register_attribute_builder("Tcgen05WaitKind")
def _tcgen05waitkind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class WGMMAScaleIn(IntEnum):
    """WGMMA overflow options"""

    one = 1
    neg = auto()

    def __str__(self):
        if self is WGMMAScaleIn.one:
            return "one"
        if self is WGMMAScaleIn.neg:
            return "neg"
        raise ValueError("Unknown WGMMAScaleIn enum entry.")



@register_attribute_builder("WGMMAScaleIn")
def _wgmmascalein(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class WGMMAScaleOut(IntEnum):
    """WGMMA input predicate"""

    zero = 0
    one = 1

    def __str__(self):
        if self is WGMMAScaleOut.zero:
            return "zero"
        if self is WGMMAScaleOut.one:
            return "one"
        raise ValueError("Unknown WGMMAScaleOut enum entry.")



@register_attribute_builder("WGMMAScaleOut")
def _wgmmascaleout(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class WGMMATypes(IntEnum):
    """NVVM WGMMA types"""

    f16 = 0
    tf32 = 1
    u8 = 2
    s8 = 3
    b1 = 4
    bf16 = 5
    e4m3 = 6
    e5m2 = 7
    f32 = 8
    s32 = 9

    def __str__(self):
        if self is WGMMATypes.f16:
            return "f16"
        if self is WGMMATypes.tf32:
            return "tf32"
        if self is WGMMATypes.u8:
            return "u8"
        if self is WGMMATypes.s8:
            return "s8"
        if self is WGMMATypes.b1:
            return "b1"
        if self is WGMMATypes.bf16:
            return "bf16"
        if self is WGMMATypes.e4m3:
            return "e4m3"
        if self is WGMMATypes.e5m2:
            return "e5m2"
        if self is WGMMATypes.f32:
            return "f32"
        if self is WGMMATypes.s32:
            return "s32"
        raise ValueError("Unknown WGMMATypes enum entry.")



@register_attribute_builder("WGMMATypes")
def _wgmmatypes(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

@register_attribute_builder("FPRoundingModeAttr")
def _fproundingmodeattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.fp_rnd_mode<{str(x)}>', context=context)

@register_attribute_builder("LoadCacheModifierAttr")
def _loadcachemodifierattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm<load_cache_modifier {str(x)}>', context=context)

@register_attribute_builder("MMAB1OpAttr")
def _mmab1opattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.mma_b1op<{str(x)}>', context=context)

@register_attribute_builder("MMAFragAttr")
def _mmafragattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.mma_frag<{str(x)}>', context=context)

@register_attribute_builder("MMAIntOverflowAttr")
def _mmaintoverflowattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.mma_int_overflow<{str(x)}>', context=context)

@register_attribute_builder("MMALayoutAttr")
def _mmalayoutattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.mma_layout<{str(x)}>', context=context)

@register_attribute_builder("MMATypesAttr")
def _mmatypesattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.mma_type<{str(x)}>', context=context)

@register_attribute_builder("MemScopeKindAttr")
def _memscopekindattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.mem_scope<{str(x)}>', context=context)

@register_attribute_builder("ProxyKindAttr")
def _proxykindattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.proxy_kind<{str(x)}>', context=context)

@register_attribute_builder("ReduxKindAttr")
def _reduxkindattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm<redux_kind {str(x)}>', context=context)

@register_attribute_builder("SaturationModeAttr")
def _saturationmodeattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.sat_mode<{str(x)}>', context=context)

@register_attribute_builder("SetMaxRegisterActionAttr")
def _setmaxregisteractionattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm<action {str(x)}>', context=context)

@register_attribute_builder("SharedSpaceAttr")
def _sharedspaceattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.shared_space<{str(x)}>', context=context)

@register_attribute_builder("ShflKindAttr")
def _shflkindattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm<shfl_kind {str(x)}>', context=context)

@register_attribute_builder("TMAReduxKindAttr")
def _tmareduxkindattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.tma_redux_kind<{str(x)}>', context=context)

@register_attribute_builder("TMAStoreModeAttr")
def _tmastoremodeattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.tma_store_mode<{str(x)}>', context=context)

@register_attribute_builder("Tcgen05CpMulticastAttr")
def _tcgen05cpmulticastattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.tcgen05_cp_multicast<{str(x)}>', context=context)

@register_attribute_builder("Tcgen05CpShapeAttr")
def _tcgen05cpshapeattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.tcgen05_cp_shape<{str(x)}>', context=context)

@register_attribute_builder("Tcgen05CpSrcFormatAttr")
def _tcgen05cpsrcformatattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.tcgen05_cp_src_fmt<{str(x)}>', context=context)

@register_attribute_builder("Tcgen05FenceKindAttr")
def _tcgen05fencekindattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.tcgen05_fence<{str(x)}>', context=context)

@register_attribute_builder("Tcgen05GroupKindAttr")
def _tcgen05groupkindattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.tcgen05_group<{str(x)}>', context=context)

@register_attribute_builder("Tcgen05WaitKindAttr")
def _tcgen05waitkindattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.tcgen05_wait<{str(x)}>', context=context)

@register_attribute_builder("WGMMAScaleInAttr")
def _wgmmascaleinattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.wgmma_scale_in<{str(x)}>', context=context)

@register_attribute_builder("WGMMAScaleOutAttr")
def _wgmmascaleoutattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.wgmma_scale_out<{str(x)}>', context=context)

@register_attribute_builder("WGMMATypesAttr")
def _wgmmatypesattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvvm.wgmma_type<{str(x)}>', context=context)

