
# Autogenerated by mlir-tblgen; don't manually edit.

from enum import IntEnum, auto, IntFlag
from ._ods_common import _cext as _ods_cext
from ..ir import register_attribute_builder
_ods_ir = _ods_cext.ir

class BinaryFn(IntEnum):
    """allowed 32-bit signless integer cases: 0, 1, 2, 3, 4, 5, 6, 7, 8, 9"""

    add = 0
    sub = 1
    mul = 2
    div = 3
    div_unsigned = 4
    max_signed = 5
    min_signed = 6
    max_unsigned = 7
    min_unsigned = 8
    powf = 9

    def __str__(self):
        if self is BinaryFn.add:
            return "add"
        if self is BinaryFn.sub:
            return "sub"
        if self is BinaryFn.mul:
            return "mul"
        if self is BinaryFn.div:
            return "div"
        if self is BinaryFn.div_unsigned:
            return "div_unsigned"
        if self is BinaryFn.max_signed:
            return "max_signed"
        if self is BinaryFn.min_signed:
            return "min_signed"
        if self is BinaryFn.max_unsigned:
            return "max_unsigned"
        if self is BinaryFn.min_unsigned:
            return "min_unsigned"
        if self is BinaryFn.powf:
            return "powf"
        raise ValueError("Unknown BinaryFn enum entry.")



@register_attribute_builder("BinaryFn")
def _binaryfn(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class ElementwiseArityGroup(IntEnum):
    """allowed 32-bit signless integer cases: 1, 2, 3"""

    Unary = 1
    Binary = 2
    Ternary = 3

    def __str__(self):
        if self is ElementwiseArityGroup.Unary:
            return "Unary"
        if self is ElementwiseArityGroup.Binary:
            return "Binary"
        if self is ElementwiseArityGroup.Ternary:
            return "Ternary"
        raise ValueError("Unknown ElementwiseArityGroup enum entry.")



@register_attribute_builder("ElementwiseArityGroup")
def _elementwisearitygroup(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class ElementwiseCaseLimits(IntEnum):
    """allowed 32-bit signless integer cases: """

    LastUnary = 13
    LastBinary = 23
    LastTernary = 24

    def __str__(self):
        if self is ElementwiseCaseLimits.LastUnary:
            return "LastUnary"
        if self is ElementwiseCaseLimits.LastBinary:
            return "LastBinary"
        if self is ElementwiseCaseLimits.LastTernary:
            return "LastTernary"
        raise ValueError("Unknown ElementwiseCaseLimits enum entry.")



@register_attribute_builder("ElementwiseCaseLimits")
def _elementwisecaselimits(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class ElementwiseKind(IntEnum):
    """allowed 32-bit signless integer cases: 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23"""

    exp = 0
    log = 1
    abs = 2
    ceil = 3
    floor = 4
    negf = 5
    reciprocal = 6
    round = 7
    sqrt = 8
    rsqrt = 9
    square = 10
    tanh = 11
    erf = 12
    add = 13
    sub = 14
    mul = 15
    div = 16
    div_unsigned = 17
    max_signed = 18
    min_signed = 19
    max_unsigned = 20
    min_unsigned = 21
    powf = 22
    select = 23

    def __str__(self):
        if self is ElementwiseKind.exp:
            return "exp"
        if self is ElementwiseKind.log:
            return "log"
        if self is ElementwiseKind.abs:
            return "abs"
        if self is ElementwiseKind.ceil:
            return "ceil"
        if self is ElementwiseKind.floor:
            return "floor"
        if self is ElementwiseKind.negf:
            return "negf"
        if self is ElementwiseKind.reciprocal:
            return "reciprocal"
        if self is ElementwiseKind.round:
            return "round"
        if self is ElementwiseKind.sqrt:
            return "sqrt"
        if self is ElementwiseKind.rsqrt:
            return "rsqrt"
        if self is ElementwiseKind.square:
            return "square"
        if self is ElementwiseKind.tanh:
            return "tanh"
        if self is ElementwiseKind.erf:
            return "erf"
        if self is ElementwiseKind.add:
            return "add"
        if self is ElementwiseKind.sub:
            return "sub"
        if self is ElementwiseKind.mul:
            return "mul"
        if self is ElementwiseKind.div:
            return "div"
        if self is ElementwiseKind.div_unsigned:
            return "div_unsigned"
        if self is ElementwiseKind.max_signed:
            return "max_signed"
        if self is ElementwiseKind.min_signed:
            return "min_signed"
        if self is ElementwiseKind.max_unsigned:
            return "max_unsigned"
        if self is ElementwiseKind.min_unsigned:
            return "min_unsigned"
        if self is ElementwiseKind.powf:
            return "powf"
        if self is ElementwiseKind.select:
            return "select"
        raise ValueError("Unknown ElementwiseKind enum entry.")



@register_attribute_builder("ElementwiseKind")
def _elementwisekind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class IteratorType(IntEnum):
    """Iterator type"""

    parallel = 0
    reduction = 1

    def __str__(self):
        if self is IteratorType.parallel:
            return "parallel"
        if self is IteratorType.reduction:
            return "reduction"
        raise ValueError("Unknown IteratorType enum entry.")



@register_attribute_builder("IteratorType")
def _iteratortype(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class TernaryFn(IntEnum):
    """allowed 32-bit signless integer cases: 0"""

    select = 0

    def __str__(self):
        if self is TernaryFn.select:
            return "select"
        raise ValueError("Unknown TernaryFn enum entry.")



@register_attribute_builder("TernaryFn")
def _ternaryfn(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class TypeFn(IntEnum):
    """allowed 32-bit signless integer cases: 0, 1"""

    cast_signed = 0
    cast_unsigned = 1

    def __str__(self):
        if self is TypeFn.cast_signed:
            return "cast_signed"
        if self is TypeFn.cast_unsigned:
            return "cast_unsigned"
        raise ValueError("Unknown TypeFn enum entry.")



@register_attribute_builder("TypeFn")
def _typefn(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class UnaryFn(IntEnum):
    """allowed 32-bit signless integer cases: 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12"""

    exp = 0
    log = 1
    abs = 2
    ceil = 3
    floor = 4
    negf = 5
    reciprocal = 6
    round = 7
    sqrt = 8
    rsqrt = 9
    square = 10
    tanh = 11
    erf = 12

    def __str__(self):
        if self is UnaryFn.exp:
            return "exp"
        if self is UnaryFn.log:
            return "log"
        if self is UnaryFn.abs:
            return "abs"
        if self is UnaryFn.ceil:
            return "ceil"
        if self is UnaryFn.floor:
            return "floor"
        if self is UnaryFn.negf:
            return "negf"
        if self is UnaryFn.reciprocal:
            return "reciprocal"
        if self is UnaryFn.round:
            return "round"
        if self is UnaryFn.sqrt:
            return "sqrt"
        if self is UnaryFn.rsqrt:
            return "rsqrt"
        if self is UnaryFn.square:
            return "square"
        if self is UnaryFn.tanh:
            return "tanh"
        if self is UnaryFn.erf:
            return "erf"
        raise ValueError("Unknown UnaryFn enum entry.")



@register_attribute_builder("UnaryFn")
def _unaryfn(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

@register_attribute_builder("BinaryFnAttr")
def _binaryfnattr(x, context):
    return _ods_ir.Attribute.parse(f'#linalg.binary_fn<{str(x)}>', context=context)

@register_attribute_builder("ElementwiseKindAttr")
def _elementwisekindattr(x, context):
    return _ods_ir.Attribute.parse(f'#linalg.elementwise_kind<{str(x)}>', context=context)

@register_attribute_builder("IteratorTypeEnum")
def _iteratortypeenum(x, context):
    return _ods_ir.Attribute.parse(f'#linalg.iterator_type<{str(x)}>', context=context)

@register_attribute_builder("TernaryFnAttr")
def _ternaryfnattr(x, context):
    return _ods_ir.Attribute.parse(f'#linalg.ternary_fn<{str(x)}>', context=context)

@register_attribute_builder("TypeFnAttr")
def _typefnattr(x, context):
    return _ods_ir.Attribute.parse(f'#linalg.type_fn<{str(x)}>', context=context)

@register_attribute_builder("UnaryFnAttr")
def _unaryfnattr(x, context):
    return _ods_ir.Attribute.parse(f'#linalg.unary_fn<{str(x)}>', context=context)

