
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "emitc"

@_ods_cext.register_operation(_Dialect)
class AddOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.add"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

def add(result, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return AddOp(result=result, lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ApplyOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.apply"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, applicableOperator, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["applicableOperator"] = (applicableOperator if (
    isinstance(applicableOperator, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(applicableOperator, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def applicableOperator(self):
    return self.operation.attributes["applicableOperator"]

  @applicableOperator.setter
  def applicableOperator(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["applicableOperator"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def apply(result, applicable_operator, operand, *, loc=None, ip=None) -> _ods_ir.Value:
  return ApplyOp(result=result, applicableOperator=applicable_operator, operand=operand, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AssignOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.assign"

  _ODS_REGIONS = (0, True)

  def __init__(self, var, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(var)
    operands.append(value)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def var(self):
    return self.operation.operands[0]

  @builtins.property
  def value(self):
    return self.operation.operands[1]

def assign(var, value, *, loc=None, ip=None) -> _ods_ir.Operation:
  return AssignOp(var=var, value=value, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class BitwiseAndOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.bitwise_and"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

def bitwise_and(result, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return BitwiseAndOp(result=result, lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitwiseLeftShiftOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.bitwise_left_shift"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

def bitwise_left_shift(result, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return BitwiseLeftShiftOp(result=result, lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitwiseNotOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.bitwise_not"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, _gen_arg_0, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_gen_arg_0)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

def bitwise_not(result, _gen_arg_0, *, loc=None, ip=None) -> _ods_ir.Value:
  return BitwiseNotOp(result=result, _gen_arg_0=_gen_arg_0, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitwiseOrOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.bitwise_or"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

def bitwise_or(result, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return BitwiseOrOp(result=result, lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitwiseRightShiftOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.bitwise_right_shift"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

def bitwise_right_shift(result, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return BitwiseRightShiftOp(result=result, lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitwiseXorOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.bitwise_xor"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

def bitwise_xor(result, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return BitwiseXorOp(result=result, lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CallOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.call"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, callee, operands_, *, arg_attrs=None, res_attrs=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["callee"] = (callee if (
    isinstance(callee, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(callee, context=_ods_context))
    if arg_attrs is not None: attributes["arg_attrs"] = (arg_attrs if (
        isinstance(arg_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(arg_attrs, context=_ods_context))
    if res_attrs is not None: attributes["res_attrs"] = (res_attrs if (
        isinstance(res_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(res_attrs, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def callee(self):
    return self.operation.attributes["callee"]

  @callee.setter
  def callee(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["callee"] = value

  @builtins.property
  def arg_attrs(self):
    if "arg_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["arg_attrs"]

  @arg_attrs.setter
  def arg_attrs(self, value):
    if value is not None:
      self.operation.attributes["arg_attrs"] = value
    elif "arg_attrs" in self.operation.attributes:
      del self.operation.attributes["arg_attrs"]

  @arg_attrs.deleter
  def arg_attrs(self):
    del self.operation.attributes["arg_attrs"]

  @builtins.property
  def res_attrs(self):
    if "res_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["res_attrs"]

  @res_attrs.setter
  def res_attrs(self, value):
    if value is not None:
      self.operation.attributes["res_attrs"] = value
    elif "res_attrs" in self.operation.attributes:
      del self.operation.attributes["res_attrs"]

  @res_attrs.deleter
  def res_attrs(self):
    del self.operation.attributes["res_attrs"]

def call(result, callee, operands_, *, arg_attrs=None, res_attrs=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CallOp(result=result, callee=callee, operands_=operands_, arg_attrs=arg_attrs, res_attrs=res_attrs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CallOpaqueOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.call_opaque"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, callee, operands_, *, args=None, template_args=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["callee"] = (callee if (
    isinstance(callee, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(callee, context=_ods_context))
    if args is not None: attributes["args"] = (args if (
        isinstance(args, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
          _ods_ir.AttrBuilder.get('ArrayAttr')(args, context=_ods_context))
    if template_args is not None: attributes["template_args"] = (template_args if (
        isinstance(template_args, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
          _ods_ir.AttrBuilder.get('ArrayAttr')(template_args, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def callee(self):
    return self.operation.attributes["callee"]

  @callee.setter
  def callee(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["callee"] = value

  @builtins.property
  def args(self):
    if "args" not in self.operation.attributes:
      return None
    return self.operation.attributes["args"]

  @args.setter
  def args(self, value):
    if value is not None:
      self.operation.attributes["args"] = value
    elif "args" in self.operation.attributes:
      del self.operation.attributes["args"]

  @args.deleter
  def args(self):
    del self.operation.attributes["args"]

  @builtins.property
  def template_args(self):
    if "template_args" not in self.operation.attributes:
      return None
    return self.operation.attributes["template_args"]

  @template_args.setter
  def template_args(self, value):
    if value is not None:
      self.operation.attributes["template_args"] = value
    elif "template_args" in self.operation.attributes:
      del self.operation.attributes["template_args"]

  @template_args.deleter
  def template_args(self):
    del self.operation.attributes["template_args"]

def call_opaque(result, callee, operands_, *, args=None, template_args=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CallOpaqueOp(result=result, callee=callee, operands_=operands_, args=args, template_args=template_args, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CastOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(source)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(dest)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.results[0]

def cast(dest, source, *, loc=None, ip=None) -> _ods_ir.Value:
  return CastOp(dest=dest, source=source, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CmpOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.cmp"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, predicate, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["predicate"] = (predicate if (
    isinstance(predicate, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('EmitC_CmpPredicateAttr')) else
      _ods_ir.AttrBuilder.get('EmitC_CmpPredicateAttr')(predicate, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def predicate(self):
    return self.operation.attributes["predicate"]

  @predicate.setter
  def predicate(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["predicate"] = value

def cmp(result, predicate, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return CmpOp(result=result, predicate=predicate, lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConditionalOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.conditional"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, condition, true_value, false_value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(condition)
    operands.append(true_value)
    operands.append(false_value)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def condition(self):
    return self.operation.operands[0]

  @builtins.property
  def true_value(self):
    return self.operation.operands[1]

  @builtins.property
  def false_value(self):
    return self.operation.operands[2]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def conditional(result, condition, true_value, false_value, *, loc=None, ip=None) -> _ods_ir.Value:
  return ConditionalOp(result=result, condition=condition, true_value=true_value, false_value=false_value, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConstantOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.constant"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('EmitC_OpaqueOrTypedAttr')) else
      _ods_ir.AttrBuilder.get('EmitC_OpaqueOrTypedAttr')(value, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self):
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

def constant(result, value, *, loc=None, ip=None) -> _ods_ir.Value:
  return ConstantOp(result=result, value=value, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DeclareFuncOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.declare_func"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(sym_name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

def declare_func(sym_name, *, loc=None, ip=None) -> _ods_ir.Operation:
  return DeclareFuncOp(sym_name=sym_name, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class DivOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.div"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_gen_arg_0)
    operands.append(_gen_arg_1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

def div(result, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None) -> _ods_ir.Value:
  return DivOp(result=result, _gen_arg_0=_gen_arg_0, _gen_arg_1=_gen_arg_1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ExpressionOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.expression"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, *, do_not_inline=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(do_not_inline): attributes["do_not_inline"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def do_not_inline(self):
    return "do_not_inline" in self.operation.attributes

  @do_not_inline.setter
  def do_not_inline(self, value):
    if bool(value):
      self.operation.attributes["do_not_inline"] = _ods_ir.UnitAttr.get()
    elif "do_not_inline" in self.operation.attributes:
      del self.operation.attributes["do_not_inline"]

  @do_not_inline.deleter
  def do_not_inline(self):
    del self.operation.attributes["do_not_inline"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

  @builtins.property
  def region(self):
    return self.regions[0]

def expression(result, *, do_not_inline=None, loc=None, ip=None) -> _ods_ir.Value:
  return ExpressionOp(result=result, do_not_inline=do_not_inline, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FileOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.file"

  _ODS_REGIONS = (1, True)

  def __init__(self, id, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["id"] = (id if (
    isinstance(id, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Builtin_StringAttr')) else
      _ods_ir.AttrBuilder.get('Builtin_StringAttr')(id, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def id(self):
    return self.operation.attributes["id"]

  @id.setter
  def id(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["id"] = value

  @builtins.property
  def bodyRegion(self):
    return self.regions[0]

def file(id, *, loc=None, ip=None) -> _ods_ir.Operation:
  return FileOp(id=id, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ForOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.for"

  _ODS_REGIONS = (1, True)

  def __init__(self, lowerBound, upperBound, step, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lowerBound)
    operands.append(upperBound)
    operands.append(step)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lowerBound(self):
    return self.operation.operands[0]

  @builtins.property
  def upperBound(self):
    return self.operation.operands[1]

  @builtins.property
  def step(self):
    return self.operation.operands[2]

  @builtins.property
  def region(self):
    return self.regions[0]

def for_(lower_bound, upper_bound, step, *, loc=None, ip=None) -> _ods_ir.Operation:
  return ForOp(lowerBound=lower_bound, upperBound=upper_bound, step=step, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class FuncOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.func"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, function_type, *, specifiers=None, arg_attrs=None, res_attrs=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["function_type"] = (function_type if (
    isinstance(function_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_522')) else
      _ods_ir.AttrBuilder.get('anonymous_522')(function_type, context=_ods_context))
    if specifiers is not None: attributes["specifiers"] = (specifiers if (
        isinstance(specifiers, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrArrayAttr')) else
          _ods_ir.AttrBuilder.get('StrArrayAttr')(specifiers, context=_ods_context))
    if arg_attrs is not None: attributes["arg_attrs"] = (arg_attrs if (
        isinstance(arg_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(arg_attrs, context=_ods_context))
    if res_attrs is not None: attributes["res_attrs"] = (res_attrs if (
        isinstance(res_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(res_attrs, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def function_type(self):
    return self.operation.attributes["function_type"]

  @function_type.setter
  def function_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["function_type"] = value

  @builtins.property
  def specifiers(self):
    if "specifiers" not in self.operation.attributes:
      return None
    return self.operation.attributes["specifiers"]

  @specifiers.setter
  def specifiers(self, value):
    if value is not None:
      self.operation.attributes["specifiers"] = value
    elif "specifiers" in self.operation.attributes:
      del self.operation.attributes["specifiers"]

  @specifiers.deleter
  def specifiers(self):
    del self.operation.attributes["specifiers"]

  @builtins.property
  def arg_attrs(self):
    if "arg_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["arg_attrs"]

  @arg_attrs.setter
  def arg_attrs(self, value):
    if value is not None:
      self.operation.attributes["arg_attrs"] = value
    elif "arg_attrs" in self.operation.attributes:
      del self.operation.attributes["arg_attrs"]

  @arg_attrs.deleter
  def arg_attrs(self):
    del self.operation.attributes["arg_attrs"]

  @builtins.property
  def res_attrs(self):
    if "res_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["res_attrs"]

  @res_attrs.setter
  def res_attrs(self, value):
    if value is not None:
      self.operation.attributes["res_attrs"] = value
    elif "res_attrs" in self.operation.attributes:
      del self.operation.attributes["res_attrs"]

  @res_attrs.deleter
  def res_attrs(self):
    del self.operation.attributes["res_attrs"]

  @builtins.property
  def body(self):
    return self.regions[0]

def func(sym_name, function_type, *, specifiers=None, arg_attrs=None, res_attrs=None, loc=None, ip=None) -> _ods_ir.Operation:
  return FuncOp(sym_name=sym_name, function_type=function_type, specifiers=specifiers, arg_attrs=arg_attrs, res_attrs=res_attrs, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class GetGlobalOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.get_global"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["name"] = (name if (
    isinstance(name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(name, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def get_global(result, name, *, loc=None, ip=None) -> _ods_ir.Value:
  return GetGlobalOp(result=result, name=name, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GlobalOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.global"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, type_, *, initial_value=None, extern_specifier=None, static_specifier=None, const_specifier=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["type"] = (type_ if (
    isinstance(type_, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(type_, context=_ods_context))
    if initial_value is not None: attributes["initial_value"] = (initial_value if (
        isinstance(initial_value, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('EmitC_OpaqueOrTypedAttr')) else
          _ods_ir.AttrBuilder.get('EmitC_OpaqueOrTypedAttr')(initial_value, context=_ods_context))
    if bool(extern_specifier): attributes["extern_specifier"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(static_specifier): attributes["static_specifier"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(const_specifier): attributes["const_specifier"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def type_(self):
    return self.operation.attributes["type"]

  @type_.setter
  def type_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["type"] = value

  @builtins.property
  def initial_value(self):
    if "initial_value" not in self.operation.attributes:
      return None
    return self.operation.attributes["initial_value"]

  @initial_value.setter
  def initial_value(self, value):
    if value is not None:
      self.operation.attributes["initial_value"] = value
    elif "initial_value" in self.operation.attributes:
      del self.operation.attributes["initial_value"]

  @initial_value.deleter
  def initial_value(self):
    del self.operation.attributes["initial_value"]

  @builtins.property
  def extern_specifier(self):
    return "extern_specifier" in self.operation.attributes

  @extern_specifier.setter
  def extern_specifier(self, value):
    if bool(value):
      self.operation.attributes["extern_specifier"] = _ods_ir.UnitAttr.get()
    elif "extern_specifier" in self.operation.attributes:
      del self.operation.attributes["extern_specifier"]

  @extern_specifier.deleter
  def extern_specifier(self):
    del self.operation.attributes["extern_specifier"]

  @builtins.property
  def static_specifier(self):
    return "static_specifier" in self.operation.attributes

  @static_specifier.setter
  def static_specifier(self, value):
    if bool(value):
      self.operation.attributes["static_specifier"] = _ods_ir.UnitAttr.get()
    elif "static_specifier" in self.operation.attributes:
      del self.operation.attributes["static_specifier"]

  @static_specifier.deleter
  def static_specifier(self):
    del self.operation.attributes["static_specifier"]

  @builtins.property
  def const_specifier(self):
    return "const_specifier" in self.operation.attributes

  @const_specifier.setter
  def const_specifier(self, value):
    if bool(value):
      self.operation.attributes["const_specifier"] = _ods_ir.UnitAttr.get()
    elif "const_specifier" in self.operation.attributes:
      del self.operation.attributes["const_specifier"]

  @const_specifier.deleter
  def const_specifier(self):
    del self.operation.attributes["const_specifier"]

def global_(sym_name, type_, *, initial_value=None, extern_specifier=None, static_specifier=None, const_specifier=None, loc=None, ip=None) -> _ods_ir.Operation:
  return GlobalOp(sym_name=sym_name, type_=type_, initial_value=initial_value, extern_specifier=extern_specifier, static_specifier=static_specifier, const_specifier=const_specifier, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class IfOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.if"

  _ODS_REGIONS = (2, True)

  def __init__(self, condition, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(condition)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def condition(self):
    return self.operation.operands[0]

  @builtins.property
  def thenRegion(self):
    return self.regions[0]

  @builtins.property
  def elseRegion(self):
    return self.regions[1]

def if_(condition, *, loc=None, ip=None) -> _ods_ir.Operation:
  return IfOp(condition=condition, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class IncludeOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.include"

  _ODS_REGIONS = (0, True)

  def __init__(self, include, *, is_standard_include=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["include"] = (include if (
    isinstance(include, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(include, context=_ods_context))
    if bool(is_standard_include): attributes["is_standard_include"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def include(self):
    return self.operation.attributes["include"]

  @include.setter
  def include(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["include"] = value

  @builtins.property
  def is_standard_include(self):
    return "is_standard_include" in self.operation.attributes

  @is_standard_include.setter
  def is_standard_include(self, value):
    if bool(value):
      self.operation.attributes["is_standard_include"] = _ods_ir.UnitAttr.get()
    elif "is_standard_include" in self.operation.attributes:
      del self.operation.attributes["is_standard_include"]

  @is_standard_include.deleter
  def is_standard_include(self):
    del self.operation.attributes["is_standard_include"]

def include(include, *, is_standard_include=None, loc=None, ip=None) -> _ods_ir.Operation:
  return IncludeOp(include=include, is_standard_include=is_standard_include, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class LiteralOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.literal"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(value, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self):
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def literal(result, value, *, loc=None, ip=None) -> _ods_ir.Value:
  return LiteralOp(result=result, value=value, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LoadOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.load"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def load(result, operand, *, loc=None, ip=None) -> _ods_ir.Value:
  return LoadOp(result=result, operand=operand, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LogicalAndOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.logical_and"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

def logical_and(result, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return LogicalAndOp(result=result, lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LogicalNotOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.logical_not"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, _gen_arg_0, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_gen_arg_0)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

def logical_not(result, _gen_arg_0, *, loc=None, ip=None) -> _ods_ir.Value:
  return LogicalNotOp(result=result, _gen_arg_0=_gen_arg_0, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LogicalOrOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.logical_or"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

def logical_or(result, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return LogicalOrOp(result=result, lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MemberOfPtrOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.member_of_ptr"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, member, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["member"] = (member if (
    isinstance(member, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(member, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def member(self):
    return self.operation.attributes["member"]

  @member.setter
  def member(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["member"] = value

def member_of_ptr(result, member, operand, *, loc=None, ip=None) -> _ods_ir.Value:
  return MemberOfPtrOp(result=result, member=member, operand=operand, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MemberOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.member"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, member, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["member"] = (member if (
    isinstance(member, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(member, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def member(self):
    return self.operation.attributes["member"]

  @member.setter
  def member(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["member"] = value

def member(result, member, operand, *, loc=None, ip=None) -> _ods_ir.Value:
  return MemberOp(result=result, member=member, operand=operand, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MulOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.mul"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_gen_arg_0)
    operands.append(_gen_arg_1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

def mul(result, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None) -> _ods_ir.Value:
  return MulOp(result=result, _gen_arg_0=_gen_arg_0, _gen_arg_1=_gen_arg_1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RemOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.rem"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_gen_arg_0)
    operands.append(_gen_arg_1)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

def rem(result, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None) -> _ods_ir.Value:
  return RemOp(result=result, _gen_arg_0=_gen_arg_0, _gen_arg_1=_gen_arg_1, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReturnOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, operand=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    if operand is not None: operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self):
    return None if len(self.operation.operands) < 1 else self.operation.operands[0]

def return_(*, operand=None, loc=None, ip=None) -> _ods_ir.Operation:
  return ReturnOp(operand=operand, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SubOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.sub"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

def sub(result, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return SubOp(result=result, lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SubscriptOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.subscript"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, value, indices, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(value)
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def subscript(result, value, indices, *, loc=None, ip=None) -> _ods_ir.Value:
  return SubscriptOp(result=result, value=value, indices=indices, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SwitchOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.switch"

  _ODS_REGIONS = (1, False)

  def __init__(self, arg, cases, num_caseRegions, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(arg)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["cases"] = (cases if (
    isinstance(cases, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(cases, context=_ods_context))
    _ods_successors = None
    regions = 1 + num_caseRegions
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def cases(self):
    return self.operation.attributes["cases"]

  @cases.setter
  def cases(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["cases"] = value

  @builtins.property
  def defaultRegion(self):
    return self.regions[0]

  @builtins.property
  def caseRegions(self):
    return self.regions[1:]

def switch(arg, cases, num_case_regions, *, loc=None, ip=None) -> _ods_ir.Operation:
  return SwitchOp(arg=arg, cases=cases, num_caseRegions=num_case_regions, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class UnaryMinusOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.unary_minus"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, _gen_arg_0, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_gen_arg_0)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

def unary_minus(result, _gen_arg_0, *, loc=None, ip=None) -> _ods_ir.Value:
  return UnaryMinusOp(result=result, _gen_arg_0=_gen_arg_0, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class UnaryPlusOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.unary_plus"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, _gen_arg_0, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_gen_arg_0)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

def unary_plus(result, _gen_arg_0, *, loc=None, ip=None) -> _ods_ir.Value:
  return UnaryPlusOp(result=result, _gen_arg_0=_gen_arg_0, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class VariableOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.variable"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('EmitC_OpaqueOrTypedAttr')) else
      _ods_ir.AttrBuilder.get('EmitC_OpaqueOrTypedAttr')(value, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self):
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

def variable(result, value, *, loc=None, ip=None) -> _ods_ir.Value:
  return VariableOp(result=result, value=value, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class VerbatimOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.verbatim"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, fmtArgs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(fmtArgs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(value, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def fmtArgs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def value(self):
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

def verbatim(value, fmt_args, *, loc=None, ip=None) -> _ods_ir.Operation:
  return VerbatimOp(value=value, fmtArgs=fmt_args, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "emitc.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, result=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    if result is not None: operands.append(result)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def result(self):
    return None if len(self.operation.operands) < 1 else self.operation.operands[0]

def yield_(*, result=None, loc=None, ip=None) -> _ods_ir.Operation:
  return YieldOp(result=result, loc=loc, ip=ip)
