# This file allows users to call find_package(MLIR) and pick up our targets.

# Compute the installation prefix from this LLVMConfig.cmake file location.
get_filename_component(MLIR_INSTALL_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)

set(LLVM_VERSION 21.0.0)
find_package(LLVM ${LLVM_VERSION} EXACT REQUIRED CONFIG
             HINTS "${MLIR_INSTALL_PREFIX}/lib/cmake/llvm")

set(MLIR_EXPORTED_TARGETS "mlir-linalg-ods-yaml-gen;mlir-pdll;mlir-tblgen;MLIRPresburger;MLIRAnalysis;MLIRAsmParser;MLIRBytecodeReader;MLIRBytecodeWriter;MLIRBytecodeOpInterface;MLIRAffineToStandard;MLIRAMDGPUToROCDL;MLIRArithAttrToLLVMConversion;MLIRArithToAMDGPU;MLIRArithToArmSME;MLIRArithToEmitC;MLIRArithToLLVM;MLIRArithToSPIRV;MLIRArmNeon2dToIntr;MLIRArmSMEToSCF;MLIRArmSMEToLLVM;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexDivisionConversion;MLIRComplexToLibm;MLIRComplexToLLVM;MLIRComplexToSPIRV;MLIRComplexToStandard;MLIRControlFlowToLLVM;MLIRControlFlowToSCF;MLIRControlFlowToSPIRV;MLIRConvertToLLVMInterface;MLIRConvertToLLVMPass;MLIRFuncToEmitC;MLIRFuncToLLVM;MLIRFuncToSPIRV;MLIRGPUToGPURuntimeTransforms;MLIRGPUToLLVMSPV;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRIndexToLLVM;MLIRIndexToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToEmitC;MLIRMathToFuncs;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToROCDL;MLIRMathToSPIRV;MLIRMemRefToEmitC;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIRMeshToMPI;MLIRMPIToLLVM;MLIRNVGPUToNVVM;MLIRNVVMToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRReconcileUnrealizedCasts;MLIRSCFToControlFlow;MLIRSCFToEmitC;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRShapeToStandard;MLIRSPIRVAttrToLLVMConversion;MLIRSPIRVToLLVM;MLIRTensorToLinalg;MLIRTensorToSPIRV;MLIRTosaToArith;MLIRTosaToLinalg;MLIRTosaToMLProgram;MLIRTosaToSCF;MLIRTosaToTensor;MLIRUBToLLVM;MLIRUBToSPIRV;MLIRVectorToArmSME;MLIRVectorToGPU;MLIRVectorToLLVM;MLIRVectorToLLVMPass;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRVectorToXeGPU;MLIRObservers;MLIRDebug;MLIRAffineAnalysis;MLIRAffineDialect;MLIRAffineTransforms;MLIRAffineTransformOps;MLIRAffineUtils;MLIRAMDGPUDialect;MLIRAMDGPUTransforms;MLIRAMDGPUUtils;MLIRAMXDialect;MLIRAMXTransforms;MLIRArithDialect;MLIRArithValueBoundsOpInterfaceImpl;MLIRArithTransforms;MLIRArithUtils;MLIRArmNeonDialect;MLIRArmNeonTransforms;MLIRArmSMEDialect;MLIRArmSMETransforms;MLIRArmSVEDialect;MLIRArmSVETransforms;MLIRAsyncDialect;MLIRAsyncTransforms;MLIRBufferizationDialect;MLIRBufferizationPipelines;MLIRBufferizationTransformOps;MLIRBufferizationTransforms;MLIRComplexDialect;MLIRControlFlowDialect;MLIRControlFlowTransforms;MLIRDLTITransformOps;MLIRDLTIDialect;MLIREmitCDialect;MLIREmitCTransforms;MLIRFuncInlinerExtension;MLIRFuncMeshShardingExtensions;MLIRFuncAllExtensions;MLIRFuncDialect;MLIRFuncTransforms;MLIRFuncTransformOps;MLIRGPUDialect;MLIRGPUTransforms;MLIRGPUTransformOps;MLIRGPUPipelines;MLIRGPUUtils;MLIRIndexDialect;MLIRIRDL;MLIRLinalgDialect;MLIRLinalgTransformOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMDialect;MLIRNVVMDialect;MLIRROCDLDialect;MLIRVCIXDialect;MLIRMathDialect;MLIRMathTransforms;MLIRMemRefDialect;MLIRMemRefTransformOps;MLIRMemRefTransforms;MLIRMemRefUtils;MLIRShardingInterface;MLIRMeshDialect;MLIRMeshTransforms;MLIRMLProgramDialect;MLIRMLProgramTransforms;MLIRMPIDialect;MLIRNVGPUDialect;MLIRNVGPUUtils;MLIRNVGPUTransformOps;MLIRNVGPUTransforms;MLIROpenACCDialect;MLIROpenACCTransforms;MLIROpenACCMPCommon;MLIROpenMPDialect;MLIRPDLDialect;MLIRPDLInterpDialect;MLIRPolynomialDialect;MLIRPtrDialect;MLIRQuantDialect;MLIRQuantTransforms;MLIRQuantUtils;MLIRSCFDialect;MLIRSCFTransformOps;MLIRSCFTransforms;MLIRSCFUtils;MLIRShapeDialect;MLIRShapeOpsTransforms;MLIRSparseTensorEnums;MLIRSparseTensorDialect;MLIRSparseTensorPipelines;MLIRSparseTensorTransformOps;MLIRSparseTensorTransforms;MLIRSparseTensorUtils;MLIRSPIRVDialect;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRTensorMeshShardingExtensions;MLIRTensorAllExtensions;MLIRTensorDialect;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorTransformOps;MLIRTensorUtils;MLIRTosaDialect;MLIRTosaShardingInterfaceImpl;MLIRTosaTransforms;MLIRTransformDebugExtension;MLIRTransformDialectInterfaces;MLIRTransformDialect;MLIRTransformDialectIRDLExtension;MLIRTransformLoopExtension;MLIRTransformPDLExtension;MLIRTransformDialectTransforms;MLIRTransformDialectUtils;MLIRUBDialect;MLIRDialectUtils;MLIRVectorDialect;MLIRMaskableOpInterface;MLIRMaskingOpInterface;MLIRVectorTransforms;MLIRVectorTransformOps;MLIRVectorUtils;MLIRX86VectorDialect;MLIRX86VectorTransforms;MLIRXeGPUDialect;MLIRXeGPUTransforms;MLIRDialect;MLIRIR;MLIRCallInterfaces;MLIRCastInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDataLayoutInterfaces;MLIRDerivedAttributeOpInterface;MLIRDestinationStyleOpInterface;MLIRFunctionInterfaces;MLIRInferIntRangeInterface;MLIRInferTypeOpInterface;MLIRLoopLikeInterface;MLIRMemorySlotInterfaces;MLIRParallelCombiningOpInterface;MLIRRuntimeVerifiableOpInterface;MLIRShapedOpInterfaces;MLIRSideEffectInterfaces;MLIRSubsetOpInterface;MLIRTilingInterface;MLIRVectorInterfaces;MLIRViewLikeInterface;MLIRValueBoundsOpInterface;MLIRInferIntRangeCommon;MLIRParser;MLIRPass;MLIRQuery;MLIRQueryMatcher;MLIRReduce;MLIRRewrite;MLIRRewritePDL;MLIRSupport;MLIRTableGen;MLIRTargetCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRSPIRVTarget;MLIRArmNeonToLLVMIRTranslation;MLIRArmSMEToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRBuiltinToLLVMIRTranslation;MLIRGPUToLLVMIRTranslation;MLIRLLVMIRToLLVMTranslation;MLIRLLVMToLLVMIRTranslation;MLIRLLVMIRToNVVMTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRSPIRVToLLVMIRTranslation;MLIRVCIXToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRFromLLVMIRTranslationRegistration;MLIRTargetLLVM;MLIRNVVMTarget;MLIRROCDLTarget;MLIRLspServerSupportLib;MLIRLspServerLib;MLIROptLib;MLIRQueryLib;MLIRReduceLib;MLIRTblgenLib;MLIRTranslateLib;MLIRPDLLAST;MLIRPDLLCodeGen;MLIRPDLLODS;MLIRPluginsLib;MLIRTransformUtils;MLIRTransforms;MLIRExecutionEngineUtils;MLIRExecutionEngine;MLIRJitRunner;mlir_float16_utils;MLIRSparseTensorRuntime;mlir_c_runner_utils;mlir_runner_utils;mlir_async_runtime;mlir_arm_sme_abi_stubs;mlir_arm_runner_utils;MLIRCAPIDebug;obj.MLIRCAPIDebug;MLIRCAPIAMDGPU;obj.MLIRCAPIAMDGPU;MLIRCAPIArith;obj.MLIRCAPIArith;MLIRCAPIAsync;obj.MLIRCAPIAsync;MLIRCAPIControlFlow;obj.MLIRCAPIControlFlow;MLIRCAPIEmitC;obj.MLIRCAPIEmitC;MLIRCAPIMath;obj.MLIRCAPIMath;MLIRCAPIMemRef;obj.MLIRCAPIMemRef;MLIRCAPIGPU;obj.MLIRCAPIGPU;MLIRCAPIIndex;obj.MLIRCAPIIndex;MLIRCAPIIRDL;obj.MLIRCAPIIRDL;MLIRCAPILLVM;obj.MLIRCAPILLVM;MLIRCAPILinalg;obj.MLIRCAPILinalg;MLIRCAPIMLProgram;obj.MLIRCAPIMLProgram;MLIRCAPINVGPU;obj.MLIRCAPINVGPU;MLIRCAPINVVM;obj.MLIRCAPINVVM;MLIRCAPIROCDL;obj.MLIRCAPIROCDL;MLIRCAPISCF;obj.MLIRCAPISCF;MLIRCAPIShape;obj.MLIRCAPIShape;MLIRCAPISparseTensor;obj.MLIRCAPISparseTensor;MLIRCAPIFunc;obj.MLIRCAPIFunc;MLIRCAPISPIRV;obj.MLIRCAPISPIRV;MLIRCAPITensor;obj.MLIRCAPITensor;MLIRCAPITransformDialect;obj.MLIRCAPITransformDialect;MLIRCAPITransformDialectTransforms;obj.MLIRCAPITransformDialectTransforms;MLIRCAPIQuant;obj.MLIRCAPIQuant;MLIRCAPIOpenMP;obj.MLIRCAPIOpenMP;MLIRCAPIPDL;obj.MLIRCAPIPDL;MLIRCAPIVector;obj.MLIRCAPIVector;MLIRCAPIConversion;obj.MLIRCAPIConversion;MLIRCAPIInterfaces;obj.MLIRCAPIInterfaces;MLIRCAPIIR;obj.MLIRCAPIIR;MLIRCAPIRegisterEverything;obj.MLIRCAPIRegisterEverything;MLIRCAPITransforms;obj.MLIRCAPITransforms;MLIRCAPITarget;obj.MLIRCAPITarget;MLIRCAPIExecutionEngine;obj.MLIRCAPIExecutionEngine;MLIRTestAnalysis;MLIRTestConvertToSPIRV;MLIRTestFuncToLLVM;MLIRTestMathToVCIX;MLIRTestOneToNTypeConversionPass;MLIRTestVectorToSPIRV;MLIRAffineTransformsTestPasses;MLIRArithTestPasses;MLIRArmNeonTestPasses;MLIRArmSMETestPasses;MLIRBufferizationTestPasses;MLIRControlFlowTestPasses;MLIRDLTITestPasses;MLIRFuncTestPasses;MLIRGPUTestPasses;MLIRLinalgTestPasses;MLIRLLVMTestPasses;MLIRMathTestPasses;MLIRMemRefTestPasses;MLIRMeshTest;MLIRNVGPUTestPasses;MLIRSCFTestPasses;MLIRShapeTestPasses;MLIRSPIRVTestPasses;MLIRTensorTestPasses;MLIRTestDialect;MLIRTestFromLLVMIRTranslation;MLIRTestToLLVMIRTranslation;MLIRTestDynDialect;MLIRTosaTestPasses;MLIRTestTransformDialect;MLIRVectorTestPasses;MLIRLoopLikeInterfaceTestPasses;MLIRTilingInterfaceTestPasses;MLIRTestIR;MLIRTestPass;MLIRTestReducer;MLIRTestRewrite;MLIRTestPDLL;MLIRTestTransforms;MLIRPythonTestDialect;MLIRCAPIPythonTestDialect;obj.MLIRCAPIPythonTestDialect;mlir-lsp-server;MLIRMlirOptMain;mlir-opt;mlir-pdll-lsp-server;mlir-query;mlir-reduce;mlir-rewrite;mlir-translate;tblgen-lsp-server;tblgen-to-irdl;mlir-runner;MLIRPythonSources;MLIRPythonSources.Dialects;MLIRPythonSources.Core;MLIRPythonSources.Core.Python;MLIRPythonSources.Core.Python.Extras;MLIRPythonSources.ExecutionEngine;MLIRPythonCAPI.HeaderSources;MLIRPythonSources.Dialects.affine;MLIRPythonSources.Dialects.affine.ops_gen;MLIRPythonSources.Dialects.amdgpu;MLIRPythonSources.Dialects.amdgpu.ops_gen;MLIRPythonSources.Dialects.async;MLIRPythonSources.Dialects.async.ops_gen;MLIRPythonSources.Dialects.bufferization;MLIRPythonSources.Dialects.bufferization.ops_gen;MLIRPythonSources.Dialects.builtin;MLIRPythonSources.Dialects.builtin.ops_gen;MLIRPythonSources.Dialects.complex;MLIRPythonSources.Dialects.complex.ops_gen;MLIRPythonSources.Dialects.index;MLIRPythonSources.Dialects.index.ops_gen;MLIRPythonSources.Dialects.cf;MLIRPythonSources.Dialects.cf.ops_gen;MLIRPythonSources.Dialects.func;MLIRPythonSources.Dialects.func.ops_gen;MLIRPythonSources.Dialects.gpu;MLIRPythonSources.Dialects.gpu.ops_gen;MLIRPythonSources.Dialects.linalg;MLIRPythonSources.Dialects.linalg.ops_gen;MLIRPythonSources.Dialects.llvm;MLIRPythonSources.Dialects.llvm.ops_gen;MLIRPythonSources.Dialects.transform_pdl_extension;MLIRPythonSources.Dialects.transform_pdl_extension.ops_gen;MLIRPythonSources.Dialects.transform;MLIRPythonSources.Dialects.transform.ops_gen;MLIRPythonSources.Dialects.transform.extras;MLIRPythonSources.Dialects.transform.interpreter;MLIRPythonSources.Dialects.bufferization_transform;MLIRPythonSources.Dialects.bufferization_transform.ops_gen;MLIRPythonSources.Dialects.gpu_transform;MLIRPythonSources.Dialects.gpu_transform.ops_gen;MLIRPythonSources.Dialects.loop_transform;MLIRPythonSources.Dialects.loop_transform.ops_gen;MLIRPythonSources.Dialects.memref_transform;MLIRPythonSources.Dialects.memref_transform.ops_gen;MLIRPythonSources.Dialects.nvgpu_transform;MLIRPythonSources.Dialects.nvgpu_transform.ops_gen;MLIRPythonSources.Dialects.structured_transform;MLIRPythonSources.Dialects.structured_transform.ops_gen;MLIRPythonSources.Dialects.sparse_tensor_transform;MLIRPythonSources.Dialects.sparse_tensor_transform.ops_gen;MLIRPythonSources.Dialects.tensor_transform;MLIRPythonSources.Dialects.tensor_transform.ops_gen;MLIRPythonSources.Dialects.vector_transform;MLIRPythonSources.Dialects.vector_transform.ops_gen;MLIRPythonSources.Dialects.math;MLIRPythonSources.Dialects.math.ops_gen;MLIRPythonSources.Dialects.arith;MLIRPythonSources.Dialects.arith.ops_gen;MLIRPythonSources.Dialects.memref;MLIRPythonSources.Dialects.memref.ops_gen;MLIRPythonSources.Dialects.ml_program;MLIRPythonSources.Dialects.ml_program.ops_gen;MLIRPythonSources.Dialects.nvgpu;MLIRPythonSources.Dialects.nvgpu.ops_gen;MLIRPythonSources.Dialects.nvvm;MLIRPythonSources.Dialects.nvvm.ops_gen;MLIRPythonSources.Dialects.rocdl;MLIRPythonSources.Dialects.rocdl.ops_gen;MLIRPythonSources.Dialects.quant;MLIRPythonSources.Dialects.emitc;MLIRPythonSources.Dialects.emitc.ops_gen;MLIRPythonSources.Dialects.pdl;MLIRPythonSources.Dialects.pdl.ops_gen;MLIRPythonSources.Dialects.omp;MLIRPythonSources.Dialects.omp.ops_gen;MLIRPythonSources.Dialects.scf;MLIRPythonSources.Dialects.scf.ops_gen;MLIRPythonSources.Dialects.shape;MLIRPythonSources.Dialects.shape.ops_gen;MLIRPythonSources.Dialects.sparse_tensor;MLIRPythonSources.Dialects.sparse_tensor.ops_gen;MLIRPythonSources.Dialects.spirv;MLIRPythonSources.Dialects.spirv.ops_gen;MLIRPythonSources.Dialects.tensor;MLIRPythonSources.Dialects.tensor.ops_gen;MLIRPythonSources.Dialects.tosa;MLIRPythonSources.Dialects.tosa.ops_gen;MLIRPythonSources.Dialects.vector;MLIRPythonSources.Dialects.vector.ops_gen;MLIRPythonExtension.Core;MLIRPythonExtension.RegisterEverything;MLIRPythonExtension.Dialects.Linalg.Pybind;MLIRPythonExtension.Dialects.GPU.Pybind;MLIRPythonExtension.Dialects.LLVM.Pybind;MLIRPythonExtension.Dialects.Quant.Pybind;MLIRPythonExtension.Dialects.NVGPU.Pybind;MLIRPythonExtension.Dialects.PDL.Pybind;MLIRPythonExtension.Dialects.SparseTensor.Pybind;MLIRPythonExtension.Dialects.Transform.Pybind;MLIRPythonExtension.AsyncDialectPasses;MLIRPythonExtension.ExecutionEngine;MLIRPythonExtension.GPUDialectPasses;MLIRPythonExtension.LinalgPasses;MLIRPythonExtension.SparseTensorDialectPasses;MLIRPythonExtension.TransformInterpreter;MLIRPythonTestSources;MLIRPythonTestSources.Dialects;MLIRPythonTestSources.Dialects.PythonTest;MLIRPythonTestSources.Dialects.PythonTest.ops_gen;MLIRPythonTestSources.PythonTestExtensionPybind11;MLIRPythonTestSources.PythonTestExtensionNanobind;mlir-transform-opt;mlir-cat;mlir-minimal-opt;mlir-minimal-opt-canonicalize")
set(MLIR_CMAKE_DIR "${MLIR_INSTALL_PREFIX}/lib/cmake/mlir")
set(MLIR_INCLUDE_DIRS "${MLIR_INSTALL_PREFIX}/include")
set(MLIR_TABLEGEN_EXE "mlir-tblgen")
set(MLIR_PDLL_TABLEGEN_EXE "mlir-pdll")
set(MLIR_SRC_SHARDER_TABLEGEN_EXE "mlir-src-sharder")
set(MLIR_INSTALL_AGGREGATE_OBJECTS "1")
set(MLIR_ENABLE_BINDINGS_PYTHON "ON")
set(MLIR_ENABLE_EXECUTION_ENGINE "1")

set_property(GLOBAL PROPERTY MLIR_ALL_LIBS "MLIRPresburger;MLIRAnalysis;MLIRAsmParser;MLIRBytecodeReader;MLIRBytecodeWriter;MLIRBytecodeOpInterface;MLIRAffineToStandard;MLIRAMDGPUToROCDL;MLIRArithAttrToLLVMConversion;MLIRArithToAMDGPU;MLIRArithToArmSME;MLIRArithToEmitC;MLIRArithToLLVM;MLIRArithToSPIRV;MLIRArmNeon2dToIntr;MLIRArmSMEToSCF;MLIRArmSMEToLLVM;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexDivisionConversion;MLIRComplexToLibm;MLIRComplexToLLVM;MLIRComplexToSPIRV;MLIRComplexToStandard;MLIRControlFlowToLLVM;MLIRControlFlowToSCF;MLIRControlFlowToSPIRV;MLIRConvertToLLVMInterface;MLIRConvertToLLVMPass;MLIRFuncToEmitC;MLIRFuncToLLVM;MLIRFuncToSPIRV;MLIRGPUToGPURuntimeTransforms;MLIRGPUToLLVMSPV;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRIndexToLLVM;MLIRIndexToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToEmitC;MLIRMathToFuncs;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToROCDL;MLIRMathToSPIRV;MLIRMemRefToEmitC;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIRMeshToMPI;MLIRMPIToLLVM;MLIRNVGPUToNVVM;MLIRNVVMToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRReconcileUnrealizedCasts;MLIRSCFToControlFlow;MLIRSCFToEmitC;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRShapeToStandard;MLIRSPIRVAttrToLLVMConversion;MLIRSPIRVToLLVM;MLIRTensorToLinalg;MLIRTensorToSPIRV;MLIRTosaToArith;MLIRTosaToLinalg;MLIRTosaToMLProgram;MLIRTosaToSCF;MLIRTosaToTensor;MLIRUBToLLVM;MLIRUBToSPIRV;MLIRVectorToArmSME;MLIRVectorToGPU;MLIRVectorToLLVM;MLIRVectorToLLVMPass;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRVectorToXeGPU;MLIRObservers;MLIRDebug;MLIRAffineAnalysis;MLIRAffineDialect;MLIRAffineTransforms;MLIRAffineTransformOps;MLIRAffineUtils;MLIRAMDGPUDialect;MLIRAMDGPUTransforms;MLIRAMDGPUUtils;MLIRAMXDialect;MLIRAMXTransforms;MLIRArithDialect;MLIRArithValueBoundsOpInterfaceImpl;MLIRArithTransforms;MLIRArithUtils;MLIRArmNeonDialect;MLIRArmNeonTransforms;MLIRArmSMEDialect;MLIRArmSMETransforms;MLIRArmSVEDialect;MLIRArmSVETransforms;MLIRAsyncDialect;MLIRAsyncTransforms;MLIRBufferizationDialect;MLIRBufferizationPipelines;MLIRBufferizationTransformOps;MLIRBufferizationTransforms;MLIRComplexDialect;MLIRControlFlowDialect;MLIRControlFlowTransforms;MLIRDLTITransformOps;MLIRDLTIDialect;MLIREmitCDialect;MLIREmitCTransforms;MLIRFuncInlinerExtension;MLIRFuncMeshShardingExtensions;MLIRFuncAllExtensions;MLIRFuncDialect;MLIRFuncTransforms;MLIRFuncTransformOps;MLIRGPUDialect;MLIRGPUTransforms;MLIRGPUTransformOps;MLIRGPUPipelines;MLIRGPUUtils;MLIRIndexDialect;MLIRIRDL;MLIRLinalgDialect;MLIRLinalgTransformOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMDialect;MLIRNVVMDialect;MLIRROCDLDialect;MLIRVCIXDialect;MLIRMathDialect;MLIRMathTransforms;MLIRMemRefDialect;MLIRMemRefTransformOps;MLIRMemRefTransforms;MLIRMemRefUtils;MLIRShardingInterface;MLIRMeshDialect;MLIRMeshTransforms;MLIRMLProgramDialect;MLIRMLProgramTransforms;MLIRMPIDialect;MLIRNVGPUDialect;MLIRNVGPUUtils;MLIRNVGPUTransformOps;MLIRNVGPUTransforms;MLIROpenACCDialect;MLIROpenACCTransforms;MLIROpenACCMPCommon;MLIROpenMPDialect;MLIRPDLDialect;MLIRPDLInterpDialect;MLIRPolynomialDialect;MLIRPtrDialect;MLIRQuantDialect;MLIRQuantTransforms;MLIRQuantUtils;MLIRSCFDialect;MLIRSCFTransformOps;MLIRSCFTransforms;MLIRSCFUtils;MLIRShapeDialect;MLIRShapeOpsTransforms;MLIRSparseTensorEnums;MLIRSparseTensorDialect;MLIRSparseTensorPipelines;MLIRSparseTensorTransformOps;MLIRSparseTensorTransforms;MLIRSparseTensorUtils;MLIRSPIRVDialect;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRTensorMeshShardingExtensions;MLIRTensorAllExtensions;MLIRTensorDialect;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorTransformOps;MLIRTensorUtils;MLIRTosaDialect;MLIRTosaShardingInterfaceImpl;MLIRTosaTransforms;MLIRTransformDebugExtension;MLIRTransformDialectInterfaces;MLIRTransformDialect;MLIRTransformDialectIRDLExtension;MLIRTransformLoopExtension;MLIRTransformPDLExtension;MLIRTransformDialectTransforms;MLIRTransformDialectUtils;MLIRUBDialect;MLIRDialectUtils;MLIRVectorDialect;MLIRMaskableOpInterface;MLIRMaskingOpInterface;MLIRVectorTransforms;MLIRVectorTransformOps;MLIRVectorUtils;MLIRX86VectorDialect;MLIRX86VectorTransforms;MLIRXeGPUDialect;MLIRXeGPUTransforms;MLIRDialect;MLIRIR;MLIRCallInterfaces;MLIRCastInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDataLayoutInterfaces;MLIRDerivedAttributeOpInterface;MLIRDestinationStyleOpInterface;MLIRFunctionInterfaces;MLIRInferIntRangeInterface;MLIRInferTypeOpInterface;MLIRLoopLikeInterface;MLIRMemorySlotInterfaces;MLIRParallelCombiningOpInterface;MLIRRuntimeVerifiableOpInterface;MLIRShapedOpInterfaces;MLIRSideEffectInterfaces;MLIRSubsetOpInterface;MLIRTilingInterface;MLIRVectorInterfaces;MLIRViewLikeInterface;MLIRValueBoundsOpInterface;MLIRInferIntRangeCommon;MLIRParser;MLIRPass;MLIRQuery;MLIRQueryMatcher;MLIRReduce;MLIRRewrite;MLIRRewritePDL;MLIRSupport;MLIRTableGen;MLIRTargetCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRSPIRVTarget;MLIRArmNeonToLLVMIRTranslation;MLIRArmSMEToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRBuiltinToLLVMIRTranslation;MLIRGPUToLLVMIRTranslation;MLIRLLVMIRToLLVMTranslation;MLIRLLVMToLLVMIRTranslation;MLIRLLVMIRToNVVMTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRSPIRVToLLVMIRTranslation;MLIRVCIXToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRFromLLVMIRTranslationRegistration;MLIRTargetLLVM;MLIRNVVMTarget;MLIRROCDLTarget;MLIRLspServerSupportLib;MLIRLspServerLib;MLIROptLib;MLIRQueryLib;MLIRReduceLib;MLIRTblgenLib;MLIRTranslateLib;MLIRPDLLAST;MLIRPDLLCodeGen;MLIRPDLLODS;MLIRPluginsLib;MLIRTransformUtils;MLIRTransforms;MLIRExecutionEngineUtils;MLIRExecutionEngine;MLIRJitRunner;mlir_float16_utils;MLIRSparseTensorRuntime;mlir_c_runner_utils;mlir_runner_utils;mlir_async_runtime;mlir_arm_sme_abi_stubs;mlir_arm_runner_utils;MLIRCAPIDebug;obj.MLIRCAPIDebug;MLIRCAPIAMDGPU;obj.MLIRCAPIAMDGPU;MLIRCAPIArith;obj.MLIRCAPIArith;MLIRCAPIAsync;obj.MLIRCAPIAsync;MLIRCAPIControlFlow;obj.MLIRCAPIControlFlow;MLIRCAPIEmitC;obj.MLIRCAPIEmitC;MLIRCAPIMath;obj.MLIRCAPIMath;MLIRCAPIMemRef;obj.MLIRCAPIMemRef;MLIRCAPIGPU;obj.MLIRCAPIGPU;MLIRCAPIIndex;obj.MLIRCAPIIndex;MLIRCAPIIRDL;obj.MLIRCAPIIRDL;MLIRCAPILLVM;obj.MLIRCAPILLVM;MLIRCAPILinalg;obj.MLIRCAPILinalg;MLIRCAPIMLProgram;obj.MLIRCAPIMLProgram;MLIRCAPINVGPU;obj.MLIRCAPINVGPU;MLIRCAPINVVM;obj.MLIRCAPINVVM;MLIRCAPIROCDL;obj.MLIRCAPIROCDL;MLIRCAPISCF;obj.MLIRCAPISCF;MLIRCAPIShape;obj.MLIRCAPIShape;MLIRCAPISparseTensor;obj.MLIRCAPISparseTensor;MLIRCAPIFunc;obj.MLIRCAPIFunc;MLIRCAPISPIRV;obj.MLIRCAPISPIRV;MLIRCAPITensor;obj.MLIRCAPITensor;MLIRCAPITransformDialect;obj.MLIRCAPITransformDialect;MLIRCAPITransformDialectTransforms;obj.MLIRCAPITransformDialectTransforms;MLIRCAPIQuant;obj.MLIRCAPIQuant;MLIRCAPIOpenMP;obj.MLIRCAPIOpenMP;MLIRCAPIPDL;obj.MLIRCAPIPDL;MLIRCAPIVector;obj.MLIRCAPIVector;MLIRCAPIConversion;obj.MLIRCAPIConversion;MLIRCAPIInterfaces;obj.MLIRCAPIInterfaces;MLIRCAPIIR;obj.MLIRCAPIIR;MLIRCAPIRegisterEverything;obj.MLIRCAPIRegisterEverything;MLIRCAPITransforms;obj.MLIRCAPITransforms;MLIRCAPITarget;obj.MLIRCAPITarget;MLIRCAPIExecutionEngine;obj.MLIRCAPIExecutionEngine;MLIRTestAnalysis;MLIRTestConvertToSPIRV;MLIRTestFuncToLLVM;MLIRTestMathToVCIX;MLIRTestOneToNTypeConversionPass;MLIRTestVectorToSPIRV;MLIRAffineTransformsTestPasses;MLIRArithTestPasses;MLIRArmNeonTestPasses;MLIRArmSMETestPasses;MLIRBufferizationTestPasses;MLIRControlFlowTestPasses;MLIRDLTITestPasses;MLIRFuncTestPasses;MLIRGPUTestPasses;MLIRLinalgTestPasses;MLIRLLVMTestPasses;MLIRMathTestPasses;MLIRMemRefTestPasses;MLIRMeshTest;MLIRNVGPUTestPasses;MLIRSCFTestPasses;MLIRShapeTestPasses;MLIRSPIRVTestPasses;MLIRTensorTestPasses;MLIRTestDialect;MLIRTestFromLLVMIRTranslation;MLIRTestToLLVMIRTranslation;MLIRTestDynDialect;MLIRTosaTestPasses;MLIRTestTransformDialect;MLIRVectorTestPasses;MLIRLoopLikeInterfaceTestPasses;MLIRTilingInterfaceTestPasses;MLIRTestIR;MLIRTestPass;MLIRTestReducer;MLIRTestRewrite;MLIRTestPDLL;MLIRTestTransforms;MLIRPythonTestDialect;MLIRCAPIPythonTestDialect;obj.MLIRCAPIPythonTestDialect;MLIRMlirOptMain")
set_property(GLOBAL PROPERTY MLIR_DIALECT_LIBS "MLIRAffineAnalysis;MLIRAffineDialect;MLIRAffineTransforms;MLIRAffineTransformOps;MLIRAffineUtils;MLIRAMDGPUDialect;MLIRAMDGPUTransforms;MLIRAMDGPUUtils;MLIRAMXDialect;MLIRAMXTransforms;MLIRArithDialect;MLIRArithValueBoundsOpInterfaceImpl;MLIRArithTransforms;MLIRArithUtils;MLIRArmNeonDialect;MLIRArmNeonTransforms;MLIRArmSMEDialect;MLIRArmSMETransforms;MLIRArmSVEDialect;MLIRArmSVETransforms;MLIRAsyncDialect;MLIRAsyncTransforms;MLIRBufferizationDialect;MLIRBufferizationPipelines;MLIRBufferizationTransformOps;MLIRBufferizationTransforms;MLIRComplexDialect;MLIRControlFlowDialect;MLIRControlFlowTransforms;MLIRDLTITransformOps;MLIRDLTIDialect;MLIREmitCDialect;MLIREmitCTransforms;MLIRFuncDialect;MLIRFuncTransforms;MLIRFuncTransformOps;MLIRGPUDialect;MLIRGPUTransforms;MLIRGPUTransformOps;MLIRGPUPipelines;MLIRGPUUtils;MLIRIndexDialect;MLIRIRDL;MLIRLinalgDialect;MLIRLinalgTransformOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMDialect;MLIRNVVMDialect;MLIRROCDLDialect;MLIRVCIXDialect;MLIRMathDialect;MLIRMathTransforms;MLIRMemRefDialect;MLIRMemRefTransformOps;MLIRMemRefTransforms;MLIRMemRefUtils;MLIRMeshDialect;MLIRMeshTransforms;MLIRMLProgramDialect;MLIRMLProgramTransforms;MLIRMPIDialect;MLIRNVGPUDialect;MLIRNVGPUUtils;MLIRNVGPUTransformOps;MLIRNVGPUTransforms;MLIROpenACCDialect;MLIROpenACCTransforms;MLIROpenMPDialect;MLIRPDLDialect;MLIRPDLInterpDialect;MLIRPolynomialDialect;MLIRPtrDialect;MLIRQuantDialect;MLIRQuantTransforms;MLIRQuantUtils;MLIRSCFDialect;MLIRSCFTransformOps;MLIRSCFTransforms;MLIRSCFUtils;MLIRShapeDialect;MLIRShapeOpsTransforms;MLIRSparseTensorDialect;MLIRSparseTensorPipelines;MLIRSparseTensorTransformOps;MLIRSparseTensorTransforms;MLIRSparseTensorUtils;MLIRSPIRVDialect;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRTensorDialect;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorTransformOps;MLIRTensorUtils;MLIRTosaDialect;MLIRTosaShardingInterfaceImpl;MLIRTosaTransforms;MLIRTransformDebugExtension;MLIRTransformDialect;MLIRTransformDialectIRDLExtension;MLIRTransformLoopExtension;MLIRTransformPDLExtension;MLIRTransformDialectTransforms;MLIRTransformDialectUtils;MLIRUBDialect;MLIRVectorDialect;MLIRVectorTransforms;MLIRVectorTransformOps;MLIRVectorUtils;MLIRX86VectorDialect;MLIRX86VectorTransforms;MLIRXeGPUDialect;MLIRXeGPUTransforms;MLIRSPIRVTarget;MLIRNVVMTarget;MLIRROCDLTarget;MLIRTestDynDialect;MLIRTosaTestPasses")
set_property(GLOBAL PROPERTY MLIR_CONVERSION_LIBS "MLIRAffineToStandard;MLIRAMDGPUToROCDL;MLIRArithAttrToLLVMConversion;MLIRArithToAMDGPU;MLIRArithToArmSME;MLIRArithToEmitC;MLIRArithToLLVM;MLIRArithToSPIRV;MLIRArmNeon2dToIntr;MLIRArmSMEToSCF;MLIRArmSMEToLLVM;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexDivisionConversion;MLIRComplexToLibm;MLIRComplexToLLVM;MLIRComplexToSPIRV;MLIRComplexToStandard;MLIRControlFlowToLLVM;MLIRControlFlowToSCF;MLIRControlFlowToSPIRV;MLIRConvertToLLVMInterface;MLIRConvertToLLVMPass;MLIRFuncToEmitC;MLIRFuncToLLVM;MLIRFuncToSPIRV;MLIRGPUToGPURuntimeTransforms;MLIRGPUToLLVMSPV;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRIndexToLLVM;MLIRIndexToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToEmitC;MLIRMathToFuncs;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToROCDL;MLIRMathToSPIRV;MLIRMemRefToEmitC;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIRMeshToMPI;MLIRMPIToLLVM;MLIRNVGPUToNVVM;MLIRNVVMToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRReconcileUnrealizedCasts;MLIRSCFToControlFlow;MLIRSCFToEmitC;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRShapeToStandard;MLIRSPIRVAttrToLLVMConversion;MLIRSPIRVToLLVM;MLIRTensorToLinalg;MLIRTensorToSPIRV;MLIRTosaToArith;MLIRTosaToLinalg;MLIRTosaToMLProgram;MLIRTosaToSCF;MLIRTosaToTensor;MLIRUBToLLVM;MLIRUBToSPIRV;MLIRVectorToArmSME;MLIRVectorToGPU;MLIRVectorToLLVM;MLIRVectorToLLVMPass;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRVectorToXeGPU")
set_property(GLOBAL PROPERTY MLIR_EXTENSION_LIBS "MLIRFuncInlinerExtension;MLIRFuncMeshShardingExtensions;MLIRFuncAllExtensions;MLIRTensorMeshShardingExtensions;MLIRTensorAllExtensions")
set_property(GLOBAL PROPERTY MLIR_TRANSLATION_LIBS "MLIRTargetCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRArmNeonToLLVMIRTranslation;MLIRArmSMEToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRBuiltinToLLVMIRTranslation;MLIRGPUToLLVMIRTranslation;MLIRLLVMIRToLLVMTranslation;MLIRLLVMToLLVMIRTranslation;MLIRLLVMIRToNVVMTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRSPIRVToLLVMIRTranslation;MLIRVCIXToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRFromLLVMIRTranslationRegistration;MLIRTestFromLLVMIRTranslation;MLIRTestToLLVMIRTranslation")
set_property(GLOBAL PROPERTY MLIR_UPSTREAM_CAPI_LIBS "MLIRCAPIDebug;MLIRCAPIAMDGPU;MLIRCAPIArith;MLIRCAPIAsync;MLIRCAPIControlFlow;MLIRCAPIEmitC;MLIRCAPIMath;MLIRCAPIMemRef;MLIRCAPIGPU;MLIRCAPIIndex;MLIRCAPIIRDL;MLIRCAPILLVM;MLIRCAPILinalg;MLIRCAPIMLProgram;MLIRCAPINVGPU;MLIRCAPINVVM;MLIRCAPIROCDL;MLIRCAPISCF;MLIRCAPIShape;MLIRCAPISparseTensor;MLIRCAPIFunc;MLIRCAPISPIRV;MLIRCAPITensor;MLIRCAPITransformDialect;MLIRCAPITransformDialectTransforms;MLIRCAPIQuant;MLIRCAPIOpenMP;MLIRCAPIPDL;MLIRCAPIVector;MLIRCAPIConversion;MLIRCAPIInterfaces;MLIRCAPIIR;MLIRCAPIRegisterEverything;MLIRCAPITransforms;MLIRCAPITarget;MLIRCAPIExecutionEngine")

# Provide all our library targets to users.
# More specifically, configure MLIR so that it can be directly included in a top
# level CMakeLists.txt, but also so that it can be imported via `find_package`.
# This is based on how LLVM handles exports.
if(NOT TARGET MLIRSupport)
  include("${MLIR_CMAKE_DIR}/MLIRTargets.cmake")
endif()

# By creating these targets here, subprojects that depend on MLIR's
# tablegen-generated headers can always depend on these targets whether building
# in-tree with MLIR or not.
if(NOT TARGET mlir-tablegen-targets)
  add_custom_target(mlir-tablegen-targets)
endif()
if(NOT TARGET mlir-headers)
  add_custom_target(mlir-headers)
endif()
if(NOT TARGET mlir-generic-headers)
  add_custom_target(mlir-generic-headers)
endif()
if(NOT TARGET mlir-doc)
  add_custom_target(mlir-doc)
endif()
