/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Enum Utility Declarations                                                  *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: NVVMOps.td                                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace NVVM {
// NVVM FPRoundingMode kind
enum class FPRoundingMode : uint32_t {
  NONE = 0,
  RN = 1,
  RM = 2,
  RP = 3,
  RZ = 4,
  RNA = 5,
};

::std::optional<FPRoundingMode> symbolizeFPRoundingMode(uint32_t);
::llvm::StringRef stringifyFPRoundingMode(FPRoundingMode);
::std::optional<FPRoundingMode> symbolizeFPRoundingMode(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForFPRoundingMode() {
  return 5;
}


inline ::llvm::StringRef stringifyEnum(FPRoundingMode enumValue) {
  return stringifyFPRoundingMode(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<FPRoundingMode> symbolizeEnum<FPRoundingMode>(::llvm::StringRef str) {
  return symbolizeFPRoundingMode(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::FPRoundingMode, ::mlir::NVVM::FPRoundingMode> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::FPRoundingMode> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM FPRoundingMode kind");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::FPRoundingMode> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::FPRoundingMode>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM FPRoundingMode kind specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::FPRoundingMode>, std::optional<::mlir::NVVM::FPRoundingMode>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::FPRoundingMode>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::FPRoundingMode>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::FPRoundingMode> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::FPRoundingMode>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM FPRoundingMode kind specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::FPRoundingMode value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::FPRoundingMode> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::FPRoundingMode getEmptyKey() {
    return static_cast<::mlir::NVVM::FPRoundingMode>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::FPRoundingMode getTombstoneKey() {
    return static_cast<::mlir::NVVM::FPRoundingMode>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::FPRoundingMode &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::FPRoundingMode &lhs, const ::mlir::NVVM::FPRoundingMode &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM load cache modifier kind
enum class LoadCacheModifierKind : uint32_t {
  CA = 0,
  CG = 1,
  CS = 2,
  LU = 3,
  CV = 4,
};

::std::optional<LoadCacheModifierKind> symbolizeLoadCacheModifierKind(uint32_t);
::llvm::StringRef stringifyLoadCacheModifierKind(LoadCacheModifierKind);
::std::optional<LoadCacheModifierKind> symbolizeLoadCacheModifierKind(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForLoadCacheModifierKind() {
  return 4;
}


inline ::llvm::StringRef stringifyEnum(LoadCacheModifierKind enumValue) {
  return stringifyLoadCacheModifierKind(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<LoadCacheModifierKind> symbolizeEnum<LoadCacheModifierKind>(::llvm::StringRef str) {
  return symbolizeLoadCacheModifierKind(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::LoadCacheModifierKind, ::mlir::NVVM::LoadCacheModifierKind> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::LoadCacheModifierKind> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM load cache modifier kind");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::LoadCacheModifierKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::LoadCacheModifierKind>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM load cache modifier kind specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::LoadCacheModifierKind>, std::optional<::mlir::NVVM::LoadCacheModifierKind>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::LoadCacheModifierKind>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::LoadCacheModifierKind>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::LoadCacheModifierKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::LoadCacheModifierKind>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM load cache modifier kind specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::LoadCacheModifierKind value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::LoadCacheModifierKind> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::LoadCacheModifierKind getEmptyKey() {
    return static_cast<::mlir::NVVM::LoadCacheModifierKind>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::LoadCacheModifierKind getTombstoneKey() {
    return static_cast<::mlir::NVVM::LoadCacheModifierKind>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::LoadCacheModifierKind &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::LoadCacheModifierKind &lhs, const ::mlir::NVVM::LoadCacheModifierKind &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// MMA binary operations
enum class MMAB1Op : uint32_t {
  none = 0,
  xor_popc = 1,
  and_popc = 2,
};

::std::optional<MMAB1Op> symbolizeMMAB1Op(uint32_t);
::llvm::StringRef stringifyMMAB1Op(MMAB1Op);
::std::optional<MMAB1Op> symbolizeMMAB1Op(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForMMAB1Op() {
  return 2;
}


inline ::llvm::StringRef stringifyEnum(MMAB1Op enumValue) {
  return stringifyMMAB1Op(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<MMAB1Op> symbolizeEnum<MMAB1Op>(::llvm::StringRef str) {
  return symbolizeMMAB1Op(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::MMAB1Op, ::mlir::NVVM::MMAB1Op> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::MMAB1Op> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for MMA binary operations");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::MMAB1Op> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::MMAB1Op>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid MMA binary operations specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::MMAB1Op>, std::optional<::mlir::NVVM::MMAB1Op>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::MMAB1Op>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::MMAB1Op>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::MMAB1Op> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::MMAB1Op>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid MMA binary operations specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::MMAB1Op value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::MMAB1Op> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::MMAB1Op getEmptyKey() {
    return static_cast<::mlir::NVVM::MMAB1Op>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::MMAB1Op getTombstoneKey() {
    return static_cast<::mlir::NVVM::MMAB1Op>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::MMAB1Op &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::MMAB1Op &lhs, const ::mlir::NVVM::MMAB1Op &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM MMA frag type
enum class MMAFrag : uint32_t {
  a = 0,
  b = 1,
  c = 2,
};

::std::optional<MMAFrag> symbolizeMMAFrag(uint32_t);
::llvm::StringRef stringifyMMAFrag(MMAFrag);
::std::optional<MMAFrag> symbolizeMMAFrag(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForMMAFrag() {
  return 2;
}


inline ::llvm::StringRef stringifyEnum(MMAFrag enumValue) {
  return stringifyMMAFrag(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<MMAFrag> symbolizeEnum<MMAFrag>(::llvm::StringRef str) {
  return symbolizeMMAFrag(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::MMAFrag, ::mlir::NVVM::MMAFrag> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::MMAFrag> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM MMA frag type");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::MMAFrag> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::MMAFrag>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM MMA frag type specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::MMAFrag>, std::optional<::mlir::NVVM::MMAFrag>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::MMAFrag>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::MMAFrag>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::MMAFrag> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::MMAFrag>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM MMA frag type specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::MMAFrag value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::MMAFrag> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::MMAFrag getEmptyKey() {
    return static_cast<::mlir::NVVM::MMAFrag>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::MMAFrag getTombstoneKey() {
    return static_cast<::mlir::NVVM::MMAFrag>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::MMAFrag &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::MMAFrag &lhs, const ::mlir::NVVM::MMAFrag &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// MMA overflow options
enum class MMAIntOverflow : uint32_t {
  satfinite = 1,
  wrapped = 0,
};

::std::optional<MMAIntOverflow> symbolizeMMAIntOverflow(uint32_t);
::llvm::StringRef stringifyMMAIntOverflow(MMAIntOverflow);
::std::optional<MMAIntOverflow> symbolizeMMAIntOverflow(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForMMAIntOverflow() {
  return 1;
}


inline ::llvm::StringRef stringifyEnum(MMAIntOverflow enumValue) {
  return stringifyMMAIntOverflow(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<MMAIntOverflow> symbolizeEnum<MMAIntOverflow>(::llvm::StringRef str) {
  return symbolizeMMAIntOverflow(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::MMAIntOverflow, ::mlir::NVVM::MMAIntOverflow> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::MMAIntOverflow> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for MMA overflow options");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::MMAIntOverflow> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::MMAIntOverflow>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid MMA overflow options specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::MMAIntOverflow>, std::optional<::mlir::NVVM::MMAIntOverflow>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::MMAIntOverflow>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::MMAIntOverflow>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::MMAIntOverflow> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::MMAIntOverflow>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid MMA overflow options specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::MMAIntOverflow value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::MMAIntOverflow> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::MMAIntOverflow getEmptyKey() {
    return static_cast<::mlir::NVVM::MMAIntOverflow>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::MMAIntOverflow getTombstoneKey() {
    return static_cast<::mlir::NVVM::MMAIntOverflow>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::MMAIntOverflow &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::MMAIntOverflow &lhs, const ::mlir::NVVM::MMAIntOverflow &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM MMA layout
enum class MMALayout : uint32_t {
  row = 0,
  col = 1,
};

::std::optional<MMALayout> symbolizeMMALayout(uint32_t);
::llvm::StringRef stringifyMMALayout(MMALayout);
::std::optional<MMALayout> symbolizeMMALayout(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForMMALayout() {
  return 1;
}


inline ::llvm::StringRef stringifyEnum(MMALayout enumValue) {
  return stringifyMMALayout(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<MMALayout> symbolizeEnum<MMALayout>(::llvm::StringRef str) {
  return symbolizeMMALayout(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::MMALayout, ::mlir::NVVM::MMALayout> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::MMALayout> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM MMA layout");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::MMALayout> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::MMALayout>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM MMA layout specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::MMALayout>, std::optional<::mlir::NVVM::MMALayout>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::MMALayout>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::MMALayout>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::MMALayout> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::MMALayout>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM MMA layout specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::MMALayout value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::MMALayout> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::MMALayout getEmptyKey() {
    return static_cast<::mlir::NVVM::MMALayout>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::MMALayout getTombstoneKey() {
    return static_cast<::mlir::NVVM::MMALayout>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::MMALayout &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::MMALayout &lhs, const ::mlir::NVVM::MMALayout &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM MMA types
enum class MMATypes : uint32_t {
  f16 = 0,
  f32 = 1,
  tf32 = 2,
  bf16 = 9,
  s8 = 4,
  u8 = 3,
  s32 = 5,
  s4 = 8,
  u4 = 7,
  b1 = 6,
  f64 = 10,
};

::std::optional<MMATypes> symbolizeMMATypes(uint32_t);
::llvm::StringRef stringifyMMATypes(MMATypes);
::std::optional<MMATypes> symbolizeMMATypes(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForMMATypes() {
  return 10;
}


inline ::llvm::StringRef stringifyEnum(MMATypes enumValue) {
  return stringifyMMATypes(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<MMATypes> symbolizeEnum<MMATypes>(::llvm::StringRef str) {
  return symbolizeMMATypes(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::MMATypes, ::mlir::NVVM::MMATypes> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::MMATypes> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM MMA types");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::MMATypes> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::MMATypes>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM MMA types specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::MMATypes>, std::optional<::mlir::NVVM::MMATypes>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::MMATypes>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::MMATypes>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::MMATypes> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::MMATypes>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM MMA types specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::MMATypes value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::MMATypes> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::MMATypes getEmptyKey() {
    return static_cast<::mlir::NVVM::MMATypes>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::MMATypes getTombstoneKey() {
    return static_cast<::mlir::NVVM::MMATypes>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::MMATypes &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::MMATypes &lhs, const ::mlir::NVVM::MMATypes &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM Memory Scope kind
enum class MemScopeKind : uint32_t {
  CTA = 0,
  CLUSTER = 1,
  GPU = 2,
  SYS = 3,
};

::std::optional<MemScopeKind> symbolizeMemScopeKind(uint32_t);
::llvm::StringRef stringifyMemScopeKind(MemScopeKind);
::std::optional<MemScopeKind> symbolizeMemScopeKind(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForMemScopeKind() {
  return 3;
}


inline ::llvm::StringRef stringifyEnum(MemScopeKind enumValue) {
  return stringifyMemScopeKind(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<MemScopeKind> symbolizeEnum<MemScopeKind>(::llvm::StringRef str) {
  return symbolizeMemScopeKind(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::MemScopeKind, ::mlir::NVVM::MemScopeKind> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::MemScopeKind> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM Memory Scope kind");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::MemScopeKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::MemScopeKind>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM Memory Scope kind specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::MemScopeKind>, std::optional<::mlir::NVVM::MemScopeKind>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::MemScopeKind>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::MemScopeKind>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::MemScopeKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::MemScopeKind>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM Memory Scope kind specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::MemScopeKind value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::MemScopeKind> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::MemScopeKind getEmptyKey() {
    return static_cast<::mlir::NVVM::MemScopeKind>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::MemScopeKind getTombstoneKey() {
    return static_cast<::mlir::NVVM::MemScopeKind>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::MemScopeKind &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::MemScopeKind &lhs, const ::mlir::NVVM::MemScopeKind &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// Proxy kind
enum class ProxyKind : uint32_t {
  alias = 0,
  async = 1,
  async_global = 2,
  async_shared = 3,
  TENSORMAP = 4,
  GENERIC = 5,
};

::std::optional<ProxyKind> symbolizeProxyKind(uint32_t);
::llvm::StringRef stringifyProxyKind(ProxyKind);
::std::optional<ProxyKind> symbolizeProxyKind(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForProxyKind() {
  return 5;
}


inline ::llvm::StringRef stringifyEnum(ProxyKind enumValue) {
  return stringifyProxyKind(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<ProxyKind> symbolizeEnum<ProxyKind>(::llvm::StringRef str) {
  return symbolizeProxyKind(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::ProxyKind, ::mlir::NVVM::ProxyKind> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::ProxyKind> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for Proxy kind");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::ProxyKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::ProxyKind>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid Proxy kind specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::ProxyKind>, std::optional<::mlir::NVVM::ProxyKind>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::ProxyKind>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::ProxyKind>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::ProxyKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::ProxyKind>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid Proxy kind specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::ProxyKind value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::ProxyKind> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::ProxyKind getEmptyKey() {
    return static_cast<::mlir::NVVM::ProxyKind>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::ProxyKind getTombstoneKey() {
    return static_cast<::mlir::NVVM::ProxyKind>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::ProxyKind &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::ProxyKind &lhs, const ::mlir::NVVM::ProxyKind &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM redux kind
enum class ReduxKind : uint32_t {
  ADD = 1,
  AND = 2,
  MAX = 3,
  MIN = 4,
  OR = 5,
  UMAX = 6,
  UMIN = 7,
  XOR = 8,
};

::std::optional<ReduxKind> symbolizeReduxKind(uint32_t);
::llvm::StringRef stringifyReduxKind(ReduxKind);
::std::optional<ReduxKind> symbolizeReduxKind(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForReduxKind() {
  return 8;
}


inline ::llvm::StringRef stringifyEnum(ReduxKind enumValue) {
  return stringifyReduxKind(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<ReduxKind> symbolizeEnum<ReduxKind>(::llvm::StringRef str) {
  return symbolizeReduxKind(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::ReduxKind, ::mlir::NVVM::ReduxKind> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::ReduxKind> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM redux kind");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::ReduxKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::ReduxKind>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM redux kind specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::ReduxKind>, std::optional<::mlir::NVVM::ReduxKind>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::ReduxKind>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::ReduxKind>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::ReduxKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::ReduxKind>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM redux kind specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::ReduxKind value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::ReduxKind> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::ReduxKind getEmptyKey() {
    return static_cast<::mlir::NVVM::ReduxKind>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::ReduxKind getTombstoneKey() {
    return static_cast<::mlir::NVVM::ReduxKind>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::ReduxKind &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::ReduxKind &lhs, const ::mlir::NVVM::ReduxKind &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM SaturationMode kind
enum class SaturationMode : uint32_t {
  NONE = 0,
  SATFINITE = 1,
};

::std::optional<SaturationMode> symbolizeSaturationMode(uint32_t);
::llvm::StringRef stringifySaturationMode(SaturationMode);
::std::optional<SaturationMode> symbolizeSaturationMode(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForSaturationMode() {
  return 1;
}


inline ::llvm::StringRef stringifyEnum(SaturationMode enumValue) {
  return stringifySaturationMode(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<SaturationMode> symbolizeEnum<SaturationMode>(::llvm::StringRef str) {
  return symbolizeSaturationMode(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::SaturationMode, ::mlir::NVVM::SaturationMode> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::SaturationMode> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM SaturationMode kind");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::SaturationMode> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::SaturationMode>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM SaturationMode kind specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::SaturationMode>, std::optional<::mlir::NVVM::SaturationMode>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::SaturationMode>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::SaturationMode>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::SaturationMode> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::SaturationMode>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM SaturationMode kind specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::SaturationMode value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::SaturationMode> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::SaturationMode getEmptyKey() {
    return static_cast<::mlir::NVVM::SaturationMode>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::SaturationMode getTombstoneKey() {
    return static_cast<::mlir::NVVM::SaturationMode>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::SaturationMode &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::SaturationMode &lhs, const ::mlir::NVVM::SaturationMode &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM set max register action
enum class SetMaxRegisterAction : uint32_t {
  decrease = 1,
  increase = 0,
};

::std::optional<SetMaxRegisterAction> symbolizeSetMaxRegisterAction(uint32_t);
::llvm::StringRef stringifySetMaxRegisterAction(SetMaxRegisterAction);
::std::optional<SetMaxRegisterAction> symbolizeSetMaxRegisterAction(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForSetMaxRegisterAction() {
  return 1;
}


inline ::llvm::StringRef stringifyEnum(SetMaxRegisterAction enumValue) {
  return stringifySetMaxRegisterAction(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<SetMaxRegisterAction> symbolizeEnum<SetMaxRegisterAction>(::llvm::StringRef str) {
  return symbolizeSetMaxRegisterAction(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::SetMaxRegisterAction, ::mlir::NVVM::SetMaxRegisterAction> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::SetMaxRegisterAction> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM set max register action");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::SetMaxRegisterAction> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::SetMaxRegisterAction>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM set max register action specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::SetMaxRegisterAction>, std::optional<::mlir::NVVM::SetMaxRegisterAction>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::SetMaxRegisterAction>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::SetMaxRegisterAction>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::SetMaxRegisterAction> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::SetMaxRegisterAction>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM set max register action specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::SetMaxRegisterAction value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::SetMaxRegisterAction> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::SetMaxRegisterAction getEmptyKey() {
    return static_cast<::mlir::NVVM::SetMaxRegisterAction>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::SetMaxRegisterAction getTombstoneKey() {
    return static_cast<::mlir::NVVM::SetMaxRegisterAction>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::SetMaxRegisterAction &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::SetMaxRegisterAction &lhs, const ::mlir::NVVM::SetMaxRegisterAction &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// Shared memory space
enum class SharedSpace : uint32_t {
  shared_cta = 0,
  shared_cluster = 1,
};

::std::optional<SharedSpace> symbolizeSharedSpace(uint32_t);
::llvm::StringRef stringifySharedSpace(SharedSpace);
::std::optional<SharedSpace> symbolizeSharedSpace(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForSharedSpace() {
  return 1;
}


inline ::llvm::StringRef stringifyEnum(SharedSpace enumValue) {
  return stringifySharedSpace(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<SharedSpace> symbolizeEnum<SharedSpace>(::llvm::StringRef str) {
  return symbolizeSharedSpace(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::SharedSpace, ::mlir::NVVM::SharedSpace> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::SharedSpace> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for Shared memory space");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::SharedSpace> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::SharedSpace>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid Shared memory space specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::SharedSpace>, std::optional<::mlir::NVVM::SharedSpace>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::SharedSpace>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::SharedSpace>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::SharedSpace> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::SharedSpace>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid Shared memory space specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::SharedSpace value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::SharedSpace> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::SharedSpace getEmptyKey() {
    return static_cast<::mlir::NVVM::SharedSpace>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::SharedSpace getTombstoneKey() {
    return static_cast<::mlir::NVVM::SharedSpace>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::SharedSpace &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::SharedSpace &lhs, const ::mlir::NVVM::SharedSpace &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM shuffle kind
enum class ShflKind : uint32_t {
  bfly = 0,
  up = 1,
  down = 2,
  idx = 3,
};

::std::optional<ShflKind> symbolizeShflKind(uint32_t);
::llvm::StringRef stringifyShflKind(ShflKind);
::std::optional<ShflKind> symbolizeShflKind(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForShflKind() {
  return 3;
}


inline ::llvm::StringRef stringifyEnum(ShflKind enumValue) {
  return stringifyShflKind(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<ShflKind> symbolizeEnum<ShflKind>(::llvm::StringRef str) {
  return symbolizeShflKind(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::ShflKind, ::mlir::NVVM::ShflKind> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::ShflKind> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM shuffle kind");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::ShflKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::ShflKind>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM shuffle kind specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::ShflKind>, std::optional<::mlir::NVVM::ShflKind>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::ShflKind>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::ShflKind>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::ShflKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::ShflKind>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM shuffle kind specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::ShflKind value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::ShflKind> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::ShflKind getEmptyKey() {
    return static_cast<::mlir::NVVM::ShflKind>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::ShflKind getTombstoneKey() {
    return static_cast<::mlir::NVVM::ShflKind>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::ShflKind &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::ShflKind &lhs, const ::mlir::NVVM::ShflKind &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM TMA redux kind
enum class TMAReduxKind : uint32_t {
  ADD = 0,
  MAX = 2,
  MIN = 1,
  INC = 3,
  DEC = 4,
  AND = 5,
  OR = 6,
  XOR = 7,
};

::std::optional<TMAReduxKind> symbolizeTMAReduxKind(uint32_t);
::llvm::StringRef stringifyTMAReduxKind(TMAReduxKind);
::std::optional<TMAReduxKind> symbolizeTMAReduxKind(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForTMAReduxKind() {
  return 7;
}


inline ::llvm::StringRef stringifyEnum(TMAReduxKind enumValue) {
  return stringifyTMAReduxKind(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<TMAReduxKind> symbolizeEnum<TMAReduxKind>(::llvm::StringRef str) {
  return symbolizeTMAReduxKind(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::TMAReduxKind, ::mlir::NVVM::TMAReduxKind> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::TMAReduxKind> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM TMA redux kind");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::TMAReduxKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::TMAReduxKind>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM TMA redux kind specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::TMAReduxKind>, std::optional<::mlir::NVVM::TMAReduxKind>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::TMAReduxKind>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::TMAReduxKind>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::TMAReduxKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::TMAReduxKind>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM TMA redux kind specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::TMAReduxKind value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::TMAReduxKind> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::TMAReduxKind getEmptyKey() {
    return static_cast<::mlir::NVVM::TMAReduxKind>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::TMAReduxKind getTombstoneKey() {
    return static_cast<::mlir::NVVM::TMAReduxKind>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::TMAReduxKind &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::TMAReduxKind &lhs, const ::mlir::NVVM::TMAReduxKind &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM TMA Store Mode
enum class TMAStoreMode : uint32_t {
  TILE = 0,
  IM2COL = 1,
};

::std::optional<TMAStoreMode> symbolizeTMAStoreMode(uint32_t);
::llvm::StringRef stringifyTMAStoreMode(TMAStoreMode);
::std::optional<TMAStoreMode> symbolizeTMAStoreMode(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForTMAStoreMode() {
  return 1;
}


inline ::llvm::StringRef stringifyEnum(TMAStoreMode enumValue) {
  return stringifyTMAStoreMode(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<TMAStoreMode> symbolizeEnum<TMAStoreMode>(::llvm::StringRef str) {
  return symbolizeTMAStoreMode(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::TMAStoreMode, ::mlir::NVVM::TMAStoreMode> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::TMAStoreMode> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM TMA Store Mode");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::TMAStoreMode> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::TMAStoreMode>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM TMA Store Mode specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::TMAStoreMode>, std::optional<::mlir::NVVM::TMAStoreMode>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::TMAStoreMode>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::TMAStoreMode>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::TMAStoreMode> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::TMAStoreMode>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM TMA Store Mode specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::TMAStoreMode value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::TMAStoreMode> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::TMAStoreMode getEmptyKey() {
    return static_cast<::mlir::NVVM::TMAStoreMode>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::TMAStoreMode getTombstoneKey() {
    return static_cast<::mlir::NVVM::TMAStoreMode>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::TMAStoreMode &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::TMAStoreMode &lhs, const ::mlir::NVVM::TMAStoreMode &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// tcgen05 cp multicast
enum class Tcgen05CpMulticast : uint32_t {
  NONE = 0,
  WARPX2_02_13 = 1,
  WARPX2_01_23 = 2,
  WARPX4 = 3,
};

::std::optional<Tcgen05CpMulticast> symbolizeTcgen05CpMulticast(uint32_t);
::llvm::StringRef stringifyTcgen05CpMulticast(Tcgen05CpMulticast);
::std::optional<Tcgen05CpMulticast> symbolizeTcgen05CpMulticast(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForTcgen05CpMulticast() {
  return 3;
}


inline ::llvm::StringRef stringifyEnum(Tcgen05CpMulticast enumValue) {
  return stringifyTcgen05CpMulticast(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<Tcgen05CpMulticast> symbolizeEnum<Tcgen05CpMulticast>(::llvm::StringRef str) {
  return symbolizeTcgen05CpMulticast(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::Tcgen05CpMulticast, ::mlir::NVVM::Tcgen05CpMulticast> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::Tcgen05CpMulticast> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for tcgen05 cp multicast");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::Tcgen05CpMulticast> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::Tcgen05CpMulticast>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid tcgen05 cp multicast specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::Tcgen05CpMulticast>, std::optional<::mlir::NVVM::Tcgen05CpMulticast>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::Tcgen05CpMulticast>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::Tcgen05CpMulticast>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::Tcgen05CpMulticast> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::Tcgen05CpMulticast>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid tcgen05 cp multicast specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::Tcgen05CpMulticast value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::Tcgen05CpMulticast> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::Tcgen05CpMulticast getEmptyKey() {
    return static_cast<::mlir::NVVM::Tcgen05CpMulticast>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::Tcgen05CpMulticast getTombstoneKey() {
    return static_cast<::mlir::NVVM::Tcgen05CpMulticast>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::Tcgen05CpMulticast &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::Tcgen05CpMulticast &lhs, const ::mlir::NVVM::Tcgen05CpMulticast &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// tcgen05 cp shapes
enum class Tcgen05CpShape : uint32_t {
  SHAPE_128x256b = 0,
  SHAPE_4x256b = 1,
  SHAPE_128x128b = 2,
  SHAPE_64x128b = 3,
  SHAPE_32x128b = 4,
};

::std::optional<Tcgen05CpShape> symbolizeTcgen05CpShape(uint32_t);
::llvm::StringRef stringifyTcgen05CpShape(Tcgen05CpShape);
::std::optional<Tcgen05CpShape> symbolizeTcgen05CpShape(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForTcgen05CpShape() {
  return 4;
}


inline ::llvm::StringRef stringifyEnum(Tcgen05CpShape enumValue) {
  return stringifyTcgen05CpShape(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<Tcgen05CpShape> symbolizeEnum<Tcgen05CpShape>(::llvm::StringRef str) {
  return symbolizeTcgen05CpShape(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::Tcgen05CpShape, ::mlir::NVVM::Tcgen05CpShape> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::Tcgen05CpShape> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for tcgen05 cp shapes");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::Tcgen05CpShape> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::Tcgen05CpShape>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid tcgen05 cp shapes specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::Tcgen05CpShape>, std::optional<::mlir::NVVM::Tcgen05CpShape>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::Tcgen05CpShape>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::Tcgen05CpShape>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::Tcgen05CpShape> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::Tcgen05CpShape>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid tcgen05 cp shapes specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::Tcgen05CpShape value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::Tcgen05CpShape> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::Tcgen05CpShape getEmptyKey() {
    return static_cast<::mlir::NVVM::Tcgen05CpShape>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::Tcgen05CpShape getTombstoneKey() {
    return static_cast<::mlir::NVVM::Tcgen05CpShape>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::Tcgen05CpShape &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::Tcgen05CpShape &lhs, const ::mlir::NVVM::Tcgen05CpShape &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// tcgen05 cp source format
enum class Tcgen05CpSrcFormat : uint32_t {
  B6x16_P32 = 0,
  B4x16_P64 = 1,
};

::std::optional<Tcgen05CpSrcFormat> symbolizeTcgen05CpSrcFormat(uint32_t);
::llvm::StringRef stringifyTcgen05CpSrcFormat(Tcgen05CpSrcFormat);
::std::optional<Tcgen05CpSrcFormat> symbolizeTcgen05CpSrcFormat(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForTcgen05CpSrcFormat() {
  return 1;
}


inline ::llvm::StringRef stringifyEnum(Tcgen05CpSrcFormat enumValue) {
  return stringifyTcgen05CpSrcFormat(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<Tcgen05CpSrcFormat> symbolizeEnum<Tcgen05CpSrcFormat>(::llvm::StringRef str) {
  return symbolizeTcgen05CpSrcFormat(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::Tcgen05CpSrcFormat, ::mlir::NVVM::Tcgen05CpSrcFormat> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::Tcgen05CpSrcFormat> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for tcgen05 cp source format");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::Tcgen05CpSrcFormat> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::Tcgen05CpSrcFormat>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid tcgen05 cp source format specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::Tcgen05CpSrcFormat>, std::optional<::mlir::NVVM::Tcgen05CpSrcFormat>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::Tcgen05CpSrcFormat>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::Tcgen05CpSrcFormat>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::Tcgen05CpSrcFormat> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::Tcgen05CpSrcFormat>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid tcgen05 cp source format specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::Tcgen05CpSrcFormat value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::Tcgen05CpSrcFormat> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::Tcgen05CpSrcFormat getEmptyKey() {
    return static_cast<::mlir::NVVM::Tcgen05CpSrcFormat>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::Tcgen05CpSrcFormat getTombstoneKey() {
    return static_cast<::mlir::NVVM::Tcgen05CpSrcFormat>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::Tcgen05CpSrcFormat &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::Tcgen05CpSrcFormat &lhs, const ::mlir::NVVM::Tcgen05CpSrcFormat &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM Tcgen05 fence kind
enum class Tcgen05FenceKind : uint32_t {
  BEFORE_THREAD_SYNC = 0,
  AFTER_THREAD_SYNC = 1,
};

::std::optional<Tcgen05FenceKind> symbolizeTcgen05FenceKind(uint32_t);
::llvm::StringRef stringifyTcgen05FenceKind(Tcgen05FenceKind);
::std::optional<Tcgen05FenceKind> symbolizeTcgen05FenceKind(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForTcgen05FenceKind() {
  return 1;
}


inline ::llvm::StringRef stringifyEnum(Tcgen05FenceKind enumValue) {
  return stringifyTcgen05FenceKind(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<Tcgen05FenceKind> symbolizeEnum<Tcgen05FenceKind>(::llvm::StringRef str) {
  return symbolizeTcgen05FenceKind(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::Tcgen05FenceKind, ::mlir::NVVM::Tcgen05FenceKind> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::Tcgen05FenceKind> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM Tcgen05 fence kind");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::Tcgen05FenceKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::Tcgen05FenceKind>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM Tcgen05 fence kind specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::Tcgen05FenceKind>, std::optional<::mlir::NVVM::Tcgen05FenceKind>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::Tcgen05FenceKind>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::Tcgen05FenceKind>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::Tcgen05FenceKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::Tcgen05FenceKind>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM Tcgen05 fence kind specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::Tcgen05FenceKind value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::Tcgen05FenceKind> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::Tcgen05FenceKind getEmptyKey() {
    return static_cast<::mlir::NVVM::Tcgen05FenceKind>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::Tcgen05FenceKind getTombstoneKey() {
    return static_cast<::mlir::NVVM::Tcgen05FenceKind>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::Tcgen05FenceKind &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::Tcgen05FenceKind &lhs, const ::mlir::NVVM::Tcgen05FenceKind &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM Tcgen05 group kind
enum class Tcgen05GroupKind : uint32_t {
  CTA_1 = 0,
  CTA_2 = 1,
};

::std::optional<Tcgen05GroupKind> symbolizeTcgen05GroupKind(uint32_t);
::llvm::StringRef stringifyTcgen05GroupKind(Tcgen05GroupKind);
::std::optional<Tcgen05GroupKind> symbolizeTcgen05GroupKind(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForTcgen05GroupKind() {
  return 1;
}


inline ::llvm::StringRef stringifyEnum(Tcgen05GroupKind enumValue) {
  return stringifyTcgen05GroupKind(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<Tcgen05GroupKind> symbolizeEnum<Tcgen05GroupKind>(::llvm::StringRef str) {
  return symbolizeTcgen05GroupKind(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::Tcgen05GroupKind, ::mlir::NVVM::Tcgen05GroupKind> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::Tcgen05GroupKind> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM Tcgen05 group kind");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::Tcgen05GroupKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::Tcgen05GroupKind>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM Tcgen05 group kind specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::Tcgen05GroupKind>, std::optional<::mlir::NVVM::Tcgen05GroupKind>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::Tcgen05GroupKind>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::Tcgen05GroupKind>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::Tcgen05GroupKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::Tcgen05GroupKind>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM Tcgen05 group kind specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::Tcgen05GroupKind value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::Tcgen05GroupKind> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::Tcgen05GroupKind getEmptyKey() {
    return static_cast<::mlir::NVVM::Tcgen05GroupKind>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::Tcgen05GroupKind getTombstoneKey() {
    return static_cast<::mlir::NVVM::Tcgen05GroupKind>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::Tcgen05GroupKind &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::Tcgen05GroupKind &lhs, const ::mlir::NVVM::Tcgen05GroupKind &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM Tcgen05 wait kind
enum class Tcgen05WaitKind : uint32_t {
  LOAD = 0,
  STORE = 1,
};

::std::optional<Tcgen05WaitKind> symbolizeTcgen05WaitKind(uint32_t);
::llvm::StringRef stringifyTcgen05WaitKind(Tcgen05WaitKind);
::std::optional<Tcgen05WaitKind> symbolizeTcgen05WaitKind(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForTcgen05WaitKind() {
  return 1;
}


inline ::llvm::StringRef stringifyEnum(Tcgen05WaitKind enumValue) {
  return stringifyTcgen05WaitKind(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<Tcgen05WaitKind> symbolizeEnum<Tcgen05WaitKind>(::llvm::StringRef str) {
  return symbolizeTcgen05WaitKind(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::Tcgen05WaitKind, ::mlir::NVVM::Tcgen05WaitKind> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::Tcgen05WaitKind> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM Tcgen05 wait kind");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::Tcgen05WaitKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::Tcgen05WaitKind>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM Tcgen05 wait kind specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::Tcgen05WaitKind>, std::optional<::mlir::NVVM::Tcgen05WaitKind>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::Tcgen05WaitKind>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::Tcgen05WaitKind>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::Tcgen05WaitKind> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::Tcgen05WaitKind>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM Tcgen05 wait kind specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::Tcgen05WaitKind value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::Tcgen05WaitKind> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::Tcgen05WaitKind getEmptyKey() {
    return static_cast<::mlir::NVVM::Tcgen05WaitKind>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::Tcgen05WaitKind getTombstoneKey() {
    return static_cast<::mlir::NVVM::Tcgen05WaitKind>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::Tcgen05WaitKind &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::Tcgen05WaitKind &lhs, const ::mlir::NVVM::Tcgen05WaitKind &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// WGMMA overflow options
enum class WGMMAScaleIn : uint32_t {
  one = 1,
  neg,
};

::llvm::StringRef stringifyWGMMAScaleIn(WGMMAScaleIn);
::std::optional<WGMMAScaleIn> symbolizeWGMMAScaleIn(::llvm::StringRef);

inline ::llvm::StringRef stringifyEnum(WGMMAScaleIn enumValue) {
  return stringifyWGMMAScaleIn(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<WGMMAScaleIn> symbolizeEnum<WGMMAScaleIn>(::llvm::StringRef str) {
  return symbolizeWGMMAScaleIn(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::WGMMAScaleIn, ::mlir::NVVM::WGMMAScaleIn> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::WGMMAScaleIn> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for WGMMA overflow options");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::WGMMAScaleIn> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::WGMMAScaleIn>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid WGMMA overflow options specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::WGMMAScaleIn>, std::optional<::mlir::NVVM::WGMMAScaleIn>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::WGMMAScaleIn>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::WGMMAScaleIn>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::WGMMAScaleIn> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::WGMMAScaleIn>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid WGMMA overflow options specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::WGMMAScaleIn value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::WGMMAScaleIn> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::WGMMAScaleIn getEmptyKey() {
    return static_cast<::mlir::NVVM::WGMMAScaleIn>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::WGMMAScaleIn getTombstoneKey() {
    return static_cast<::mlir::NVVM::WGMMAScaleIn>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::WGMMAScaleIn &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::WGMMAScaleIn &lhs, const ::mlir::NVVM::WGMMAScaleIn &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// WGMMA input predicate
enum class WGMMAScaleOut : uint32_t {
  zero = 0,
  one = 1,
};

::std::optional<WGMMAScaleOut> symbolizeWGMMAScaleOut(uint32_t);
::llvm::StringRef stringifyWGMMAScaleOut(WGMMAScaleOut);
::std::optional<WGMMAScaleOut> symbolizeWGMMAScaleOut(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForWGMMAScaleOut() {
  return 1;
}


inline ::llvm::StringRef stringifyEnum(WGMMAScaleOut enumValue) {
  return stringifyWGMMAScaleOut(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<WGMMAScaleOut> symbolizeEnum<WGMMAScaleOut>(::llvm::StringRef str) {
  return symbolizeWGMMAScaleOut(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::WGMMAScaleOut, ::mlir::NVVM::WGMMAScaleOut> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::WGMMAScaleOut> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for WGMMA input predicate");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::WGMMAScaleOut> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::WGMMAScaleOut>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid WGMMA input predicate specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::WGMMAScaleOut>, std::optional<::mlir::NVVM::WGMMAScaleOut>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::WGMMAScaleOut>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::WGMMAScaleOut>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::WGMMAScaleOut> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::WGMMAScaleOut>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid WGMMA input predicate specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::WGMMAScaleOut value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::WGMMAScaleOut> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::WGMMAScaleOut getEmptyKey() {
    return static_cast<::mlir::NVVM::WGMMAScaleOut>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::WGMMAScaleOut getTombstoneKey() {
    return static_cast<::mlir::NVVM::WGMMAScaleOut>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::WGMMAScaleOut &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::WGMMAScaleOut &lhs, const ::mlir::NVVM::WGMMAScaleOut &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace NVVM {
// NVVM WGMMA types
enum class WGMMATypes : uint32_t {
  f16 = 0,
  tf32 = 1,
  u8 = 2,
  s8 = 3,
  b1 = 4,
  bf16 = 5,
  e4m3 = 6,
  e5m2 = 7,
  f32 = 8,
  s32 = 9,
};

::std::optional<WGMMATypes> symbolizeWGMMATypes(uint32_t);
::llvm::StringRef stringifyWGMMATypes(WGMMATypes);
::std::optional<WGMMATypes> symbolizeWGMMATypes(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForWGMMATypes() {
  return 9;
}


inline ::llvm::StringRef stringifyEnum(WGMMATypes enumValue) {
  return stringifyWGMMATypes(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<WGMMATypes> symbolizeEnum<WGMMATypes>(::llvm::StringRef str) {
  return symbolizeWGMMATypes(str);
}
} // namespace NVVM
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::NVVM::WGMMATypes, ::mlir::NVVM::WGMMATypes> {
  template <typename ParserT>
  static FailureOr<::mlir::NVVM::WGMMATypes> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for NVVM WGMMA types");

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::WGMMATypes> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::WGMMATypes>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid NVVM WGMMA types specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::NVVM::WGMMATypes>, std::optional<::mlir::NVVM::WGMMATypes>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::NVVM::WGMMATypes>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::NVVM::WGMMATypes>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::NVVM::WGMMATypes> attr = ::mlir::NVVM::symbolizeEnum<::mlir::NVVM::WGMMATypes>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid NVVM WGMMA types specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::NVVM::WGMMATypes value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::NVVM::WGMMATypes> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::NVVM::WGMMATypes getEmptyKey() {
    return static_cast<::mlir::NVVM::WGMMATypes>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::NVVM::WGMMATypes getTombstoneKey() {
    return static_cast<::mlir::NVVM::WGMMATypes>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::NVVM::WGMMATypes &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::NVVM::WGMMATypes &lhs, const ::mlir::NVVM::WGMMATypes &rhs) {
    return lhs == rhs;
  }
};
}

