/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_BUFFERDEALLOCATIONSIMPLIFICATION
#define GEN_PASS_DECL_BUFFERHOISTING
#define GEN_PASS_DECL_BUFFERLOOPHOISTING
#define GEN_PASS_DECL_BUFFERRESULTSTOOUTPARAMS
#define GEN_PASS_DECL_DROPEQUIVALENTBUFFERRESULTS
#define GEN_PASS_DECL_EMPTYTENSORELIMINATION
#define GEN_PASS_DECL_EMPTYTENSORTOALLOCTENSOR
#define GEN_PASS_DECL_LOWERDEALLOCATIONS
#define GEN_PASS_DECL_ONESHOTBUFFERIZE
#define GEN_PASS_DECL_OPTIMIZEALLOCATIONLIVENESS
#define GEN_PASS_DECL_OWNERSHIPBASEDBUFFERDEALLOCATION
#define GEN_PASS_DECL_PROMOTEBUFFERSTOSTACK
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// BufferDeallocationSimplification
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_BUFFERDEALLOCATIONSIMPLIFICATION
#undef GEN_PASS_DECL_BUFFERDEALLOCATIONSIMPLIFICATION
#endif // GEN_PASS_DECL_BUFFERDEALLOCATIONSIMPLIFICATION
#ifdef GEN_PASS_DEF_BUFFERDEALLOCATIONSIMPLIFICATION
namespace impl {

template <typename DerivedT>
class BufferDeallocationSimplificationBase : public ::mlir::OperationPass<> {
public:
  using Base = BufferDeallocationSimplificationBase;

  BufferDeallocationSimplificationBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  BufferDeallocationSimplificationBase(const BufferDeallocationSimplificationBase &other) : ::mlir::OperationPass<>(other) {}
  BufferDeallocationSimplificationBase& operator=(const BufferDeallocationSimplificationBase &) = delete;
  BufferDeallocationSimplificationBase(BufferDeallocationSimplificationBase &&) = delete;
  BufferDeallocationSimplificationBase& operator=(BufferDeallocationSimplificationBase &&) = delete;
  ~BufferDeallocationSimplificationBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-deallocation-simplification");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-deallocation-simplification"; }

  ::llvm::StringRef getDescription() const override { return "Optimizes `bufferization.dealloc` operation for more efficient codegen"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferDeallocationSimplification");
  }
  ::llvm::StringRef getName() const override { return "BufferDeallocationSimplification"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::bufferization::BufferizationDialect>();
    registry.insert<mlir::arith::ArithDialect>();
    registry.insert<mlir::memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferDeallocationSimplificationBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_BUFFERDEALLOCATIONSIMPLIFICATION
#endif // GEN_PASS_DEF_BUFFERDEALLOCATIONSIMPLIFICATION

//===----------------------------------------------------------------------===//
// BufferHoisting
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_BUFFERHOISTING
#undef GEN_PASS_DECL_BUFFERHOISTING
#endif // GEN_PASS_DECL_BUFFERHOISTING
#ifdef GEN_PASS_DEF_BUFFERHOISTING
namespace impl {

template <typename DerivedT>
class BufferHoistingBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = BufferHoistingBase;

  BufferHoistingBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  BufferHoistingBase(const BufferHoistingBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}
  BufferHoistingBase& operator=(const BufferHoistingBase &) = delete;
  BufferHoistingBase(BufferHoistingBase &&) = delete;
  BufferHoistingBase& operator=(BufferHoistingBase &&) = delete;
  ~BufferHoistingBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-hoisting");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-hoisting"; }

  ::llvm::StringRef getDescription() const override { return "Optimizes placement of allocation operations by moving them into common dominators and out of nested regions"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferHoisting");
  }
  ::llvm::StringRef getName() const override { return "BufferHoisting"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferHoistingBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_BUFFERHOISTING
#endif // GEN_PASS_DEF_BUFFERHOISTING

//===----------------------------------------------------------------------===//
// BufferLoopHoisting
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_BUFFERLOOPHOISTING
#undef GEN_PASS_DECL_BUFFERLOOPHOISTING
#endif // GEN_PASS_DECL_BUFFERLOOPHOISTING
#ifdef GEN_PASS_DEF_BUFFERLOOPHOISTING
namespace impl {

template <typename DerivedT>
class BufferLoopHoistingBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = BufferLoopHoistingBase;

  BufferLoopHoistingBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  BufferLoopHoistingBase(const BufferLoopHoistingBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}
  BufferLoopHoistingBase& operator=(const BufferLoopHoistingBase &) = delete;
  BufferLoopHoistingBase(BufferLoopHoistingBase &&) = delete;
  BufferLoopHoistingBase& operator=(BufferLoopHoistingBase &&) = delete;
  ~BufferLoopHoistingBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-loop-hoisting");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-loop-hoisting"; }

  ::llvm::StringRef getDescription() const override { return "Optimizes placement of allocation operations by moving them out of loop nests"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferLoopHoisting");
  }
  ::llvm::StringRef getName() const override { return "BufferLoopHoisting"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferLoopHoistingBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_BUFFERLOOPHOISTING
#endif // GEN_PASS_DEF_BUFFERLOOPHOISTING

//===----------------------------------------------------------------------===//
// BufferResultsToOutParams
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_BUFFERRESULTSTOOUTPARAMS
struct BufferResultsToOutParamsOptions {
  bool addResultAttribute = false;
  bool hoistStaticAllocs = false;
};
#undef GEN_PASS_DECL_BUFFERRESULTSTOOUTPARAMS
#endif // GEN_PASS_DECL_BUFFERRESULTSTOOUTPARAMS
#ifdef GEN_PASS_DEF_BUFFERRESULTSTOOUTPARAMS
namespace impl {

template <typename DerivedT>
class BufferResultsToOutParamsBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = BufferResultsToOutParamsBase;

  BufferResultsToOutParamsBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  BufferResultsToOutParamsBase(const BufferResultsToOutParamsBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  BufferResultsToOutParamsBase& operator=(const BufferResultsToOutParamsBase &) = delete;
  BufferResultsToOutParamsBase(BufferResultsToOutParamsBase &&) = delete;
  BufferResultsToOutParamsBase& operator=(BufferResultsToOutParamsBase &&) = delete;
  ~BufferResultsToOutParamsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-results-to-out-params");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-results-to-out-params"; }

  ::llvm::StringRef getDescription() const override { return "Converts memref-typed function results to out-params"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferResultsToOutParams");
  }
  ::llvm::StringRef getName() const override { return "BufferResultsToOutParams"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferResultsToOutParamsBase<DerivedT>)

  BufferResultsToOutParamsBase(BufferResultsToOutParamsOptions options) : BufferResultsToOutParamsBase() {
    addResultAttribute = std::move(options.addResultAttribute);
    hoistStaticAllocs = std::move(options.hoistStaticAllocs);
  }
protected:
  ::mlir::Pass::Option<bool> addResultAttribute{*this, "add-result-attr", ::llvm::cl::desc("Add the attribute 'bufferize.result' to all output parameters."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> hoistStaticAllocs{*this, "hoist-static-allocs", ::llvm::cl::desc("Hoist static allocations to call sites."), ::llvm::cl::init(false)};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_BUFFERRESULTSTOOUTPARAMS
#endif // GEN_PASS_DEF_BUFFERRESULTSTOOUTPARAMS

//===----------------------------------------------------------------------===//
// DropEquivalentBufferResults
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_DROPEQUIVALENTBUFFERRESULTS
#undef GEN_PASS_DECL_DROPEQUIVALENTBUFFERRESULTS
#endif // GEN_PASS_DECL_DROPEQUIVALENTBUFFERRESULTS
#ifdef GEN_PASS_DEF_DROPEQUIVALENTBUFFERRESULTS
namespace impl {

template <typename DerivedT>
class DropEquivalentBufferResultsBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = DropEquivalentBufferResultsBase;

  DropEquivalentBufferResultsBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  DropEquivalentBufferResultsBase(const DropEquivalentBufferResultsBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  DropEquivalentBufferResultsBase& operator=(const DropEquivalentBufferResultsBase &) = delete;
  DropEquivalentBufferResultsBase(DropEquivalentBufferResultsBase &&) = delete;
  DropEquivalentBufferResultsBase& operator=(DropEquivalentBufferResultsBase &&) = delete;
  ~DropEquivalentBufferResultsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("drop-equivalent-buffer-results");
  }
  ::llvm::StringRef getArgument() const override { return "drop-equivalent-buffer-results"; }

  ::llvm::StringRef getDescription() const override { return "Remove MemRef return values that are equivalent to a bbArg"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("DropEquivalentBufferResults");
  }
  ::llvm::StringRef getName() const override { return "DropEquivalentBufferResults"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(DropEquivalentBufferResultsBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_DROPEQUIVALENTBUFFERRESULTS
#endif // GEN_PASS_DEF_DROPEQUIVALENTBUFFERRESULTS

//===----------------------------------------------------------------------===//
// EmptyTensorElimination
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_EMPTYTENSORELIMINATION
#undef GEN_PASS_DECL_EMPTYTENSORELIMINATION
#endif // GEN_PASS_DECL_EMPTYTENSORELIMINATION
#ifdef GEN_PASS_DEF_EMPTYTENSORELIMINATION
namespace impl {

template <typename DerivedT>
class EmptyTensorEliminationBase : public ::mlir::OperationPass<> {
public:
  using Base = EmptyTensorEliminationBase;

  EmptyTensorEliminationBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  EmptyTensorEliminationBase(const EmptyTensorEliminationBase &other) : ::mlir::OperationPass<>(other) {}
  EmptyTensorEliminationBase& operator=(const EmptyTensorEliminationBase &) = delete;
  EmptyTensorEliminationBase(EmptyTensorEliminationBase &&) = delete;
  EmptyTensorEliminationBase& operator=(EmptyTensorEliminationBase &&) = delete;
  ~EmptyTensorEliminationBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("eliminate-empty-tensors");
  }
  ::llvm::StringRef getArgument() const override { return "eliminate-empty-tensors"; }

  ::llvm::StringRef getDescription() const override { return "Try to eliminate all tensor.empty ops."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("EmptyTensorElimination");
  }
  ::llvm::StringRef getName() const override { return "EmptyTensorElimination"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(EmptyTensorEliminationBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_EMPTYTENSORELIMINATION
#endif // GEN_PASS_DEF_EMPTYTENSORELIMINATION

//===----------------------------------------------------------------------===//
// EmptyTensorToAllocTensor
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_EMPTYTENSORTOALLOCTENSOR
#undef GEN_PASS_DECL_EMPTYTENSORTOALLOCTENSOR
#endif // GEN_PASS_DECL_EMPTYTENSORTOALLOCTENSOR
#ifdef GEN_PASS_DEF_EMPTYTENSORTOALLOCTENSOR
namespace impl {

template <typename DerivedT>
class EmptyTensorToAllocTensorBase : public ::mlir::OperationPass<> {
public:
  using Base = EmptyTensorToAllocTensorBase;

  EmptyTensorToAllocTensorBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  EmptyTensorToAllocTensorBase(const EmptyTensorToAllocTensorBase &other) : ::mlir::OperationPass<>(other) {}
  EmptyTensorToAllocTensorBase& operator=(const EmptyTensorToAllocTensorBase &) = delete;
  EmptyTensorToAllocTensorBase(EmptyTensorToAllocTensorBase &&) = delete;
  EmptyTensorToAllocTensorBase& operator=(EmptyTensorToAllocTensorBase &&) = delete;
  ~EmptyTensorToAllocTensorBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("empty-tensor-to-alloc-tensor");
  }
  ::llvm::StringRef getArgument() const override { return "empty-tensor-to-alloc-tensor"; }

  ::llvm::StringRef getDescription() const override { return "Replace all empty ops by alloc_tensor ops."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("EmptyTensorToAllocTensor");
  }
  ::llvm::StringRef getName() const override { return "EmptyTensorToAllocTensor"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<tensor::TensorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(EmptyTensorToAllocTensorBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_EMPTYTENSORTOALLOCTENSOR
#endif // GEN_PASS_DEF_EMPTYTENSORTOALLOCTENSOR

//===----------------------------------------------------------------------===//
// LowerDeallocations
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_LOWERDEALLOCATIONS
#undef GEN_PASS_DECL_LOWERDEALLOCATIONS
#endif // GEN_PASS_DECL_LOWERDEALLOCATIONS
#ifdef GEN_PASS_DEF_LOWERDEALLOCATIONS
namespace impl {

template <typename DerivedT>
class LowerDeallocationsBase : public ::mlir::OperationPass<> {
public:
  using Base = LowerDeallocationsBase;

  LowerDeallocationsBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  LowerDeallocationsBase(const LowerDeallocationsBase &other) : ::mlir::OperationPass<>(other) {}
  LowerDeallocationsBase& operator=(const LowerDeallocationsBase &) = delete;
  LowerDeallocationsBase(LowerDeallocationsBase &&) = delete;
  LowerDeallocationsBase& operator=(LowerDeallocationsBase &&) = delete;
  ~LowerDeallocationsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("bufferization-lower-deallocations");
  }
  ::llvm::StringRef getArgument() const override { return "bufferization-lower-deallocations"; }

  ::llvm::StringRef getDescription() const override { return "Lowers `bufferization.dealloc` operations to `memref.dealloc`operations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LowerDeallocations");
  }
  ::llvm::StringRef getName() const override { return "LowerDeallocations"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<arith::ArithDialect>();
    registry.insert<memref::MemRefDialect>();
    registry.insert<scf::SCFDialect>();
    registry.insert<func::FuncDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LowerDeallocationsBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_LOWERDEALLOCATIONS
#endif // GEN_PASS_DEF_LOWERDEALLOCATIONS

//===----------------------------------------------------------------------===//
// OneShotBufferize
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ONESHOTBUFFERIZE
struct OneShotBufferizeOptions {
  bool allowReturnAllocsFromLoops = false;
  bool allowUnknownOps = false;
  unsigned analysisFuzzerSeed = 0;
  std::string analysisHeuristic = "bottom-up";
  bool bufferizeFunctionBoundaries = 0;
  bool checkParallelRegions = true;
  bool copyBeforeWrite = false;
  ::llvm::SmallVector<std::string> dialectFilter;
  bool dumpAliasSets = false;
  ::llvm::SmallVector<std::string> noAnalysisFuncFilter;
  std::string functionBoundaryTypeConversion = "infer-layout-map";
  bool mustInferMemorySpace = false;
  bool useEncodingForMemorySpace = false;
  bool testAnalysisOnly = false;
  bool printConflicts = false;
  std::string unknownTypeConversion = "fully-dynamic-layout-map";
  uint64_t bufferAlignment = 64;
};
#undef GEN_PASS_DECL_ONESHOTBUFFERIZE
#endif // GEN_PASS_DECL_ONESHOTBUFFERIZE
#ifdef GEN_PASS_DEF_ONESHOTBUFFERIZE
namespace impl {

template <typename DerivedT>
class OneShotBufferizeBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = OneShotBufferizeBase;

  OneShotBufferizeBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  OneShotBufferizeBase(const OneShotBufferizeBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  OneShotBufferizeBase& operator=(const OneShotBufferizeBase &) = delete;
  OneShotBufferizeBase(OneShotBufferizeBase &&) = delete;
  OneShotBufferizeBase& operator=(OneShotBufferizeBase &&) = delete;
  ~OneShotBufferizeBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("one-shot-bufferize");
  }
  ::llvm::StringRef getArgument() const override { return "one-shot-bufferize"; }

  ::llvm::StringRef getDescription() const override { return "One-Shot Bufferize"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OneShotBufferize");
  }
  ::llvm::StringRef getName() const override { return "OneShotBufferize"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OneShotBufferizeBase<DerivedT>)

  OneShotBufferizeBase(OneShotBufferizeOptions options) : OneShotBufferizeBase() {
    allowReturnAllocsFromLoops = std::move(options.allowReturnAllocsFromLoops);
    allowUnknownOps = std::move(options.allowUnknownOps);
    analysisFuzzerSeed = std::move(options.analysisFuzzerSeed);
    analysisHeuristic = std::move(options.analysisHeuristic);
    bufferizeFunctionBoundaries = std::move(options.bufferizeFunctionBoundaries);
    checkParallelRegions = std::move(options.checkParallelRegions);
    copyBeforeWrite = std::move(options.copyBeforeWrite);
    dialectFilter = std::move(options.dialectFilter);
    dumpAliasSets = std::move(options.dumpAliasSets);
    noAnalysisFuncFilter = std::move(options.noAnalysisFuncFilter);
    functionBoundaryTypeConversion = std::move(options.functionBoundaryTypeConversion);
    mustInferMemorySpace = std::move(options.mustInferMemorySpace);
    useEncodingForMemorySpace = std::move(options.useEncodingForMemorySpace);
    testAnalysisOnly = std::move(options.testAnalysisOnly);
    printConflicts = std::move(options.printConflicts);
    unknownTypeConversion = std::move(options.unknownTypeConversion);
    bufferAlignment = std::move(options.bufferAlignment);
  }
protected:
  ::mlir::Pass::Option<bool> allowReturnAllocsFromLoops{*this, "allow-return-allocs-from-loops", ::llvm::cl::desc("Allows returning/yielding new allocations from a loop."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> allowUnknownOps{*this, "allow-unknown-ops", ::llvm::cl::desc("Allows unknown (not bufferizable) ops in the input IR."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<unsigned> analysisFuzzerSeed{*this, "analysis-fuzzer-seed", ::llvm::cl::desc("Test only: Analyze ops in random order with a given seed (fuzzer)"), ::llvm::cl::init(0)};
  ::mlir::Pass::Option<std::string> analysisHeuristic{*this, "analysis-heuristic", ::llvm::cl::desc("Heuristic that control the IR traversal during analysis"), ::llvm::cl::init("bottom-up")};
  ::mlir::Pass::Option<bool> bufferizeFunctionBoundaries{*this, "bufferize-function-boundaries", ::llvm::cl::desc("Bufferize function boundaries (experimental)."), ::llvm::cl::init(0)};
  ::mlir::Pass::Option<bool> checkParallelRegions{*this, "check-parallel-regions", ::llvm::cl::desc("Account for parallel regions in RaW analysis."), ::llvm::cl::init(true)};
  ::mlir::Pass::Option<bool> copyBeforeWrite{*this, "copy-before-write", ::llvm::cl::desc("Skip the analysis. Make a buffer copy on every write."), ::llvm::cl::init(false)};
  ::mlir::Pass::ListOption<std::string> dialectFilter{*this, "dialect-filter", ::llvm::cl::desc("Restrict bufferization to ops from these dialects.")};
  ::mlir::Pass::Option<bool> dumpAliasSets{*this, "dump-alias-sets", ::llvm::cl::desc("Test only: Annotate tensor IR with alias sets"), ::llvm::cl::init(false)};
  ::mlir::Pass::ListOption<std::string> noAnalysisFuncFilter{*this, "no-analysis-func-filter", ::llvm::cl::desc("Skip analysis of functions with these symbol names.Set copyBeforeWrite to true when bufferizing them.")};
  ::mlir::Pass::Option<std::string> functionBoundaryTypeConversion{*this, "function-boundary-type-conversion", ::llvm::cl::desc("Controls layout maps when bufferizing function signatures."), ::llvm::cl::init("infer-layout-map")};
  ::mlir::Pass::Option<bool> mustInferMemorySpace{*this, "must-infer-memory-space", ::llvm::cl::desc("The memory space of an memref types must always be inferred. If unset, a default memory space of 0 is used otherwise."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> useEncodingForMemorySpace{*this, "use-encoding-for-memory-space", ::llvm::cl::desc("Use the Tensor encoding attribute for the memory space. Exclusive to the 'must-infer-memory-space' option"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> testAnalysisOnly{*this, "test-analysis-only", ::llvm::cl::desc("Test only: Only run inplaceability analysis and annotate IR"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> printConflicts{*this, "print-conflicts", ::llvm::cl::desc("Test only: Annotate IR with RaW conflicts. Requires test-analysis-only."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<std::string> unknownTypeConversion{*this, "unknown-type-conversion", ::llvm::cl::desc("Controls layout maps for non-inferrable memref types."), ::llvm::cl::init("fully-dynamic-layout-map")};
  ::mlir::Pass::Option<uint64_t> bufferAlignment{*this, "buffer-alignment", ::llvm::cl::desc("Sets the alignment of newly allocated buffers."), ::llvm::cl::init(64)};
  ::mlir::Pass::Statistic numBufferAlloc{this, "num-buffer-alloc", "Number of buffer allocations"};
  ::mlir::Pass::Statistic numTensorInPlace{this, "num-tensor-in-place", "Number of in-place tensor OpOperands"};
  ::mlir::Pass::Statistic numTensorOutOfPlace{this, "num-tensor-out-of-place", "Number of out-of-place tensor OpOperands"};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_ONESHOTBUFFERIZE
#endif // GEN_PASS_DEF_ONESHOTBUFFERIZE

//===----------------------------------------------------------------------===//
// OptimizeAllocationLiveness
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_OPTIMIZEALLOCATIONLIVENESS
#undef GEN_PASS_DECL_OPTIMIZEALLOCATIONLIVENESS
#endif // GEN_PASS_DECL_OPTIMIZEALLOCATIONLIVENESS
#ifdef GEN_PASS_DEF_OPTIMIZEALLOCATIONLIVENESS
namespace impl {

template <typename DerivedT>
class OptimizeAllocationLivenessBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = OptimizeAllocationLivenessBase;

  OptimizeAllocationLivenessBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  OptimizeAllocationLivenessBase(const OptimizeAllocationLivenessBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}
  OptimizeAllocationLivenessBase& operator=(const OptimizeAllocationLivenessBase &) = delete;
  OptimizeAllocationLivenessBase(OptimizeAllocationLivenessBase &&) = delete;
  OptimizeAllocationLivenessBase& operator=(OptimizeAllocationLivenessBase &&) = delete;
  ~OptimizeAllocationLivenessBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("optimize-allocation-liveness");
  }
  ::llvm::StringRef getArgument() const override { return "optimize-allocation-liveness"; }

  ::llvm::StringRef getDescription() const override { return "This pass optimizes the liveness of temp allocations in the input function"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OptimizeAllocationLiveness");
  }
  ::llvm::StringRef getName() const override { return "OptimizeAllocationLiveness"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OptimizeAllocationLivenessBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_OPTIMIZEALLOCATIONLIVENESS
#endif // GEN_PASS_DEF_OPTIMIZEALLOCATIONLIVENESS

//===----------------------------------------------------------------------===//
// OwnershipBasedBufferDeallocation
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_OWNERSHIPBASEDBUFFERDEALLOCATION
struct OwnershipBasedBufferDeallocationOptions {
  bool privateFuncDynamicOwnership = false;
};
#undef GEN_PASS_DECL_OWNERSHIPBASEDBUFFERDEALLOCATION
#endif // GEN_PASS_DECL_OWNERSHIPBASEDBUFFERDEALLOCATION
#ifdef GEN_PASS_DEF_OWNERSHIPBASEDBUFFERDEALLOCATION
namespace impl {

template <typename DerivedT>
class OwnershipBasedBufferDeallocationBase : public ::mlir::OperationPass<> {
public:
  using Base = OwnershipBasedBufferDeallocationBase;

  OwnershipBasedBufferDeallocationBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  OwnershipBasedBufferDeallocationBase(const OwnershipBasedBufferDeallocationBase &other) : ::mlir::OperationPass<>(other) {}
  OwnershipBasedBufferDeallocationBase& operator=(const OwnershipBasedBufferDeallocationBase &) = delete;
  OwnershipBasedBufferDeallocationBase(OwnershipBasedBufferDeallocationBase &&) = delete;
  OwnershipBasedBufferDeallocationBase& operator=(OwnershipBasedBufferDeallocationBase &&) = delete;
  ~OwnershipBasedBufferDeallocationBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("ownership-based-buffer-deallocation");
  }
  ::llvm::StringRef getArgument() const override { return "ownership-based-buffer-deallocation"; }

  ::llvm::StringRef getDescription() const override { return "Adds all required dealloc operations for all allocations in the input program"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OwnershipBasedBufferDeallocation");
  }
  ::llvm::StringRef getName() const override { return "OwnershipBasedBufferDeallocation"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::bufferization::BufferizationDialect>();
    registry.insert<mlir::arith::ArithDialect>();
    registry.insert<mlir::memref::MemRefDialect>();
    registry.insert<mlir::scf::SCFDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OwnershipBasedBufferDeallocationBase<DerivedT>)

  OwnershipBasedBufferDeallocationBase(OwnershipBasedBufferDeallocationOptions options) : OwnershipBasedBufferDeallocationBase() {
    privateFuncDynamicOwnership = std::move(options.privateFuncDynamicOwnership);
  }
protected:
  ::mlir::Pass::Option<bool> privateFuncDynamicOwnership{*this, "private-function-dynamic-ownership", ::llvm::cl::desc("Allows to add additional arguments to private functions to dynamically pass ownership of memrefs to callees. This can enable earlier deallocations."), ::llvm::cl::init(false)};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_OWNERSHIPBASEDBUFFERDEALLOCATION
#endif // GEN_PASS_DEF_OWNERSHIPBASEDBUFFERDEALLOCATION

//===----------------------------------------------------------------------===//
// PromoteBuffersToStack
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_PROMOTEBUFFERSTOSTACK
struct PromoteBuffersToStackOptions {
  unsigned maxAllocSizeInBytes = 1024;
  unsigned maxRankOfAllocatedMemRef = 1;
};
#undef GEN_PASS_DECL_PROMOTEBUFFERSTOSTACK
#endif // GEN_PASS_DECL_PROMOTEBUFFERSTOSTACK
#ifdef GEN_PASS_DEF_PROMOTEBUFFERSTOSTACK
namespace impl {

template <typename DerivedT>
class PromoteBuffersToStackBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = PromoteBuffersToStackBase;

  PromoteBuffersToStackBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  PromoteBuffersToStackBase(const PromoteBuffersToStackBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}
  PromoteBuffersToStackBase& operator=(const PromoteBuffersToStackBase &) = delete;
  PromoteBuffersToStackBase(PromoteBuffersToStackBase &&) = delete;
  PromoteBuffersToStackBase& operator=(PromoteBuffersToStackBase &&) = delete;
  ~PromoteBuffersToStackBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("promote-buffers-to-stack");
  }
  ::llvm::StringRef getArgument() const override { return "promote-buffers-to-stack"; }

  ::llvm::StringRef getDescription() const override { return "Promotes heap-based allocations to automatically managed stack-based allocations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("PromoteBuffersToStack");
  }
  ::llvm::StringRef getName() const override { return "PromoteBuffersToStack"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(PromoteBuffersToStackBase<DerivedT>)

  PromoteBuffersToStackBase(PromoteBuffersToStackOptions options) : PromoteBuffersToStackBase() {
    maxAllocSizeInBytes = std::move(options.maxAllocSizeInBytes);
    maxRankOfAllocatedMemRef = std::move(options.maxRankOfAllocatedMemRef);
  }
protected:
  ::mlir::Pass::Option<unsigned> maxAllocSizeInBytes{*this, "max-alloc-size-in-bytes", ::llvm::cl::desc("Maximal size in bytes to promote allocations to stack."), ::llvm::cl::init(1024)};
  ::mlir::Pass::Option<unsigned> maxRankOfAllocatedMemRef{*this, "max-rank-of-allocated-memref", ::llvm::cl::desc("Maximal memref rank to promote dynamic buffers."), ::llvm::cl::init(1)};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_PROMOTEBUFFERSTOSTACK
#endif // GEN_PASS_DEF_PROMOTEBUFFERSTOSTACK
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// BufferDeallocationSimplification Registration
//===----------------------------------------------------------------------===//

inline void registerBufferDeallocationSimplification() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createBufferDeallocationSimplificationPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerBufferDeallocationSimplificationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createBufferDeallocationSimplificationPass();
  });
}

//===----------------------------------------------------------------------===//
// BufferHoisting Registration
//===----------------------------------------------------------------------===//

inline void registerBufferHoisting() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createBufferHoistingPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerBufferHoistingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createBufferHoistingPass();
  });
}

//===----------------------------------------------------------------------===//
// BufferLoopHoisting Registration
//===----------------------------------------------------------------------===//

inline void registerBufferLoopHoisting() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createBufferLoopHoistingPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerBufferLoopHoistingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createBufferLoopHoistingPass();
  });
}

//===----------------------------------------------------------------------===//
// BufferResultsToOutParams Registration
//===----------------------------------------------------------------------===//

inline void registerBufferResultsToOutParams() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createBufferResultsToOutParamsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerBufferResultsToOutParamsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createBufferResultsToOutParamsPass();
  });
}

//===----------------------------------------------------------------------===//
// DropEquivalentBufferResults Registration
//===----------------------------------------------------------------------===//

inline void registerDropEquivalentBufferResults() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createDropEquivalentBufferResultsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerDropEquivalentBufferResultsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createDropEquivalentBufferResultsPass();
  });
}

//===----------------------------------------------------------------------===//
// EmptyTensorElimination Registration
//===----------------------------------------------------------------------===//

inline void registerEmptyTensorElimination() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createEmptyTensorEliminationPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerEmptyTensorEliminationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createEmptyTensorEliminationPass();
  });
}

//===----------------------------------------------------------------------===//
// EmptyTensorToAllocTensor Registration
//===----------------------------------------------------------------------===//

inline void registerEmptyTensorToAllocTensor() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createEmptyTensorToAllocTensorPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerEmptyTensorToAllocTensorPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createEmptyTensorToAllocTensorPass();
  });
}

//===----------------------------------------------------------------------===//
// LowerDeallocations Registration
//===----------------------------------------------------------------------===//

inline void registerLowerDeallocations() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createLowerDeallocationsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerLowerDeallocationsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createLowerDeallocationsPass();
  });
}

//===----------------------------------------------------------------------===//
// OneShotBufferize Registration
//===----------------------------------------------------------------------===//

inline void registerOneShotBufferize() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createOneShotBufferizePass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerOneShotBufferizePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createOneShotBufferizePass();
  });
}

//===----------------------------------------------------------------------===//
// OptimizeAllocationLiveness Registration
//===----------------------------------------------------------------------===//

inline void registerOptimizeAllocationLiveness() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createOptimizeAllocationLivenessPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerOptimizeAllocationLivenessPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createOptimizeAllocationLivenessPass();
  });
}

//===----------------------------------------------------------------------===//
// OwnershipBasedBufferDeallocation Registration
//===----------------------------------------------------------------------===//

inline void registerOwnershipBasedBufferDeallocation() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createOwnershipBasedBufferDeallocationPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerOwnershipBasedBufferDeallocationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createOwnershipBasedBufferDeallocationPass();
  });
}

//===----------------------------------------------------------------------===//
// PromoteBuffersToStack Registration
//===----------------------------------------------------------------------===//

inline void registerPromoteBuffersToStack() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createPromoteBuffersToStackPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerPromoteBuffersToStackPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::bufferization::createPromoteBuffersToStackPass();
  });
}

//===----------------------------------------------------------------------===//
// Bufferization Registration
//===----------------------------------------------------------------------===//

inline void registerBufferizationPasses() {
  registerBufferDeallocationSimplification();
  registerBufferHoisting();
  registerBufferLoopHoisting();
  registerBufferResultsToOutParams();
  registerDropEquivalentBufferResults();
  registerEmptyTensorElimination();
  registerEmptyTensorToAllocTensor();
  registerLowerDeallocations();
  registerOneShotBufferize();
  registerOptimizeAllocationLiveness();
  registerOwnershipBasedBufferDeallocation();
  registerPromoteBuffersToStack();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
// Deprecated. Please use the new per-pass macros.
#ifdef GEN_PASS_CLASSES

template <typename DerivedT>
class BufferDeallocationSimplificationBase : public ::mlir::OperationPass<> {
public:
  using Base = BufferDeallocationSimplificationBase;

  BufferDeallocationSimplificationBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  BufferDeallocationSimplificationBase(const BufferDeallocationSimplificationBase &other) : ::mlir::OperationPass<>(other) {}
  BufferDeallocationSimplificationBase& operator=(const BufferDeallocationSimplificationBase &) = delete;
  BufferDeallocationSimplificationBase(BufferDeallocationSimplificationBase &&) = delete;
  BufferDeallocationSimplificationBase& operator=(BufferDeallocationSimplificationBase &&) = delete;
  ~BufferDeallocationSimplificationBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-deallocation-simplification");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-deallocation-simplification"; }

  ::llvm::StringRef getDescription() const override { return "Optimizes `bufferization.dealloc` operation for more efficient codegen"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferDeallocationSimplification");
  }
  ::llvm::StringRef getName() const override { return "BufferDeallocationSimplification"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::bufferization::BufferizationDialect>();
    registry.insert<mlir::arith::ArithDialect>();
    registry.insert<mlir::memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferDeallocationSimplificationBase<DerivedT>)

protected:
};

template <typename DerivedT>
class BufferHoistingBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = BufferHoistingBase;

  BufferHoistingBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  BufferHoistingBase(const BufferHoistingBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}
  BufferHoistingBase& operator=(const BufferHoistingBase &) = delete;
  BufferHoistingBase(BufferHoistingBase &&) = delete;
  BufferHoistingBase& operator=(BufferHoistingBase &&) = delete;
  ~BufferHoistingBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-hoisting");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-hoisting"; }

  ::llvm::StringRef getDescription() const override { return "Optimizes placement of allocation operations by moving them into common dominators and out of nested regions"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferHoisting");
  }
  ::llvm::StringRef getName() const override { return "BufferHoisting"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferHoistingBase<DerivedT>)

protected:
};

template <typename DerivedT>
class BufferLoopHoistingBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = BufferLoopHoistingBase;

  BufferLoopHoistingBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  BufferLoopHoistingBase(const BufferLoopHoistingBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}
  BufferLoopHoistingBase& operator=(const BufferLoopHoistingBase &) = delete;
  BufferLoopHoistingBase(BufferLoopHoistingBase &&) = delete;
  BufferLoopHoistingBase& operator=(BufferLoopHoistingBase &&) = delete;
  ~BufferLoopHoistingBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-loop-hoisting");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-loop-hoisting"; }

  ::llvm::StringRef getDescription() const override { return "Optimizes placement of allocation operations by moving them out of loop nests"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferLoopHoisting");
  }
  ::llvm::StringRef getName() const override { return "BufferLoopHoisting"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferLoopHoistingBase<DerivedT>)

protected:
};

template <typename DerivedT>
class BufferResultsToOutParamsBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = BufferResultsToOutParamsBase;

  BufferResultsToOutParamsBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  BufferResultsToOutParamsBase(const BufferResultsToOutParamsBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  BufferResultsToOutParamsBase& operator=(const BufferResultsToOutParamsBase &) = delete;
  BufferResultsToOutParamsBase(BufferResultsToOutParamsBase &&) = delete;
  BufferResultsToOutParamsBase& operator=(BufferResultsToOutParamsBase &&) = delete;
  ~BufferResultsToOutParamsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-results-to-out-params");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-results-to-out-params"; }

  ::llvm::StringRef getDescription() const override { return "Converts memref-typed function results to out-params"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferResultsToOutParams");
  }
  ::llvm::StringRef getName() const override { return "BufferResultsToOutParams"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferResultsToOutParamsBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> addResultAttribute{*this, "add-result-attr", ::llvm::cl::desc("Add the attribute 'bufferize.result' to all output parameters."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> hoistStaticAllocs{*this, "hoist-static-allocs", ::llvm::cl::desc("Hoist static allocations to call sites."), ::llvm::cl::init(false)};
};

template <typename DerivedT>
class DropEquivalentBufferResultsBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = DropEquivalentBufferResultsBase;

  DropEquivalentBufferResultsBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  DropEquivalentBufferResultsBase(const DropEquivalentBufferResultsBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  DropEquivalentBufferResultsBase& operator=(const DropEquivalentBufferResultsBase &) = delete;
  DropEquivalentBufferResultsBase(DropEquivalentBufferResultsBase &&) = delete;
  DropEquivalentBufferResultsBase& operator=(DropEquivalentBufferResultsBase &&) = delete;
  ~DropEquivalentBufferResultsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("drop-equivalent-buffer-results");
  }
  ::llvm::StringRef getArgument() const override { return "drop-equivalent-buffer-results"; }

  ::llvm::StringRef getDescription() const override { return "Remove MemRef return values that are equivalent to a bbArg"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("DropEquivalentBufferResults");
  }
  ::llvm::StringRef getName() const override { return "DropEquivalentBufferResults"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(DropEquivalentBufferResultsBase<DerivedT>)

protected:
};

template <typename DerivedT>
class EmptyTensorEliminationBase : public ::mlir::OperationPass<> {
public:
  using Base = EmptyTensorEliminationBase;

  EmptyTensorEliminationBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  EmptyTensorEliminationBase(const EmptyTensorEliminationBase &other) : ::mlir::OperationPass<>(other) {}
  EmptyTensorEliminationBase& operator=(const EmptyTensorEliminationBase &) = delete;
  EmptyTensorEliminationBase(EmptyTensorEliminationBase &&) = delete;
  EmptyTensorEliminationBase& operator=(EmptyTensorEliminationBase &&) = delete;
  ~EmptyTensorEliminationBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("eliminate-empty-tensors");
  }
  ::llvm::StringRef getArgument() const override { return "eliminate-empty-tensors"; }

  ::llvm::StringRef getDescription() const override { return "Try to eliminate all tensor.empty ops."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("EmptyTensorElimination");
  }
  ::llvm::StringRef getName() const override { return "EmptyTensorElimination"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(EmptyTensorEliminationBase<DerivedT>)

protected:
};

template <typename DerivedT>
class EmptyTensorToAllocTensorBase : public ::mlir::OperationPass<> {
public:
  using Base = EmptyTensorToAllocTensorBase;

  EmptyTensorToAllocTensorBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  EmptyTensorToAllocTensorBase(const EmptyTensorToAllocTensorBase &other) : ::mlir::OperationPass<>(other) {}
  EmptyTensorToAllocTensorBase& operator=(const EmptyTensorToAllocTensorBase &) = delete;
  EmptyTensorToAllocTensorBase(EmptyTensorToAllocTensorBase &&) = delete;
  EmptyTensorToAllocTensorBase& operator=(EmptyTensorToAllocTensorBase &&) = delete;
  ~EmptyTensorToAllocTensorBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("empty-tensor-to-alloc-tensor");
  }
  ::llvm::StringRef getArgument() const override { return "empty-tensor-to-alloc-tensor"; }

  ::llvm::StringRef getDescription() const override { return "Replace all empty ops by alloc_tensor ops."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("EmptyTensorToAllocTensor");
  }
  ::llvm::StringRef getName() const override { return "EmptyTensorToAllocTensor"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<tensor::TensorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(EmptyTensorToAllocTensorBase<DerivedT>)

protected:
};

template <typename DerivedT>
class LowerDeallocationsBase : public ::mlir::OperationPass<> {
public:
  using Base = LowerDeallocationsBase;

  LowerDeallocationsBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  LowerDeallocationsBase(const LowerDeallocationsBase &other) : ::mlir::OperationPass<>(other) {}
  LowerDeallocationsBase& operator=(const LowerDeallocationsBase &) = delete;
  LowerDeallocationsBase(LowerDeallocationsBase &&) = delete;
  LowerDeallocationsBase& operator=(LowerDeallocationsBase &&) = delete;
  ~LowerDeallocationsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("bufferization-lower-deallocations");
  }
  ::llvm::StringRef getArgument() const override { return "bufferization-lower-deallocations"; }

  ::llvm::StringRef getDescription() const override { return "Lowers `bufferization.dealloc` operations to `memref.dealloc`operations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LowerDeallocations");
  }
  ::llvm::StringRef getName() const override { return "LowerDeallocations"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<arith::ArithDialect>();
    registry.insert<memref::MemRefDialect>();
    registry.insert<scf::SCFDialect>();
    registry.insert<func::FuncDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LowerDeallocationsBase<DerivedT>)

protected:
};

template <typename DerivedT>
class OneShotBufferizeBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = OneShotBufferizeBase;

  OneShotBufferizeBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  OneShotBufferizeBase(const OneShotBufferizeBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  OneShotBufferizeBase& operator=(const OneShotBufferizeBase &) = delete;
  OneShotBufferizeBase(OneShotBufferizeBase &&) = delete;
  OneShotBufferizeBase& operator=(OneShotBufferizeBase &&) = delete;
  ~OneShotBufferizeBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("one-shot-bufferize");
  }
  ::llvm::StringRef getArgument() const override { return "one-shot-bufferize"; }

  ::llvm::StringRef getDescription() const override { return "One-Shot Bufferize"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OneShotBufferize");
  }
  ::llvm::StringRef getName() const override { return "OneShotBufferize"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OneShotBufferizeBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> allowReturnAllocsFromLoops{*this, "allow-return-allocs-from-loops", ::llvm::cl::desc("Allows returning/yielding new allocations from a loop."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> allowUnknownOps{*this, "allow-unknown-ops", ::llvm::cl::desc("Allows unknown (not bufferizable) ops in the input IR."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<unsigned> analysisFuzzerSeed{*this, "analysis-fuzzer-seed", ::llvm::cl::desc("Test only: Analyze ops in random order with a given seed (fuzzer)"), ::llvm::cl::init(0)};
  ::mlir::Pass::Option<std::string> analysisHeuristic{*this, "analysis-heuristic", ::llvm::cl::desc("Heuristic that control the IR traversal during analysis"), ::llvm::cl::init("bottom-up")};
  ::mlir::Pass::Option<bool> bufferizeFunctionBoundaries{*this, "bufferize-function-boundaries", ::llvm::cl::desc("Bufferize function boundaries (experimental)."), ::llvm::cl::init(0)};
  ::mlir::Pass::Option<bool> checkParallelRegions{*this, "check-parallel-regions", ::llvm::cl::desc("Account for parallel regions in RaW analysis."), ::llvm::cl::init(true)};
  ::mlir::Pass::Option<bool> copyBeforeWrite{*this, "copy-before-write", ::llvm::cl::desc("Skip the analysis. Make a buffer copy on every write."), ::llvm::cl::init(false)};
  ::mlir::Pass::ListOption<std::string> dialectFilter{*this, "dialect-filter", ::llvm::cl::desc("Restrict bufferization to ops from these dialects.")};
  ::mlir::Pass::Option<bool> dumpAliasSets{*this, "dump-alias-sets", ::llvm::cl::desc("Test only: Annotate tensor IR with alias sets"), ::llvm::cl::init(false)};
  ::mlir::Pass::ListOption<std::string> noAnalysisFuncFilter{*this, "no-analysis-func-filter", ::llvm::cl::desc("Skip analysis of functions with these symbol names.Set copyBeforeWrite to true when bufferizing them.")};
  ::mlir::Pass::Option<std::string> functionBoundaryTypeConversion{*this, "function-boundary-type-conversion", ::llvm::cl::desc("Controls layout maps when bufferizing function signatures."), ::llvm::cl::init("infer-layout-map")};
  ::mlir::Pass::Option<bool> mustInferMemorySpace{*this, "must-infer-memory-space", ::llvm::cl::desc("The memory space of an memref types must always be inferred. If unset, a default memory space of 0 is used otherwise."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> useEncodingForMemorySpace{*this, "use-encoding-for-memory-space", ::llvm::cl::desc("Use the Tensor encoding attribute for the memory space. Exclusive to the 'must-infer-memory-space' option"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> testAnalysisOnly{*this, "test-analysis-only", ::llvm::cl::desc("Test only: Only run inplaceability analysis and annotate IR"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> printConflicts{*this, "print-conflicts", ::llvm::cl::desc("Test only: Annotate IR with RaW conflicts. Requires test-analysis-only."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<std::string> unknownTypeConversion{*this, "unknown-type-conversion", ::llvm::cl::desc("Controls layout maps for non-inferrable memref types."), ::llvm::cl::init("fully-dynamic-layout-map")};
  ::mlir::Pass::Option<uint64_t> bufferAlignment{*this, "buffer-alignment", ::llvm::cl::desc("Sets the alignment of newly allocated buffers."), ::llvm::cl::init(64)};
  ::mlir::Pass::Statistic numBufferAlloc{this, "num-buffer-alloc", "Number of buffer allocations"};
  ::mlir::Pass::Statistic numTensorInPlace{this, "num-tensor-in-place", "Number of in-place tensor OpOperands"};
  ::mlir::Pass::Statistic numTensorOutOfPlace{this, "num-tensor-out-of-place", "Number of out-of-place tensor OpOperands"};
};

template <typename DerivedT>
class OptimizeAllocationLivenessBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = OptimizeAllocationLivenessBase;

  OptimizeAllocationLivenessBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  OptimizeAllocationLivenessBase(const OptimizeAllocationLivenessBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}
  OptimizeAllocationLivenessBase& operator=(const OptimizeAllocationLivenessBase &) = delete;
  OptimizeAllocationLivenessBase(OptimizeAllocationLivenessBase &&) = delete;
  OptimizeAllocationLivenessBase& operator=(OptimizeAllocationLivenessBase &&) = delete;
  ~OptimizeAllocationLivenessBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("optimize-allocation-liveness");
  }
  ::llvm::StringRef getArgument() const override { return "optimize-allocation-liveness"; }

  ::llvm::StringRef getDescription() const override { return "This pass optimizes the liveness of temp allocations in the input function"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OptimizeAllocationLiveness");
  }
  ::llvm::StringRef getName() const override { return "OptimizeAllocationLiveness"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OptimizeAllocationLivenessBase<DerivedT>)

protected:
};

template <typename DerivedT>
class OwnershipBasedBufferDeallocationBase : public ::mlir::OperationPass<> {
public:
  using Base = OwnershipBasedBufferDeallocationBase;

  OwnershipBasedBufferDeallocationBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  OwnershipBasedBufferDeallocationBase(const OwnershipBasedBufferDeallocationBase &other) : ::mlir::OperationPass<>(other) {}
  OwnershipBasedBufferDeallocationBase& operator=(const OwnershipBasedBufferDeallocationBase &) = delete;
  OwnershipBasedBufferDeallocationBase(OwnershipBasedBufferDeallocationBase &&) = delete;
  OwnershipBasedBufferDeallocationBase& operator=(OwnershipBasedBufferDeallocationBase &&) = delete;
  ~OwnershipBasedBufferDeallocationBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("ownership-based-buffer-deallocation");
  }
  ::llvm::StringRef getArgument() const override { return "ownership-based-buffer-deallocation"; }

  ::llvm::StringRef getDescription() const override { return "Adds all required dealloc operations for all allocations in the input program"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OwnershipBasedBufferDeallocation");
  }
  ::llvm::StringRef getName() const override { return "OwnershipBasedBufferDeallocation"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::bufferization::BufferizationDialect>();
    registry.insert<mlir::arith::ArithDialect>();
    registry.insert<mlir::memref::MemRefDialect>();
    registry.insert<mlir::scf::SCFDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OwnershipBasedBufferDeallocationBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> privateFuncDynamicOwnership{*this, "private-function-dynamic-ownership", ::llvm::cl::desc("Allows to add additional arguments to private functions to dynamically pass ownership of memrefs to callees. This can enable earlier deallocations."), ::llvm::cl::init(false)};
};

template <typename DerivedT>
class PromoteBuffersToStackBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = PromoteBuffersToStackBase;

  PromoteBuffersToStackBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  PromoteBuffersToStackBase(const PromoteBuffersToStackBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}
  PromoteBuffersToStackBase& operator=(const PromoteBuffersToStackBase &) = delete;
  PromoteBuffersToStackBase(PromoteBuffersToStackBase &&) = delete;
  PromoteBuffersToStackBase& operator=(PromoteBuffersToStackBase &&) = delete;
  ~PromoteBuffersToStackBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("promote-buffers-to-stack");
  }
  ::llvm::StringRef getArgument() const override { return "promote-buffers-to-stack"; }

  ::llvm::StringRef getDescription() const override { return "Promotes heap-based allocations to automatically managed stack-based allocations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("PromoteBuffersToStack");
  }
  ::llvm::StringRef getName() const override { return "PromoteBuffersToStack"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(PromoteBuffersToStackBase<DerivedT>)

protected:
  ::mlir::Pass::Option<unsigned> maxAllocSizeInBytes{*this, "max-alloc-size-in-bytes", ::llvm::cl::desc("Maximal size in bytes to promote allocations to stack."), ::llvm::cl::init(1024)};
  ::mlir::Pass::Option<unsigned> maxRankOfAllocatedMemRef{*this, "max-rank-of-allocated-memref", ::llvm::cl::desc("Maximal memref rank to promote dynamic buffers."), ::llvm::cl::init(1)};
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
